/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.worker;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.pulsar.client.util.ExecutorProvider;
import org.apache.pulsar.functions.worker.LeaderService;
import org.apache.pulsar.shade.org.apache.pulsar.common.util.Runnables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterServiceCoordinator
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(ClusterServiceCoordinator.class);
    private final String workerId;
    private final Map<String, TimerTaskInfo> tasks = new HashMap<String, TimerTaskInfo>();
    private final ScheduledExecutorService executor;
    private final LeaderService leaderService;
    private final Supplier<Boolean> isLeader;

    public ClusterServiceCoordinator(String workerId, LeaderService leaderService, Supplier<Boolean> isLeader) {
        this.workerId = workerId;
        this.leaderService = leaderService;
        this.isLeader = isLeader;
        this.executor = Executors.newSingleThreadScheduledExecutor(new ExecutorProvider.ExtendedThreadFactory("cluster-service-coordinator-timer"));
    }

    public void addTask(String taskName, long interval, Runnable task) {
        this.tasks.put(taskName, new TimerTaskInfo(interval, task));
    }

    public void start() {
        log.info("/** Starting cluster service coordinator **/");
        for (Map.Entry<String, TimerTaskInfo> entry : this.tasks.entrySet()) {
            TimerTaskInfo timerTaskInfo = entry.getValue();
            String taskName = entry.getKey();
            this.executor.scheduleAtFixedRate(Runnables.catchingAndLoggingThrowables(() -> {
                if (this.isLeader.get().booleanValue()) {
                    try {
                        timerTaskInfo.getTask().run();
                    }
                    catch (Exception e) {
                        log.error("Cluster timer task {} failed with exception.", (Object)taskName, (Object)e);
                    }
                }
            }), timerTaskInfo.getInterval(), timerTaskInfo.getInterval(), TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public void close() {
        log.info("Stopping Cluster Service Coordinator for worker {}", (Object)this.workerId);
        this.executor.shutdown();
        log.info("Stopped Cluster Service Coordinator for worker {}", (Object)this.workerId);
    }

    private static class TimerTaskInfo {
        private long interval;
        private Runnable task;

        public TimerTaskInfo(long interval, Runnable task) {
            this.interval = interval;
            this.task = task;
        }

        public long getInterval() {
            return this.interval;
        }

        public Runnable getTask() {
            return this.task;
        }

        public void setInterval(long interval) {
            this.interval = interval;
        }

        public void setTask(Runnable task) {
            this.task = task;
        }
    }
}

