/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.worker.rest;

import java.util.function.Supplier;
import org.apache.pulsar.functions.worker.WorkerService;
import org.apache.pulsar.shade.io.swagger.annotations.ApiOperation;
import org.apache.pulsar.shade.io.swagger.annotations.ApiResponse;
import org.apache.pulsar.shade.io.swagger.annotations.ApiResponses;
import org.apache.pulsar.shade.javax.servlet.ServletContext;
import org.apache.pulsar.shade.javax.servlet.http.HttpServletRequest;
import org.apache.pulsar.shade.javax.ws.rs.GET;
import org.apache.pulsar.shade.javax.ws.rs.Path;
import org.apache.pulsar.shade.javax.ws.rs.WebApplicationException;
import org.apache.pulsar.shade.javax.ws.rs.core.Context;
import org.apache.pulsar.shade.javax.ws.rs.core.Response;

@Path(value="/")
public class WorkerReadinessResource
implements Supplier<WorkerService> {
    public static final String ATTRIBUTE_WORKER_SERVICE = "worker";
    private WorkerService workerService;
    @Context
    protected ServletContext servletContext;
    @Context
    protected HttpServletRequest httpRequest;

    @Override
    public synchronized WorkerService get() {
        if (this.workerService == null) {
            this.workerService = (WorkerService)this.servletContext.getAttribute(ATTRIBUTE_WORKER_SERVICE);
        }
        return this.workerService;
    }

    @GET
    @ApiOperation(value="Determines whether the worker service is initialized and ready for use", response=Boolean.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid request"), @ApiResponse(code=408, message="Request timeout")})
    @Path(value="/initialized")
    public boolean isInitialized() {
        if (!this.get().isInitialized()) {
            throw new WebApplicationException(Response.Status.SERVICE_UNAVAILABLE);
        }
        return true;
    }
}

