/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.com.carrotsearch.hppc;

import org.apache.pulsar.shade.com.carrotsearch.hppc.BitMixer;
import org.apache.pulsar.shade.com.carrotsearch.hppc.ByteLongHashMap;
import org.apache.pulsar.shade.com.carrotsearch.hppc.HashOrderMixing;

public class ByteLongScatterMap
extends ByteLongHashMap {
    public ByteLongScatterMap() {
        this(4);
    }

    public ByteLongScatterMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public ByteLongScatterMap(int expectedElements, double loadFactor) {
        super(expectedElements, loadFactor, HashOrderMixing.none());
    }

    @Override
    protected int hashKey(byte key) {
        return BitMixer.mixPhi(key);
    }

    public static ByteLongScatterMap from(byte[] keys, long[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        ByteLongScatterMap map = new ByteLongScatterMap(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }
}

