/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.com.carrotsearch.hppc;

import org.apache.pulsar.shade.com.carrotsearch.hppc.BitMixer;
import org.apache.pulsar.shade.com.carrotsearch.hppc.HashOrderMixing;
import org.apache.pulsar.shade.com.carrotsearch.hppc.ShortByteHashMap;

public class ShortByteScatterMap
extends ShortByteHashMap {
    public ShortByteScatterMap() {
        this(4);
    }

    public ShortByteScatterMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public ShortByteScatterMap(int expectedElements, double loadFactor) {
        super(expectedElements, loadFactor, HashOrderMixing.none());
    }

    @Override
    protected int hashKey(short key) {
        return BitMixer.mixPhi(key);
    }

    public static ShortByteScatterMap from(short[] keys, byte[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        ShortByteScatterMap map = new ShortByteScatterMap(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }
}

