/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.io.prometheus.client;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.pulsar.shade.io.prometheus.client.Collector;
import org.apache.pulsar.shade.io.prometheus.client.CollectorRegistry;

public abstract class SimpleCollector<Child>
extends Collector {
    protected final String fullname;
    protected final String help;
    protected final List<String> labelNames;
    protected final ConcurrentMap<List<String>, Child> children = new ConcurrentHashMap<List<String>, Child>();
    protected Child noLabelsChild;

    public Child labels(String ... labelValues) {
        if (labelValues.length != this.labelNames.size()) {
            throw new IllegalArgumentException("Incorrect number of labels.");
        }
        for (String label : labelValues) {
            if (label != null) continue;
            throw new IllegalArgumentException("Label cannot be null.");
        }
        List<String> key = Arrays.asList(labelValues);
        Object c = this.children.get(key);
        if (c != null) {
            return (Child)c;
        }
        Child c2 = this.newChild();
        Child tmp = this.children.putIfAbsent(key, c2);
        return tmp == null ? c2 : tmp;
    }

    public void remove(String ... labelValues) {
        this.children.remove(Arrays.asList(labelValues));
        this.initializeNoLabelsChild();
    }

    public void clear() {
        this.children.clear();
        this.initializeNoLabelsChild();
    }

    protected void initializeNoLabelsChild() {
        if (this.labelNames.size() == 0) {
            this.noLabelsChild = this.labels(new String[0]);
        }
    }

    public <T extends Collector> T setChild(Child child, String ... labelValues) {
        if (labelValues.length != this.labelNames.size()) {
            throw new IllegalArgumentException("Incorrect number of labels.");
        }
        this.children.put(Arrays.asList(labelValues), child);
        return (T)this;
    }

    protected abstract Child newChild();

    protected List<Collector.MetricFamilySamples> familySamplesList(Collector.Type type, List<Collector.MetricFamilySamples.Sample> samples) {
        Collector.MetricFamilySamples mfs = new Collector.MetricFamilySamples(this.fullname, type, this.help, samples);
        ArrayList<Collector.MetricFamilySamples> mfsList = new ArrayList<Collector.MetricFamilySamples>(1);
        mfsList.add(mfs);
        return mfsList;
    }

    protected SimpleCollector(Builder b) {
        if (b.name.isEmpty()) {
            throw new IllegalStateException("Name hasn't been set.");
        }
        String name = b.name;
        if (!b.subsystem.isEmpty()) {
            name = b.subsystem + '_' + name;
        }
        if (!b.namespace.isEmpty()) {
            name = b.namespace + '_' + name;
        }
        this.fullname = name;
        SimpleCollector.checkMetricName(this.fullname);
        if (b.help.isEmpty()) {
            throw new IllegalStateException("Help hasn't been set.");
        }
        this.help = b.help;
        this.labelNames = Arrays.asList(b.labelNames);
        for (String n : this.labelNames) {
            SimpleCollector.checkMetricLabelName(n);
        }
        if (!b.dontInitializeNoLabelsChild) {
            this.initializeNoLabelsChild();
        }
    }

    public static abstract class Builder<B extends Builder<B, C>, C extends SimpleCollector> {
        String namespace = "";
        String subsystem = "";
        String name = "";
        String fullname = "";
        String help = "";
        String[] labelNames = new String[0];
        boolean dontInitializeNoLabelsChild;

        public B name(String name) {
            this.name = name;
            return (B)this;
        }

        public B subsystem(String subsystem) {
            this.subsystem = subsystem;
            return (B)this;
        }

        public B namespace(String namespace) {
            this.namespace = namespace;
            return (B)this;
        }

        public B help(String help) {
            this.help = help;
            return (B)this;
        }

        public B labelNames(String ... labelNames) {
            this.labelNames = labelNames;
            return (B)this;
        }

        public abstract C create();

        public C register() {
            return this.register(CollectorRegistry.defaultRegistry);
        }

        public C register(CollectorRegistry registry) {
            C sc = this.create();
            registry.register((Collector)sc);
            return sc;
        }
    }
}

