/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.io.prometheus.client;

import java.util.concurrent.TimeUnit;
import org.apache.pulsar.shade.io.prometheus.client.CKMSQuantiles;

class TimeWindowQuantiles {
    private final CKMSQuantiles.Quantile[] quantiles;
    private final CKMSQuantiles[] ringBuffer;
    private int currentBucket;
    private long lastRotateTimestampMillis;
    private final long durationBetweenRotatesMillis;

    public TimeWindowQuantiles(CKMSQuantiles.Quantile[] quantiles, long maxAgeSeconds, int ageBuckets) {
        this.quantiles = quantiles;
        this.ringBuffer = new CKMSQuantiles[ageBuckets];
        for (int i = 0; i < ageBuckets; ++i) {
            this.ringBuffer[i] = new CKMSQuantiles(quantiles);
        }
        this.currentBucket = 0;
        this.lastRotateTimestampMillis = System.currentTimeMillis();
        this.durationBetweenRotatesMillis = TimeUnit.SECONDS.toMillis(maxAgeSeconds) / (long)ageBuckets;
    }

    public double get(double q) {
        CKMSQuantiles currentBucket = this.rotate();
        return currentBucket.get(q);
    }

    public void insert(double value) {
        this.rotate();
        for (CKMSQuantiles ckmsQuantiles : this.ringBuffer) {
            ckmsQuantiles.insert(value);
        }
    }

    private synchronized CKMSQuantiles rotate() {
        long timeSinceLastRotateMillis = System.currentTimeMillis() - this.lastRotateTimestampMillis;
        while (timeSinceLastRotateMillis > this.durationBetweenRotatesMillis) {
            this.ringBuffer[this.currentBucket] = new CKMSQuantiles(this.quantiles);
            if (++this.currentBucket >= this.ringBuffer.length) {
                this.currentBucket = 0;
            }
            timeSinceLastRotateMillis -= this.durationBetweenRotatesMillis;
            this.lastRotateTimestampMillis += this.durationBetweenRotatesMillis;
        }
        return this.ringBuffer[this.currentBucket];
    }
}

