/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.io.swagger.util;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.pulsar.shade.com.fasterxml.jackson.core.JsonParser;
import org.apache.pulsar.shade.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.pulsar.shade.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.pulsar.shade.com.fasterxml.jackson.databind.JsonDeserializer;
import org.apache.pulsar.shade.com.fasterxml.jackson.databind.JsonNode;
import org.apache.pulsar.shade.com.fasterxml.jackson.databind.node.ArrayNode;
import org.apache.pulsar.shade.com.fasterxml.jackson.databind.node.DoubleNode;
import org.apache.pulsar.shade.com.fasterxml.jackson.databind.node.FloatNode;
import org.apache.pulsar.shade.com.fasterxml.jackson.databind.node.IntNode;
import org.apache.pulsar.shade.com.fasterxml.jackson.databind.node.JsonNodeType;
import org.apache.pulsar.shade.com.fasterxml.jackson.databind.node.LongNode;
import org.apache.pulsar.shade.com.fasterxml.jackson.databind.node.NumericNode;
import org.apache.pulsar.shade.com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.pulsar.shade.com.fasterxml.jackson.databind.node.TextNode;
import org.apache.pulsar.shade.io.swagger.models.Xml;
import org.apache.pulsar.shade.io.swagger.models.properties.ArrayProperty;
import org.apache.pulsar.shade.io.swagger.models.properties.BooleanValueProperty;
import org.apache.pulsar.shade.io.swagger.models.properties.ComposedProperty;
import org.apache.pulsar.shade.io.swagger.models.properties.MapProperty;
import org.apache.pulsar.shade.io.swagger.models.properties.ObjectProperty;
import org.apache.pulsar.shade.io.swagger.models.properties.Property;
import org.apache.pulsar.shade.io.swagger.models.properties.PropertyBuilder;
import org.apache.pulsar.shade.io.swagger.models.properties.RefProperty;
import org.apache.pulsar.shade.io.swagger.util.Json;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyDeserializer
extends JsonDeserializer<Property> {
    Logger LOGGER = LoggerFactory.getLogger(PropertyDeserializer.class);

    private static String getString(JsonNode node, PropertyBuilder.PropertyId type) {
        JsonNode detailNode = PropertyDeserializer.getDetailNode(node, type);
        return detailNode == null ? null : detailNode.asText();
    }

    private static Integer getInteger(JsonNode node, PropertyBuilder.PropertyId type) {
        JsonNode detailNode = PropertyDeserializer.getDetailNode(node, type);
        return detailNode == null ? null : Integer.valueOf(detailNode.intValue());
    }

    private static Double getDouble(JsonNode node, PropertyBuilder.PropertyId type) {
        JsonNode detailNode = PropertyDeserializer.getDetailNode(node, type);
        return detailNode == null ? null : Double.valueOf(detailNode.doubleValue());
    }

    private static BigDecimal getBigDecimal(JsonNode node, PropertyBuilder.PropertyId type) {
        JsonNode detailNode = PropertyDeserializer.getDetailNode(node, type);
        return detailNode == null ? null : new BigDecimal(detailNode.toString());
    }

    private static Boolean getBoolean(JsonNode node, PropertyBuilder.PropertyId type) {
        JsonNode detailNode = PropertyDeserializer.getDetailNode(node, type);
        return detailNode == null ? null : Boolean.valueOf(detailNode.booleanValue());
    }

    private static List<String> getEnum(JsonNode node, PropertyBuilder.PropertyId type) {
        ArrayList<String> result = new ArrayList<String>();
        JsonNode detailNode = PropertyDeserializer.getDetailNode(node, type);
        if (detailNode != null) {
            ArrayNode an = (ArrayNode)detailNode;
            for (JsonNode child : an) {
                if (!(child instanceof TextNode) && !(child instanceof NumericNode) && !(child instanceof IntNode) && !(child instanceof LongNode) && !(child instanceof DoubleNode) && !(child instanceof FloatNode)) continue;
                result.add(child.asText());
            }
        }
        return result.isEmpty() ? null : result;
    }

    private static Map<String, Object> getVendorExtensions(JsonNode node) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Iterator<String> fieldNameIter = node.fieldNames();
        while (fieldNameIter.hasNext()) {
            String fieldName = fieldNameIter.next();
            if (!fieldName.startsWith("x-")) continue;
            JsonNode extensionField = node.get(fieldName);
            Object extensionObject = Json.mapper().convertValue((Object)extensionField, Object.class);
            result.put(fieldName, extensionObject);
        }
        return result;
    }

    private static List<String> getRequired(JsonNode node, PropertyBuilder.PropertyId type) {
        ArrayList<String> result = new ArrayList<String>();
        JsonNode detailNode = PropertyDeserializer.getDetailNode(node, type);
        if (detailNode == null) {
            return result;
        }
        if (detailNode.isArray()) {
            ArrayNode arrayNode = (ArrayNode)detailNode;
            for (JsonNode item : arrayNode) {
                result.add(item.asText());
            }
            return result;
        }
        throw new RuntimeException("Required property should be a list");
    }

    private static JsonNode getDetailNode(JsonNode node, PropertyBuilder.PropertyId type) {
        return node.get(type.getPropertyName());
    }

    @Override
    public Property deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        Property property = this.propertyFromNode(node);
        return property;
    }

    public Xml getXml(JsonNode node) {
        ObjectNode obj;
        Xml xml = null;
        if (node instanceof ObjectNode && (obj = (ObjectNode)((ObjectNode)node).get("xml")) != null) {
            xml = new Xml();
            JsonNode n = obj.get("name");
            if (n != null) {
                xml.name(n.asText());
            }
            if ((n = obj.get("namespace")) != null) {
                xml.namespace(n.asText());
            }
            if ((n = obj.get("prefix")) != null) {
                xml.prefix(n.asText());
            }
            if ((n = obj.get("attribute")) != null) {
                xml.attribute(n.asBoolean());
            }
            if ((n = obj.get("wrapped")) != null) {
                xml.wrapped(n.asBoolean());
            }
        }
        return xml;
    }

    private Map<PropertyBuilder.PropertyId, Object> argsFromNode(JsonNode node) {
        if (node == null) {
            return Collections.emptyMap();
        }
        EnumMap<PropertyBuilder.PropertyId, Object> args = new EnumMap<PropertyBuilder.PropertyId, Object>(PropertyBuilder.PropertyId.class);
        args.put(PropertyBuilder.PropertyId.TYPE, PropertyDeserializer.getString(node, PropertyBuilder.PropertyId.TYPE));
        args.put(PropertyBuilder.PropertyId.FORMAT, PropertyDeserializer.getString(node, PropertyBuilder.PropertyId.FORMAT));
        args.put(PropertyBuilder.PropertyId.DESCRIPTION, PropertyDeserializer.getString(node, PropertyBuilder.PropertyId.DESCRIPTION));
        args.put(PropertyBuilder.PropertyId.EXAMPLE, PropertyDeserializer.getString(node, PropertyBuilder.PropertyId.EXAMPLE));
        args.put(PropertyBuilder.PropertyId.ENUM, PropertyDeserializer.getEnum(node, PropertyBuilder.PropertyId.ENUM));
        args.put(PropertyBuilder.PropertyId.TITLE, PropertyDeserializer.getString(node, PropertyBuilder.PropertyId.TITLE));
        args.put(PropertyBuilder.PropertyId.DEFAULT, PropertyDeserializer.getString(node, PropertyBuilder.PropertyId.DEFAULT));
        args.put(PropertyBuilder.PropertyId.PATTERN, PropertyDeserializer.getString(node, PropertyBuilder.PropertyId.PATTERN));
        args.put(PropertyBuilder.PropertyId.DESCRIMINATOR, PropertyDeserializer.getString(node, PropertyBuilder.PropertyId.DESCRIMINATOR));
        args.put(PropertyBuilder.PropertyId.MIN_ITEMS, PropertyDeserializer.getInteger(node, PropertyBuilder.PropertyId.MIN_ITEMS));
        args.put(PropertyBuilder.PropertyId.MAX_ITEMS, PropertyDeserializer.getInteger(node, PropertyBuilder.PropertyId.MAX_ITEMS));
        args.put(PropertyBuilder.PropertyId.MIN_PROPERTIES, PropertyDeserializer.getInteger(node, PropertyBuilder.PropertyId.MIN_PROPERTIES));
        args.put(PropertyBuilder.PropertyId.MAX_PROPERTIES, PropertyDeserializer.getInteger(node, PropertyBuilder.PropertyId.MAX_PROPERTIES));
        args.put(PropertyBuilder.PropertyId.MIN_LENGTH, PropertyDeserializer.getInteger(node, PropertyBuilder.PropertyId.MIN_LENGTH));
        args.put(PropertyBuilder.PropertyId.MAX_LENGTH, PropertyDeserializer.getInteger(node, PropertyBuilder.PropertyId.MAX_LENGTH));
        args.put(PropertyBuilder.PropertyId.MINIMUM, PropertyDeserializer.getBigDecimal(node, PropertyBuilder.PropertyId.MINIMUM));
        args.put(PropertyBuilder.PropertyId.MAXIMUM, PropertyDeserializer.getBigDecimal(node, PropertyBuilder.PropertyId.MAXIMUM));
        args.put(PropertyBuilder.PropertyId.MULTIPLE_OF, PropertyDeserializer.getBigDecimal(node, PropertyBuilder.PropertyId.MULTIPLE_OF));
        args.put(PropertyBuilder.PropertyId.EXCLUSIVE_MINIMUM, PropertyDeserializer.getBoolean(node, PropertyBuilder.PropertyId.EXCLUSIVE_MINIMUM));
        args.put(PropertyBuilder.PropertyId.EXCLUSIVE_MAXIMUM, PropertyDeserializer.getBoolean(node, PropertyBuilder.PropertyId.EXCLUSIVE_MAXIMUM));
        args.put(PropertyBuilder.PropertyId.UNIQUE_ITEMS, PropertyDeserializer.getBoolean(node, PropertyBuilder.PropertyId.UNIQUE_ITEMS));
        args.put(PropertyBuilder.PropertyId.READ_ONLY, PropertyDeserializer.getBoolean(node, PropertyBuilder.PropertyId.READ_ONLY));
        args.put(PropertyBuilder.PropertyId.VENDOR_EXTENSIONS, PropertyDeserializer.getVendorExtensions(node));
        return args;
    }

    Property propertyFromNode(JsonNode node) {
        if (node.isBoolean()) {
            return new BooleanValueProperty(node.asBoolean());
        }
        String type = PropertyDeserializer.getString(node, PropertyBuilder.PropertyId.TYPE);
        String title = PropertyDeserializer.getString(node, PropertyBuilder.PropertyId.TITLE);
        String format = PropertyDeserializer.getString(node, PropertyBuilder.PropertyId.FORMAT);
        Boolean readOnly = PropertyDeserializer.getBoolean(node, PropertyBuilder.PropertyId.READ_ONLY);
        String description = PropertyDeserializer.getString(node, PropertyBuilder.PropertyId.DESCRIPTION);
        Xml xml = this.getXml(node);
        JsonNode detailNode = node.get("$ref");
        if (detailNode != null) {
            RefProperty refProperty = new RefProperty(detailNode.asText());
            refProperty.setDescription(description);
            refProperty.setTitle(title);
            refProperty.setReadOnly(readOnly);
            refProperty.setXml(xml);
            return refProperty;
        }
        if (ObjectProperty.isType(type) || node.get("properties") != null || node.get("allOf") != null) {
            JsonNode example = PropertyDeserializer.getDetailNode(node, PropertyBuilder.PropertyId.EXAMPLE);
            detailNode = node.get("additionalProperties");
            if (detailNode != null && detailNode.getNodeType().equals((Object)JsonNodeType.OBJECT)) {
                Property items = this.propertyFromNode(detailNode);
                if (items != null) {
                    MapProperty mapProperty = new MapProperty(items).description(description).title(title).xml(xml);
                    mapProperty.setExample(example);
                    mapProperty.setMinProperties(PropertyDeserializer.getInteger(node, PropertyBuilder.PropertyId.MIN_PROPERTIES));
                    mapProperty.setMaxProperties(PropertyDeserializer.getInteger(node, PropertyBuilder.PropertyId.MAX_PROPERTIES));
                    mapProperty.setVendorExtensionMap(PropertyDeserializer.getVendorExtensions(node));
                    mapProperty.setReadOnly(readOnly);
                    return mapProperty;
                }
            } else {
                if (detailNode != null && detailNode.getNodeType().equals((Object)JsonNodeType.BOOLEAN)) {
                    BooleanValueProperty items = new BooleanValueProperty(detailNode.asBoolean());
                    MapProperty mapProperty = new MapProperty(items).description(description).title(title).xml(xml);
                    mapProperty.setExample(example);
                    mapProperty.setMinProperties(PropertyDeserializer.getInteger(node, PropertyBuilder.PropertyId.MIN_PROPERTIES));
                    mapProperty.setMaxProperties(PropertyDeserializer.getInteger(node, PropertyBuilder.PropertyId.MAX_PROPERTIES));
                    mapProperty.setVendorExtensionMap(PropertyDeserializer.getVendorExtensions(node));
                    mapProperty.setReadOnly(readOnly);
                    return mapProperty;
                }
                JsonNode allOfNode = node.get("allOf");
                detailNode = node.get("properties");
                String detailNodeType = null;
                LinkedHashMap<String, Property> properties = new LinkedHashMap<String, Property>();
                if (detailNode != null) {
                    Iterator<Map.Entry<String, JsonNode>> iter = detailNode.fields();
                    while (iter.hasNext()) {
                        Map.Entry<String, JsonNode> field = iter.next();
                        Property property = this.propertyFromNode(field.getValue());
                        if (property != null) {
                            properties.put(field.getKey(), property);
                            continue;
                        }
                        if ("type".equals(field.getKey()) && field.getValue() != null && "array".equals(field.getValue().asText())) {
                            detailNodeType = "array";
                        }
                        if (!"description".equals(field.getKey()) || !field.getValue().getNodeType().equals((Object)JsonNodeType.STRING)) continue;
                        description = field.getValue().asText();
                    }
                } else if (allOfNode != null) {
                    ComposedProperty cp = new ComposedProperty().description(description).title(title);
                    cp.setExample(example);
                    cp.setDescription(description);
                    cp.setVendorExtensions(PropertyDeserializer.getVendorExtensions(node));
                    ArrayList<Property> allOf = new ArrayList<Property>();
                    for (JsonNode innerNode : allOfNode) {
                        allOf.add(this.propertyFromNode(innerNode));
                    }
                    cp.setAllOf(allOf);
                    return cp;
                }
                if ("array".equals(detailNodeType)) {
                    ArrayProperty ap = new ArrayProperty().description(description).title(title).xml(xml);
                    ap.setExample(example);
                    PropertyBuilder.merge(ap, this.argsFromNode(detailNode));
                    ap.setDescription(description);
                    if (properties.keySet().size() == 1) {
                        String key = (String)properties.keySet().iterator().next();
                        ap.setItems((Property)properties.get(key));
                    }
                    ap.setVendorExtensionMap(PropertyDeserializer.getVendorExtensions(node));
                    return ap;
                }
                ObjectProperty objectProperty = new ObjectProperty(properties).description(description).title(title).xml(xml);
                objectProperty.setReadOnly(readOnly);
                objectProperty.setExample(example);
                objectProperty.setVendorExtensionMap(PropertyDeserializer.getVendorExtensions(node));
                List<String> required = PropertyDeserializer.getRequired(node, PropertyBuilder.PropertyId.REQUIRED);
                objectProperty.setRequiredProperties(required);
                return objectProperty;
            }
        }
        if (ArrayProperty.isType(type) && (detailNode = node.get("items")) != null) {
            Property subProperty = this.propertyFromNode(detailNode);
            ArrayProperty arrayProperty = new ArrayProperty().items(subProperty).description(description).title(title).xml(xml);
            arrayProperty.setReadOnly(readOnly);
            arrayProperty.setMinItems(PropertyDeserializer.getInteger(node, PropertyBuilder.PropertyId.MIN_ITEMS));
            arrayProperty.setMaxItems(PropertyDeserializer.getInteger(node, PropertyBuilder.PropertyId.MAX_ITEMS));
            arrayProperty.setUniqueItems(PropertyDeserializer.getBoolean(node, PropertyBuilder.PropertyId.UNIQUE_ITEMS));
            JsonNode example = PropertyDeserializer.getDetailNode(node, PropertyBuilder.PropertyId.EXAMPLE);
            arrayProperty.setExample(example);
            arrayProperty.setVendorExtensionMap(PropertyDeserializer.getVendorExtensions(node));
            return arrayProperty;
        }
        Map<PropertyBuilder.PropertyId, Object> args = this.argsFromNode(node);
        Property output = PropertyBuilder.build(type, format, args);
        if (output == null) {
            this.LOGGER.warn("no property from " + type + ", " + format + ", " + args);
            return null;
        }
        output.setXml(xml);
        output.setDescription(description);
        return output;
    }
}

