/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.common.coder;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.shade.io.netty.buffer.ByteBuf;
import org.apache.pulsar.shade.io.netty.buffer.ByteBufInputStream;
import org.apache.pulsar.shade.io.netty.buffer.ByteBufOutputStream;
import org.apache.pulsar.shade.org.apache.bookkeeper.common.coder.Coder;
import org.apache.pulsar.shade.org.apache.bookkeeper.common.util.VarInt;

public class VarIntCoder
implements Coder<Integer> {
    private static final long serialVersionUID = 465214482437322885L;
    private static final VarIntCoder INSTANCE = new VarIntCoder();

    public static VarIntCoder of() {
        return INSTANCE;
    }

    private VarIntCoder() {
    }

    @Override
    public void encode(Integer value, ByteBuf buf) {
        Preconditions.checkNotNull(value, "Can not encode a null integer value");
        Preconditions.checkNotNull(buf, "Can not encode into a null output buffer");
        ByteBufOutputStream output = new ByteBufOutputStream(buf);
        try {
            VarInt.encode(value, (OutputStream)output);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to encode integer '" + value + "' into the provided buffer", e);
        }
    }

    @Override
    public int getSerializedSize(Integer value) {
        return VarInt.getLength(value);
    }

    @Override
    public Integer decode(ByteBuf buf) {
        Preconditions.checkNotNull(buf, "Can not decode into a null input buffer");
        ByteBufInputStream input = new ByteBufInputStream(buf);
        try {
            return VarInt.decodeInt(input);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to decode an integration from the provided buffer");
        }
    }
}

