/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.common.util;

import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.apache.pulsar.shade.com.google.common.util.concurrent.FutureCallback;
import org.apache.pulsar.shade.com.google.common.util.concurrent.Futures;
import org.apache.pulsar.shade.com.google.common.util.concurrent.ListenableFuture;
import org.apache.pulsar.shade.com.google.common.util.concurrent.MoreExecutors;
import org.apache.pulsar.shade.org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.pulsar.shade.org.apache.bookkeeper.common.util.ExceptionalFunction;

public final class ListenableFutures {
    public static <T> CompletableFuture<T> fromListenableFuture(ListenableFuture<T> listenableFuture) {
        return ListenableFutures.fromListenableFuture(listenableFuture, Function.identity());
    }

    public static <T, R> CompletableFuture<R> fromListenableFuture(ListenableFuture<T> listenableFuture, final Function<? super T, ? extends R> mapFn) {
        final CompletableFuture completableFuture = FutureUtils.createFuture();
        Futures.addCallback(listenableFuture, new FutureCallback<T>(){

            @Override
            public void onSuccess(T result) {
                try {
                    Object uResult = mapFn.apply(result);
                    completableFuture.complete(uResult);
                }
                catch (Exception e) {
                    completableFuture.completeExceptionally(e);
                }
            }

            @Override
            public void onFailure(Throwable t) {
                completableFuture.completeExceptionally(t);
            }
        }, MoreExecutors.directExecutor());
        return completableFuture;
    }

    public static <T, R> CompletableFuture<R> fromListenableFuture(ListenableFuture<T> listenableFuture, final ExceptionalFunction<? super T, ? extends R> mapFn) {
        final CompletableFuture completableFuture = FutureUtils.createFuture();
        Futures.addCallback(listenableFuture, new FutureCallback<T>(){

            @Override
            public void onSuccess(T result) {
                try {
                    Object uResult = mapFn.apply(result);
                    completableFuture.complete(uResult);
                }
                catch (Exception e) {
                    completableFuture.completeExceptionally(e);
                }
            }

            @Override
            public void onFailure(Throwable t) {
                completableFuture.completeExceptionally(t);
            }
        }, MoreExecutors.directExecutor());
        return completableFuture;
    }

    private ListenableFutures() {
    }
}

