/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.mledger.impl;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.ManagedLedgerFactoryMXBean;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.impl.ManagedLedgerFactoryImpl;
import org.apache.pulsar.shade.org.apache.pulsar.common.stats.Rate;

public class ManagedLedgerFactoryMBeanImpl
implements ManagedLedgerFactoryMXBean {
    private final ManagedLedgerFactoryImpl factory;
    final Rate cacheHits = new Rate();
    final Rate cacheMisses = new Rate();
    final Rate cacheEvictions = new Rate();
    private final LongAdder insertedEntryCount = new LongAdder();
    private final LongAdder evictedEntryCount = new LongAdder();
    private final LongAdder cacheEntryCount = new LongAdder();

    public ManagedLedgerFactoryMBeanImpl(ManagedLedgerFactoryImpl factory) throws Exception {
        this.factory = factory;
    }

    public void refreshStats(long period, TimeUnit unit) {
        double seconds = (double)unit.toMillis(period) / 1000.0;
        if (seconds <= 0.0) {
            return;
        }
        this.cacheHits.calculateRate(seconds);
        this.cacheMisses.calculateRate(seconds);
        this.cacheEvictions.calculateRate(seconds);
    }

    public void recordCacheHit(long size) {
        this.cacheHits.recordEvent(size);
    }

    public void recordCacheHits(int count, long totalSize) {
        this.cacheHits.recordMultipleEvents(count, totalSize);
    }

    public void recordCacheMiss(int count, long totalSize) {
        this.cacheMisses.recordMultipleEvents(count, totalSize);
    }

    public void recordCacheEviction() {
        this.cacheEvictions.recordEvent();
    }

    public void recordCacheInsertion() {
        this.insertedEntryCount.increment();
        this.cacheEntryCount.increment();
    }

    public void recordNumberOfCacheEntriesEvicted(int count) {
        this.evictedEntryCount.add(count);
        this.cacheEntryCount.add(-count);
    }

    @Override
    public int getNumberOfManagedLedgers() {
        return this.factory.ledgers.size();
    }

    @Override
    public long getCacheUsedSize() {
        return this.factory.getEntryCacheManager().getSize();
    }

    @Override
    public long getCacheMaxSize() {
        return this.factory.getEntryCacheManager().getMaxSize();
    }

    @Override
    public double getCacheHitsRate() {
        return this.cacheHits.getRate();
    }

    @Override
    public double getCacheMissesRate() {
        return this.cacheMisses.getRate();
    }

    @Override
    public double getCacheHitsThroughput() {
        return this.cacheHits.getValueRate();
    }

    @Override
    public double getCacheMissesThroughput() {
        return this.cacheMisses.getValueRate();
    }

    @Override
    public long getNumberOfCacheEvictions() {
        return this.cacheEvictions.getCount();
    }

    @Override
    public long getCacheInsertedEntriesCount() {
        return this.insertedEntryCount.sum();
    }

    @Override
    public long getCacheEvictedEntriesCount() {
        return this.evictedEntryCount.sum();
    }

    @Override
    public long getCacheEntriesCount() {
        return this.cacheEntryCount.sum();
    }
}

