/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.mledger.impl;

import java.util.Map;
import org.apache.pulsar.shade.com.google.common.base.MoreObjects;
import org.apache.pulsar.shade.com.google.common.collect.Range;
import org.apache.pulsar.shade.org.apache.bookkeeper.client.BookKeeper;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.AsyncCallbacks;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.ManagedLedgerConfig;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.impl.ManagedCursorImpl;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.impl.ManagedLedgerImpl;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.impl.PositionImpl;
import org.apache.pulsar.shade.org.apache.commons.lang3.tuple.Pair;
import org.apache.pulsar.shade.org.apache.pulsar.common.api.proto.CommandSubscribe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NonDurableCursorImpl
extends ManagedCursorImpl {
    private final boolean readCompacted;
    private static final Logger log = LoggerFactory.getLogger(NonDurableCursorImpl.class);

    NonDurableCursorImpl(BookKeeper bookkeeper, ManagedLedgerConfig config, ManagedLedgerImpl ledger, String cursorName, PositionImpl startCursorPosition, CommandSubscribe.InitialPosition initialPosition, boolean isReadCompacted) {
        super(bookkeeper, config, ledger, cursorName);
        this.readCompacted = isReadCompacted;
        if (startCursorPosition == null || startCursorPosition.compareTo(ledger.lastConfirmedEntry) > 0) {
            switch (initialPosition) {
                case Latest: {
                    this.initializeCursorPosition(ledger.getLastPositionAndCounter());
                    break;
                }
                case Earliest: {
                    this.initializeCursorPosition(ledger.getFirstPositionAndCounter());
                }
            }
        } else if (startCursorPosition.getLedgerId() == PositionImpl.earliest.getLedgerId()) {
            this.recoverCursor(ledger.getPreviousPosition(ledger.getFirstPosition()));
        } else {
            this.recoverCursor(startCursorPosition);
        }
        STATE_UPDATER.set(this, ManagedCursorImpl.State.Open);
        log.info("[{}] Created non-durable cursor read-position={} mark-delete-position={}", new Object[]{ledger.getName(), this.readPosition, this.markDeletePosition});
    }

    private void recoverCursor(PositionImpl mdPosition) {
        Pair<PositionImpl, Long> lastEntryAndCounter = this.ledger.getLastPositionAndCounter();
        this.readPosition = this.isReadCompacted() ? mdPosition.getNext() : this.ledger.getNextValidPosition(mdPosition);
        this.markDeletePosition = mdPosition;
        if (null != this.readPosition) {
            long initialBacklog = this.readPosition.compareTo(lastEntryAndCounter.getLeft()) <= 0 ? this.ledger.getNumberOfEntries(Range.closed(this.readPosition, lastEntryAndCounter.getLeft())) : 0L;
            this.messagesConsumedCounter = lastEntryAndCounter.getRight() - initialBacklog;
        } else {
            log.warn("Recovered a non-durable cursor from position {} but didn't find a valid read position {}", (Object)mdPosition, (Object)this.readPosition);
        }
    }

    @Override
    public boolean isDurable() {
        return false;
    }

    @Override
    void recover(ManagedCursorImpl.VoidCallback callback) {
    }

    @Override
    protected void internalAsyncMarkDelete(PositionImpl newPosition, Map<String, Long> properties, AsyncCallbacks.MarkDeleteCallback callback, Object ctx) {
        ManagedCursorImpl.MarkDeleteEntry mdEntry;
        this.lastMarkDeleteEntry = mdEntry = new ManagedCursorImpl.MarkDeleteEntry(newPosition, properties, callback, ctx);
        this.ledger.onCursorMarkDeletePositionUpdated(this, mdEntry.newPosition);
        callback.markDeleteComplete(ctx);
    }

    @Override
    public void asyncClose(AsyncCallbacks.CloseCallback callback, Object ctx) {
        STATE_UPDATER.set(this, ManagedCursorImpl.State.Closed);
        callback.closeComplete(ctx);
    }

    public void asyncDeleteCursor(String consumerName, AsyncCallbacks.DeleteCursorCallback callback, Object ctx) {
        callback.deleteCursorComplete(ctx);
    }

    public boolean isReadCompacted() {
        return this.readCompacted;
    }

    @Override
    public void rewind() {
        if (!this.readCompacted) {
            super.rewind();
        } else {
            this.readPosition = this.markDeletePosition.getNext();
        }
    }

    @Override
    public synchronized String toString() {
        return MoreObjects.toStringHelper(this).add("ledger", this.ledger.getName()).add("ackPos", this.markDeletePosition).add("readPos", this.readPosition).toString();
    }
}

