/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.mledger.offload;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.LedgerOffloaderFactory;
import org.apache.pulsar.shade.org.apache.commons.lang3.tuple.Pair;
import org.apache.pulsar.shade.org.apache.pulsar.common.nar.NarClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Offloaders
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(Offloaders.class);
    private final List<Pair<NarClassLoader, LedgerOffloaderFactory>> offloaders = new ArrayList<Pair<NarClassLoader, LedgerOffloaderFactory>>();

    public LedgerOffloaderFactory getOffloaderFactory(String driverName) throws IOException {
        for (Pair<NarClassLoader, LedgerOffloaderFactory> factory : this.offloaders) {
            if (!factory.getRight().isDriverSupported(driverName)) continue;
            return factory.getRight();
        }
        throw new IOException("No offloader found for driver '" + driverName + "'. Please make sure you dropped the offloader nar packages under `${PULSAR_HOME}/offloaders`.");
    }

    @Override
    public void close() throws Exception {
        this.offloaders.forEach(offloader -> {
            try {
                ((NarClassLoader)offloader.getLeft()).close();
            }
            catch (IOException e) {
                log.warn("Failed to close nar class loader for offloader '{}': {}", ((LedgerOffloaderFactory)offloader.getRight()).getClass(), (Object)e.getMessage());
            }
        });
    }

    public List<Pair<NarClassLoader, LedgerOffloaderFactory>> getOffloaders() {
        return this.offloaders;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Offloaders)) {
            return false;
        }
        Offloaders other = (Offloaders)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<Pair<NarClassLoader, LedgerOffloaderFactory>> this$offloaders = this.getOffloaders();
        List<Pair<NarClassLoader, LedgerOffloaderFactory>> other$offloaders = other.getOffloaders();
        return !(this$offloaders == null ? other$offloaders != null : !((Object)this$offloaders).equals(other$offloaders));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Offloaders;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Pair<NarClassLoader, LedgerOffloaderFactory>> $offloaders = this.getOffloaders();
        result = result * 59 + ($offloaders == null ? 43 : ((Object)$offloaders).hashCode());
        return result;
    }

    public String toString() {
        return "Offloaders(offloaders=" + this.getOffloaders() + ")";
    }
}

