/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.stats;

import org.apache.pulsar.shade.org.apache.bookkeeper.stats.Counter;
import org.apache.pulsar.shade.org.apache.bookkeeper.stats.StatsLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlertStatsLogger {
    private static final Logger logger = LoggerFactory.getLogger(AlertStatsLogger.class);
    public final String alertStatName;
    private final StatsLogger globalStatsLogger;
    private final StatsLogger scopedStatsLogger;
    private final String scope;
    private Counter globalCounter = null;
    private Counter scopedCounter = null;

    public AlertStatsLogger(StatsLogger globalStatsLogger, String scope, String alertStatName) {
        this.globalStatsLogger = globalStatsLogger;
        this.scope = scope;
        this.scopedStatsLogger = globalStatsLogger.scope(scope);
        this.alertStatName = alertStatName;
    }

    public AlertStatsLogger(StatsLogger globalStatsLogger, String alertStatName) {
        this.globalStatsLogger = globalStatsLogger;
        this.scope = null;
        this.scopedStatsLogger = null;
        this.alertStatName = alertStatName;
    }

    private String format(String msg) {
        return msg.startsWith("ALERT!: ") ? msg : "ALERT!: " + (this.scope != null ? "(" + this.scope + "):" : "") + msg;
    }

    private void initializeCountersIfNeeded() {
        if (null != this.globalCounter) {
            return;
        }
        this.globalCounter = this.globalStatsLogger.getCounter(this.alertStatName);
        if (null != this.scopedStatsLogger) {
            this.scopedCounter = this.scopedStatsLogger.getCounter(this.alertStatName);
        }
    }

    public void raise(String msg, Object ... args) {
        this.initializeCountersIfNeeded();
        this.globalCounter.inc();
        if (null != this.scopedCounter) {
            this.scopedCounter.inc();
        }
        logger.error(this.format(msg), args);
        logger.error("fake exception to generate stack trace", (Throwable)new Exception());
    }
}

