/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.stream.server.service;

import java.io.IOException;
import java.util.function.Supplier;
import org.apache.pulsar.shade.org.apache.bookkeeper.common.component.AbstractLifecycleComponent;
import org.apache.pulsar.shade.org.apache.bookkeeper.stats.StatsLogger;
import org.apache.pulsar.shade.org.apache.bookkeeper.stream.storage.StorageContainerStoreBuilder;
import org.apache.pulsar.shade.org.apache.bookkeeper.stream.storage.api.StorageContainerStore;
import org.apache.pulsar.shade.org.apache.bookkeeper.stream.storage.conf.StorageConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageService
extends AbstractLifecycleComponent<StorageConfiguration>
implements Supplier<StorageContainerStore> {
    private static final Logger log = LoggerFactory.getLogger(StorageService.class);
    private final StorageContainerStoreBuilder storeBuilder;
    private StorageContainerStore store;

    public StorageService(StorageConfiguration conf, StorageContainerStoreBuilder storeBuilder, StatsLogger statsLogger) {
        super("storage-service", conf, statsLogger);
        this.storeBuilder = storeBuilder;
    }

    @Override
    protected void doStart() {
        this.store = this.storeBuilder.build();
        this.store.start();
    }

    @Override
    protected void doStop() {
        this.store.stop();
    }

    @Override
    protected void doClose() throws IOException {
        if (null != this.store) {
            this.store.close();
        }
    }

    @Override
    public StorageContainerStore get() {
        return this.store;
    }
}

