/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.stream.storage;

import java.net.URI;
import java.util.function.Supplier;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.shade.org.apache.bookkeeper.clients.impl.internal.api.StorageServerClientManager;
import org.apache.pulsar.shade.org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.pulsar.shade.org.apache.bookkeeper.stats.StatsLogger;
import org.apache.pulsar.shade.org.apache.bookkeeper.stream.protocol.util.StorageContainerPlacementPolicy;
import org.apache.pulsar.shade.org.apache.bookkeeper.stream.storage.StorageResources;
import org.apache.pulsar.shade.org.apache.bookkeeper.stream.storage.api.StorageContainerStore;
import org.apache.pulsar.shade.org.apache.bookkeeper.stream.storage.api.sc.StorageContainerManagerFactory;
import org.apache.pulsar.shade.org.apache.bookkeeper.stream.storage.conf.StorageConfiguration;
import org.apache.pulsar.shade.org.apache.bookkeeper.stream.storage.impl.StorageContainerStoreImpl;
import org.apache.pulsar.shade.org.apache.bookkeeper.stream.storage.impl.sc.StorageContainerPlacementPolicyImpl;
import org.apache.pulsar.shade.org.apache.bookkeeper.stream.storage.impl.service.RangeStoreContainerServiceFactoryImpl;
import org.apache.pulsar.shade.org.apache.bookkeeper.stream.storage.impl.service.RangeStoreServiceFactoryImpl;
import org.apache.pulsar.shade.org.apache.bookkeeper.stream.storage.impl.store.MVCCStoreFactory;

public final class StorageContainerStoreBuilder {
    private StatsLogger statsLogger = NullStatsLogger.INSTANCE;
    private StorageConfiguration storeConf = null;
    private StorageResources storeResources = null;
    private StorageContainerManagerFactory scmFactory = null;
    private StorageContainerPlacementPolicy.Factory placementPolicyFactory = () -> StorageContainerPlacementPolicyImpl.of(1024);
    private MVCCStoreFactory mvccStoreFactory = null;
    private URI defaultBackendUri = null;
    private Supplier<StorageServerClientManager> clientManagerSupplier;

    public static StorageContainerStoreBuilder newBuilder() {
        return new StorageContainerStoreBuilder();
    }

    private StorageContainerStoreBuilder() {
    }

    public StorageContainerStoreBuilder withStorageContainerPlacementPolicyFactory(StorageContainerPlacementPolicy.Factory placementPolicyFactory) {
        this.placementPolicyFactory = placementPolicyFactory;
        return this;
    }

    public StorageContainerStoreBuilder withStatsLogger(StatsLogger statsLogger) {
        if (null == statsLogger) {
            return this;
        }
        this.statsLogger = statsLogger;
        return this;
    }

    public StorageContainerStoreBuilder withStorageConfiguration(StorageConfiguration storeConf) {
        this.storeConf = storeConf;
        return this;
    }

    public StorageContainerStoreBuilder withStorageContainerManagerFactory(StorageContainerManagerFactory scmFactory) {
        this.scmFactory = scmFactory;
        return this;
    }

    public StorageContainerStoreBuilder withStorageResources(StorageResources resources) {
        this.storeResources = resources;
        return this;
    }

    public StorageContainerStoreBuilder withRangeStoreFactory(MVCCStoreFactory storeFactory) {
        this.mvccStoreFactory = storeFactory;
        return this;
    }

    public StorageContainerStoreBuilder withDefaultBackendUri(URI uri) {
        this.defaultBackendUri = uri;
        return this;
    }

    public StorageContainerStoreBuilder withStorageServerClientManager(Supplier<StorageServerClientManager> clientManagerSupplier) {
        this.clientManagerSupplier = clientManagerSupplier;
        return this;
    }

    public StorageContainerStore build() {
        Preconditions.checkNotNull(this.scmFactory, "StorageContainerManagerFactory is not provided");
        Preconditions.checkNotNull(this.storeConf, "StorageConfiguration is not provided");
        Preconditions.checkNotNull(this.mvccStoreFactory, "MVCCStoreFactory is not provided");
        Preconditions.checkNotNull(this.defaultBackendUri, "Default backend uri is not provided");
        Preconditions.checkNotNull(this.placementPolicyFactory, "Storage Container Placement Policy Factory is not provided");
        Preconditions.checkNotNull(this.clientManagerSupplier, "Storage server client manager is not provided");
        RangeStoreServiceFactoryImpl serviceFactory = new RangeStoreServiceFactoryImpl(this.storeConf, this.placementPolicyFactory.newPlacementPolicy(), this.storeResources.scheduler(), this.mvccStoreFactory, this.clientManagerSupplier.get());
        RangeStoreContainerServiceFactoryImpl containerServiceFactory = new RangeStoreContainerServiceFactoryImpl(serviceFactory);
        return new StorageContainerStoreImpl(this.storeConf, this.scmFactory, containerServiceFactory, this.clientManagerSupplier.get(), this.statsLogger);
    }
}

