/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.stream.storage.impl.sc;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.pulsar.shade.com.google.common.collect.Lists;
import org.apache.pulsar.shade.org.apache.bookkeeper.common.component.AbstractLifecycleComponent;
import org.apache.pulsar.shade.org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.pulsar.shade.org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.pulsar.shade.org.apache.bookkeeper.stream.proto.common.Endpoint;
import org.apache.pulsar.shade.org.apache.bookkeeper.stream.storage.api.sc.StorageContainerManager;
import org.apache.pulsar.shade.org.apache.bookkeeper.stream.storage.api.sc.StorageContainerRegistry;
import org.apache.pulsar.shade.org.apache.bookkeeper.stream.storage.conf.StorageConfiguration;

public class LocalStorageContainerManager
extends AbstractLifecycleComponent<StorageConfiguration>
implements StorageContainerManager {
    private final Endpoint myEndpoint;
    private final int numStorageContainers;
    private final StorageContainerRegistry registry;

    public LocalStorageContainerManager(Endpoint myEndpoint, StorageConfiguration conf, StorageContainerRegistry scRegistry, int numStorageContainers) {
        super("local-storage-container-manager", conf, NullStatsLogger.INSTANCE);
        this.myEndpoint = myEndpoint;
        this.registry = scRegistry;
        this.numStorageContainers = numStorageContainers;
    }

    @Override
    public Endpoint getStorageContainer(long scId) {
        return this.myEndpoint;
    }

    @Override
    protected void doStart() {
        ArrayList futures = Lists.newArrayListWithExpectedSize(this.numStorageContainers);
        for (int scId = 0; scId < this.numStorageContainers; ++scId) {
            futures.add(this.registry.startStorageContainer(scId));
        }
        FutureUtils.collect(futures).join();
    }

    @Override
    protected void doStop() {
        ArrayList futures = Lists.newArrayListWithExpectedSize(this.numStorageContainers);
        for (int scId = 0; scId < this.numStorageContainers; ++scId) {
            futures.add(this.registry.stopStorageContainer(scId));
        }
        FutureUtils.collect(futures).join();
    }

    @Override
    protected void doClose() throws IOException {
    }
}

