/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.tools.cli.commands.bookie;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.pulsar.shade.com.beust.jcommander.Parameter;
import org.apache.pulsar.shade.com.google.common.collect.Lists;
import org.apache.pulsar.shade.com.google.common.util.concurrent.UncheckedExecutionException;
import org.apache.pulsar.shade.io.netty.buffer.Unpooled;
import org.apache.pulsar.shade.org.apache.bookkeeper.bookie.Journal;
import org.apache.pulsar.shade.org.apache.bookkeeper.bookie.LedgerDirsManager;
import org.apache.pulsar.shade.org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.pulsar.shade.org.apache.bookkeeper.tools.cli.commands.bookie.FormatUtil;
import org.apache.pulsar.shade.org.apache.bookkeeper.tools.cli.helpers.BookieCommand;
import org.apache.pulsar.shade.org.apache.bookkeeper.tools.framework.CliFlags;
import org.apache.pulsar.shade.org.apache.bookkeeper.tools.framework.CliSpec;
import org.apache.pulsar.shade.org.apache.bookkeeper.util.DiskChecker;
import org.apache.pulsar.shade.org.apache.bookkeeper.util.EntryFormatter;
import org.apache.pulsar.shade.org.apache.bookkeeper.util.LedgerIdFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadJournalCommand
extends BookieCommand<ReadJournalFlags> {
    private static final String NAME = "readjournal";
    private static final String DESC = "Scan a journal file and format the entries into readable format.";
    private static final long DEFAULT_JOURNALID = -1L;
    private static final String DEFAULT = "";
    private LedgerIdFormatter ledgerIdFormatter;
    private EntryFormatter entryFormatter;
    private static final Logger LOG = LoggerFactory.getLogger(ReadJournalCommand.class);
    List<Journal> journals = null;

    public ReadJournalCommand() {
        this(new ReadJournalFlags());
    }

    public ReadJournalCommand(LedgerIdFormatter idFormatter, EntryFormatter entryFormatter) {
        this(new ReadJournalFlags());
        this.ledgerIdFormatter = idFormatter;
        this.entryFormatter = entryFormatter;
    }

    ReadJournalCommand(ReadJournalFlags flags) {
        super(CliSpec.newBuilder().withName(NAME).withDescription(DESC).withFlags(flags).build());
    }

    @Override
    public boolean apply(ServerConfiguration conf, ReadJournalFlags cmdFlags) {
        this.initTools(conf, cmdFlags);
        if (!this.checkArgs(cmdFlags)) {
            return false;
        }
        try {
            return this.handler(conf, cmdFlags);
        }
        catch (IOException e) {
            throw new UncheckedExecutionException(e.getMessage(), e);
        }
    }

    private void initTools(ServerConfiguration conf, ReadJournalFlags flags) {
        this.ledgerIdFormatter = !flags.ledgerIdFormatter.equals(DEFAULT) ? LedgerIdFormatter.newLedgerIdFormatter(flags.ledgerIdFormatter, conf) : LedgerIdFormatter.newLedgerIdFormatter(conf);
        this.entryFormatter = !flags.entryFormatter.equals(DEFAULT) ? EntryFormatter.newEntryFormatter(flags.entryFormatter, conf) : EntryFormatter.newEntryFormatter(conf);
    }

    private boolean handler(ServerConfiguration conf, ReadJournalFlags cmd) throws IOException {
        Journal journal = null;
        if (this.getJournals(conf).size() > 1) {
            if (cmd.dir.equals(DEFAULT)) {
                LOG.error("ERROR: invalid or missing journal directory");
                this.usage();
                return false;
            }
            File journalDirectory = new File(cmd.dir);
            for (Journal j : this.getJournals(conf)) {
                if (!j.getJournalDirectory().equals(journalDirectory)) continue;
                journal = j;
                break;
            }
            if (journal == null) {
                LOG.error("ERROR: journal directory not found");
                this.usage();
                return false;
            }
        } else {
            journal = this.getJournals(conf).get(0);
        }
        long journalId = cmd.journalId;
        if (cmd.journalId == -1L && !cmd.fileName.equals(DEFAULT)) {
            File f = new File(cmd.fileName);
            String name = f.getName();
            if (!name.endsWith(".txn")) {
                LOG.error("ERROR: invalid journal file name " + cmd.fileName);
                this.usage();
                return false;
            }
            String idString = name.split("\\.")[0];
            journalId = Long.parseLong(idString, 16);
        }
        this.scanJournal(journal, journalId, cmd.msg);
        return true;
    }

    private boolean checkArgs(ReadJournalFlags flags) {
        if (flags.fileName.equals(DEFAULT) && flags.journalId == -1L) {
            LOG.info("ERROR: You should figure jounalId or journal filename");
            return false;
        }
        return true;
    }

    private synchronized List<Journal> getJournals(ServerConfiguration conf) {
        if (null == this.journals) {
            this.journals = Lists.newArrayListWithCapacity(conf.getJournalDirs().length);
            int idx = 0;
            for (File journalDir : conf.getJournalDirs()) {
                this.journals.add(new Journal(idx++, new File(journalDir, "current"), conf, new LedgerDirsManager(conf, conf.getLedgerDirs(), new DiskChecker(conf.getDiskUsageThreshold(), conf.getDiskUsageWarnThreshold()))));
            }
        }
        return this.journals;
    }

    private void scanJournal(Journal journal, long journalId, final boolean printMsg) throws IOException {
        LOG.info("Scan journal " + journalId + " (" + Long.toHexString(journalId) + ".txn)");
        this.scanJournal(journal, journalId, new Journal.JournalScanner(){
            boolean printJournalVersion = false;

            @Override
            public void process(int journalVersion, long offset, ByteBuffer entry) throws IOException {
                if (!this.printJournalVersion) {
                    LOG.info("Journal Version : " + journalVersion);
                    this.printJournalVersion = true;
                }
                FormatUtil.formatEntry(offset, Unpooled.wrappedBuffer(entry), printMsg, ReadJournalCommand.this.ledgerIdFormatter, ReadJournalCommand.this.entryFormatter);
            }
        });
    }

    private void scanJournal(Journal journal, long journalId, Journal.JournalScanner scanner) throws IOException {
        journal.scanJournal(journalId, 0L, scanner);
    }

    public static class ReadJournalFlags
    extends CliFlags {
        @Parameter(names={"-m", "--msg"}, description="Print message body")
        private boolean msg;
        @Parameter(names={"-d", "--dir"}, description="Journal directory (needed if more than one journal configured)")
        private String dir = "";
        @Parameter(names={"-id", "--journalid"}, description="Journal Id")
        private long journalId = -1L;
        @Parameter(names={"-f", "--filename"}, description="Journal file name")
        private String fileName = "";
        @Parameter(names={"-l", "--ledgerIdFormatter"}, description="Set ledger id formatter")
        private String ledgerIdFormatter = "";
        @Parameter(names={"-e", "--entryformatter"}, description="set entry formatter")
        private String entryFormatter = "";

        public ReadJournalFlags msg(boolean msg) {
            this.msg = msg;
            return this;
        }

        public ReadJournalFlags dir(String dir) {
            this.dir = dir;
            return this;
        }

        public ReadJournalFlags journalId(long journalId) {
            this.journalId = journalId;
            return this;
        }

        public ReadJournalFlags fileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        public ReadJournalFlags ledgerIdFormatter(String ledgerIdFormatter) {
            this.ledgerIdFormatter = ledgerIdFormatter;
            return this;
        }

        public ReadJournalFlags entryFormatter(String entryFormatter) {
            this.entryFormatter = entryFormatter;
            return this;
        }
    }
}

