/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.util;

import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;

public abstract class CertUtils {
    public static final String OU_ROLE_NAME_CODE = "0";
    public static final String OU_CLUSTER_NAME_CODE = "1";
    public static final String OU_VALUES_SEPARATOR = ";";
    public static final String OU_CODE_SEPARATOR = ":";
    public static final String OU_NAME_SEPARATOR = ",";
    static final Pattern OU_VALUES_SPLITTER = Pattern.compile(";");
    static final Pattern OU_GENERAL_NAME_REGEX = Pattern.compile("^([0-9]+):(.*)$");
    static final Pattern OU_NAME_SPLITTER = Pattern.compile(",");

    private CertUtils() {
    }

    public static String getOUString(X509Certificate cert) throws IOException {
        return CertUtils.getOUStringFromSubject(cert.getSubjectX500Principal().getName());
    }

    public static String getOUStringFromSubject(String subject) throws IOException {
        try {
            LdapName ldapDN = new LdapName(subject);
            for (Rdn rdn : ldapDN.getRdns()) {
                if (!"OU".equalsIgnoreCase(rdn.getType())) continue;
                return rdn.getValue().toString();
            }
            return null;
        }
        catch (InvalidNameException ine) {
            throw new IOException(ine);
        }
    }

    public static Map<String, String> getOUMapFromOUString(String ou) throws IOException {
        HashMap<String, String> ouMap = new HashMap<String, String>();
        if (ou != null) {
            String[] ouParts;
            for (String ouPart : ouParts = OU_VALUES_SPLITTER.split(ou)) {
                Matcher matcher = OU_GENERAL_NAME_REGEX.matcher(ouPart);
                if (!matcher.find() || matcher.groupCount() != 2) continue;
                ouMap.put(matcher.group(1).trim(), matcher.group(2).trim());
            }
        }
        return Collections.unmodifiableMap(ouMap);
    }

    public static Map<String, String> getOUMap(X509Certificate cert) throws IOException {
        return CertUtils.getOUMapFromOUString(CertUtils.getOUString(cert));
    }

    public static String[] getRolesFromOU(X509Certificate cert) throws IOException {
        return CertUtils.getRolesFromOUMap(CertUtils.getOUMap(cert));
    }

    public static String[] getRolesFromOUMap(Map<String, String> ouMap) throws IOException {
        String[] roleParts;
        String roleNames = ouMap.get(OU_ROLE_NAME_CODE);
        if (roleNames != null && (roleParts = OU_NAME_SPLITTER.split(roleNames)).length > 0) {
            ArrayList<String> roles = new ArrayList<String>(roleParts.length);
            for (String role : roleParts) {
                roles.add(role.trim());
            }
            return roles.toArray(new String[roles.size()]);
        }
        return null;
    }
}

