/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.util;

import java.util.Map;
import java.util.concurrent.RejectedExecutionException;
import org.apache.pulsar.shade.org.apache.bookkeeper.common.util.MdcUtils;
import org.apache.pulsar.shade.org.apache.bookkeeper.common.util.OrderedExecutor;
import org.apache.pulsar.shade.org.apache.bookkeeper.common.util.SafeRunnable;
import org.apache.pulsar.shade.org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public abstract class OrderedGenericCallback<T>
implements BookkeeperInternalCallbacks.GenericCallback<T> {
    private static final Logger LOG = LoggerFactory.getLogger(OrderedGenericCallback.class);
    private final OrderedExecutor executor;
    private final long orderingKey;
    private final Map<String, String> mdcContextMap;

    public OrderedGenericCallback(OrderedExecutor executor, long orderingKey) {
        this.executor = executor;
        this.orderingKey = orderingKey;
        this.mdcContextMap = executor.preserveMdc() ? MDC.getCopyOfContextMap() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void operationComplete(final int rc, final T result) {
        MdcUtils.restoreContext(this.mdcContextMap);
        try {
            if (Thread.currentThread().getId() == this.executor.getThreadID(this.orderingKey)) {
                this.safeOperationComplete(rc, result);
            } else {
                try {
                    this.executor.executeOrdered(this.orderingKey, new SafeRunnable(){

                        @Override
                        public void safeRun() {
                            OrderedGenericCallback.this.safeOperationComplete(rc, result);
                        }

                        public String toString() {
                            return String.format("Callback(key=%s, name=%s)", OrderedGenericCallback.this.orderingKey, OrderedGenericCallback.this);
                        }
                    });
                }
                catch (RejectedExecutionException re) {
                    LOG.warn("Failed to submit callback for {} : ", (Object)this.orderingKey, (Object)re);
                }
            }
        }
        finally {
            MDC.clear();
        }
    }

    public abstract void safeOperationComplete(int var1, T var2);
}

