/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.pulsar.common.compression;

import java.io.IOException;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.shade.io.netty.buffer.ByteBuf;
import org.apache.pulsar.shade.io.netty.util.concurrent.FastThreadLocal;
import org.apache.pulsar.shade.org.apache.pulsar.common.allocator.PulsarByteBufAllocator;
import org.apache.pulsar.shade.org.apache.pulsar.common.compression.CompressionCodec;

public class CompressionCodecZLib
implements CompressionCodec {
    private final FastThreadLocal<Deflater> deflater = new FastThreadLocal<Deflater>(){

        @Override
        protected Deflater initialValue() throws Exception {
            return new Deflater();
        }

        @Override
        protected void onRemoval(Deflater deflater) throws Exception {
            deflater.end();
        }
    };
    private final FastThreadLocal<Inflater> inflater = new FastThreadLocal<Inflater>(){

        @Override
        protected Inflater initialValue() throws Exception {
            return new Inflater();
        }

        @Override
        protected void onRemoval(Inflater inflater) throws Exception {
            inflater.end();
        }
    };

    @Override
    public ByteBuf encode(ByteBuf source) {
        byte[] array;
        int length = source.readableBytes();
        int sizeEstimate = (int)Math.ceil((double)source.readableBytes() * 1.001) + 14;
        ByteBuf compressed = PulsarByteBufAllocator.DEFAULT.heapBuffer(sizeEstimate);
        int offset = 0;
        if (source.hasArray()) {
            array = source.array();
            offset = source.arrayOffset() + source.readerIndex();
        } else {
            array = new byte[length];
            source.getBytes(source.readerIndex(), array);
        }
        Deflater deflater = this.deflater.get();
        deflater.reset();
        deflater.setInput(array, offset, length);
        while (!deflater.needsInput()) {
            CompressionCodecZLib.deflate(deflater, compressed);
        }
        return compressed;
    }

    private static void deflate(Deflater deflater, ByteBuf out) {
        int numBytes;
        do {
            int writerIndex = out.writerIndex();
            numBytes = deflater.deflate(out.array(), out.arrayOffset() + writerIndex, out.writableBytes(), 2);
            out.writerIndex(writerIndex + numBytes);
        } while (numBytes > 0);
    }

    @Override
    public ByteBuf decode(ByteBuf encoded, int uncompressedLength) throws IOException {
        int resultLength;
        int offset;
        byte[] array;
        ByteBuf uncompressed = PulsarByteBufAllocator.DEFAULT.heapBuffer(uncompressedLength, uncompressedLength);
        int len = encoded.readableBytes();
        if (encoded.hasArray()) {
            array = encoded.array();
            offset = encoded.arrayOffset() + encoded.readerIndex();
        } else {
            array = new byte[len];
            encoded.getBytes(encoded.readerIndex(), array);
            offset = 0;
        }
        Inflater inflater = this.inflater.get();
        inflater.reset();
        inflater.setInput(array, offset, len);
        try {
            resultLength = inflater.inflate(uncompressed.array(), uncompressed.arrayOffset(), uncompressedLength);
        }
        catch (DataFormatException e) {
            throw new IOException(e);
        }
        Preconditions.checkArgument(resultLength == uncompressedLength);
        uncompressed.writerIndex(uncompressedLength);
        return uncompressed;
    }
}

