/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.pulsar.common.sasl;

import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.pulsar.shade.org.apache.pulsar.common.sasl.SaslConstants;
import org.apache.pulsar.shade.org.apache.pulsar.common.sasl.TGTRefreshThread;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JAASCredentialsContainer
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(JAASCredentialsContainer.class);
    private Subject subject;
    private String principal;
    private boolean isKrbTicket;
    private boolean isUsingTicketCache;
    private TGTRefreshThread ticketRefreshThread;
    public CallbackHandler callbackHandler;
    private String loginContextName;
    private LoginContext loginContext;
    private Map<String, String> configuration;

    public JAASCredentialsContainer(String loginContextName, CallbackHandler callbackHandler, Map<String, String> configuration) throws LoginException {
        this.configuration = configuration;
        this.callbackHandler = callbackHandler;
        this.loginContextName = loginContextName;
        AppConfigurationEntry[] entries = Configuration.getConfiguration().getAppConfigurationEntry(loginContextName);
        if (entries == null) {
            String errorMessage = "loginContext name (JAAS file section header) was null. Please check your java.security.login.auth.config (=" + System.getProperty("java.security.login.auth.config") + ") for section header: " + this.loginContextName;
            log.error("No JAAS Configuration section header found for Client: {}", (Object)errorMessage);
            throw new LoginException(errorMessage);
        }
        LoginContext loginContext = new LoginContext(loginContextName, callbackHandler);
        loginContext.login();
        log.info("successfully logged in.");
        this.loginContext = loginContext;
        this.subject = loginContext.getSubject();
        boolean bl = this.isKrbTicket = !this.subject.getPrivateCredentials(KerberosTicket.class).isEmpty();
        if (!this.isKrbTicket) {
            throw new LoginException("Kerberos authentication without KerberosTicket provided!");
        }
        this.isUsingTicketCache = SaslConstants.isUsingTicketCache(loginContextName);
        this.principal = SaslConstants.getPrincipal(loginContextName);
        this.ticketRefreshThread = new TGTRefreshThread(this);
        this.ticketRefreshThread.start();
    }

    void setLoginContext(LoginContext login) {
        this.loginContext = login;
    }

    @Override
    public void close() throws IOException {
        block3: {
            if (this.ticketRefreshThread != null) {
                this.ticketRefreshThread.interrupt();
                try {
                    this.ticketRefreshThread.join(10000L);
                }
                catch (InterruptedException exit) {
                    Thread.currentThread().interrupt();
                    if (!log.isDebugEnabled()) break block3;
                    log.debug("interrupted while waiting for TGT refresh thread to stop", (Throwable)exit);
                }
            }
        }
    }

    public Subject getSubject() {
        return this.subject;
    }

    public String getPrincipal() {
        return this.principal;
    }

    public boolean isKrbTicket() {
        return this.isKrbTicket;
    }

    public boolean isUsingTicketCache() {
        return this.isUsingTicketCache;
    }

    public TGTRefreshThread getTicketRefreshThread() {
        return this.ticketRefreshThread;
    }

    public CallbackHandler getCallbackHandler() {
        return this.callbackHandler;
    }

    public String getLoginContextName() {
        return this.loginContextName;
    }

    public LoginContext getLoginContext() {
        return this.loginContext;
    }

    public Map<String, String> getConfiguration() {
        return this.configuration;
    }
}

