/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.pulsar.common.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Set;
import javax.net.ssl.SSLException;
import org.apache.pulsar.shade.io.netty.handler.ssl.SslContext;
import org.apache.pulsar.shade.io.netty.handler.ssl.SslProvider;
import org.apache.pulsar.shade.org.apache.pulsar.common.util.FileModifiedTimeUpdater;
import org.apache.pulsar.shade.org.apache.pulsar.common.util.SecurityUtility;
import org.apache.pulsar.shade.org.apache.pulsar.common.util.SslContextAutoRefreshBuilder;

public class NettyServerSslContextBuilder
extends SslContextAutoRefreshBuilder<SslContext> {
    private volatile SslContext sslNettyContext;
    protected final boolean tlsAllowInsecureConnection;
    protected final FileModifiedTimeUpdater tlsTrustCertsFilePath;
    protected final FileModifiedTimeUpdater tlsCertificateFilePath;
    protected final FileModifiedTimeUpdater tlsKeyFilePath;
    protected final Set<String> tlsCiphers;
    protected final Set<String> tlsProtocols;
    protected final boolean tlsRequireTrustedClientCertOnConnect;
    protected final SslProvider sslProvider;

    public NettyServerSslContextBuilder(SslProvider sslProvider, boolean allowInsecure, String trustCertsFilePath, String certificateFilePath, String keyFilePath, Set<String> ciphers, Set<String> protocols, boolean requireTrustedClientCertOnConnect, long delayInSeconds) {
        super(delayInSeconds);
        this.tlsAllowInsecureConnection = allowInsecure;
        this.tlsTrustCertsFilePath = new FileModifiedTimeUpdater(trustCertsFilePath);
        this.tlsCertificateFilePath = new FileModifiedTimeUpdater(certificateFilePath);
        this.tlsKeyFilePath = new FileModifiedTimeUpdater(keyFilePath);
        this.tlsCiphers = ciphers;
        this.tlsProtocols = protocols;
        this.tlsRequireTrustedClientCertOnConnect = requireTrustedClientCertOnConnect;
        this.sslProvider = sslProvider;
    }

    @Override
    public synchronized SslContext update() throws SSLException, FileNotFoundException, GeneralSecurityException, IOException {
        this.sslNettyContext = SecurityUtility.createNettySslContextForServer(this.sslProvider, this.tlsAllowInsecureConnection, this.tlsTrustCertsFilePath.getFileName(), this.tlsCertificateFilePath.getFileName(), this.tlsKeyFilePath.getFileName(), this.tlsCiphers, this.tlsProtocols, this.tlsRequireTrustedClientCertOnConnect);
        return this.sslNettyContext;
    }

    @Override
    public SslContext getSslContext() {
        return this.sslNettyContext;
    }

    @Override
    public boolean needUpdate() {
        return this.tlsTrustCertsFilePath.checkAndRefresh() || this.tlsCertificateFilePath.checkAndRefresh() || this.tlsKeyFilePath.checkAndRefresh();
    }
}

