/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.eclipse.jetty.websocket.jsr356.client;

import org.apache.pulsar.shade.javax.websocket.ClientEndpoint;
import org.apache.pulsar.shade.javax.websocket.ClientEndpointConfig;
import org.apache.pulsar.shade.javax.websocket.DeploymentException;
import org.apache.pulsar.shade.org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.apache.pulsar.shade.org.eclipse.jetty.websocket.common.events.EventDriver;
import org.apache.pulsar.shade.org.eclipse.jetty.websocket.common.events.EventDriverImpl;
import org.apache.pulsar.shade.org.eclipse.jetty.websocket.jsr356.annotations.JsrEvents;
import org.apache.pulsar.shade.org.eclipse.jetty.websocket.jsr356.client.AnnotatedClientEndpointMetadata;
import org.apache.pulsar.shade.org.eclipse.jetty.websocket.jsr356.endpoints.EndpointInstance;
import org.apache.pulsar.shade.org.eclipse.jetty.websocket.jsr356.endpoints.JsrAnnotatedEventDriver;

public class JsrClientEndpointImpl
implements EventDriverImpl {
    @Override
    public EventDriver create(Object websocket, WebSocketPolicy policy) throws DeploymentException {
        if (!(websocket instanceof EndpointInstance)) {
            throw new IllegalStateException(String.format("Websocket %s must be an %s", websocket.getClass().getName(), EndpointInstance.class.getName()));
        }
        EndpointInstance ei = (EndpointInstance)websocket;
        AnnotatedClientEndpointMetadata metadata = (AnnotatedClientEndpointMetadata)ei.getMetadata();
        JsrEvents<ClientEndpoint, ClientEndpointConfig> events = new JsrEvents<ClientEndpoint, ClientEndpointConfig>(metadata);
        int maxBinaryMessage = this.getMaxMessageSize(policy.getMaxBinaryMessageSize(), metadata.maxBinaryMessageSize());
        int maxTextMessage = this.getMaxMessageSize(policy.getMaxTextMessageSize(), metadata.maxTextMessageSize());
        policy.setMaxBinaryMessageSize(maxBinaryMessage);
        policy.setMaxTextMessageSize(maxTextMessage);
        return new JsrAnnotatedEventDriver(policy, ei, events);
    }

    @Override
    public String describeRule() {
        return "class is annotated with @" + ClientEndpoint.class.getName();
    }

    private int getMaxMessageSize(int defaultMaxMessageSize, long maxMessageSize) {
        if (maxMessageSize >= 1L) {
            return (int)maxMessageSize;
        }
        return defaultMaxMessageSize;
    }

    @Override
    public boolean supports(Object websocket) {
        if (!(websocket instanceof EndpointInstance)) {
            return false;
        }
        EndpointInstance ei = (EndpointInstance)websocket;
        Object endpoint = ei.getEndpoint();
        ClientEndpoint anno = endpoint.getClass().getAnnotation(ClientEndpoint.class);
        return anno != null;
    }
}

