/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.glassfish.jersey.server.internal.inject;

import java.util.function.Function;
import org.apache.pulsar.shade.javax.inject.Provider;
import org.apache.pulsar.shade.javax.inject.Singleton;
import org.apache.pulsar.shade.javax.ws.rs.BadRequestException;
import org.apache.pulsar.shade.javax.ws.rs.container.ContainerRequestContext;
import org.apache.pulsar.shade.javax.ws.rs.core.Request;
import org.apache.pulsar.shade.javax.ws.rs.core.Response;
import org.apache.pulsar.shade.org.glassfish.jersey.model.Parameter;
import org.apache.pulsar.shade.org.glassfish.jersey.server.ContainerRequest;
import org.apache.pulsar.shade.org.glassfish.jersey.server.internal.LocalizationMessages;
import org.apache.pulsar.shade.org.glassfish.jersey.server.internal.inject.AbstractValueParamProvider;
import org.apache.pulsar.shade.org.glassfish.jersey.server.internal.inject.MultivaluedParameterExtractorProvider;
import org.apache.pulsar.shade.org.glassfish.jersey.server.model.Parameter;

@Singleton
class EntityParamValueParamProvider
extends AbstractValueParamProvider {
    EntityParamValueParamProvider(Provider<MultivaluedParameterExtractorProvider> mpep) {
        super(mpep, Parameter.Source.ENTITY);
    }

    @Override
    protected Function<ContainerRequest, ?> createValueProvider(Parameter parameter) {
        return new EntityValueSupplier(parameter);
    }

    private static class EntityValueSupplier
    implements Function<ContainerRequest, Object> {
        private final Parameter parameter;

        public EntityValueSupplier(Parameter parameter) {
            this.parameter = parameter;
        }

        @Override
        public Object apply(ContainerRequest containerRequest) {
            ContainerRequest value;
            Class<?> rawType = this.parameter.getRawType();
            if ((Request.class.isAssignableFrom(rawType) || ContainerRequestContext.class.isAssignableFrom(rawType)) && rawType.isInstance(containerRequest)) {
                value = containerRequest;
            } else {
                value = containerRequest.readEntity(rawType, this.parameter.getType(), this.parameter.getAnnotations());
                if (rawType.isPrimitive() && value == null) {
                    throw new BadRequestException(Response.status(Response.Status.BAD_REQUEST).entity(LocalizationMessages.ERROR_PRIMITIVE_TYPE_NULL()).build());
                }
            }
            return value;
        }
    }
}

