/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.rocksdb;

import org.apache.pulsar.shade.org.rocksdb.DBOptions;
import org.apache.pulsar.shade.org.rocksdb.RateLimiter;
import org.apache.pulsar.shade.org.rocksdb.RocksDB;
import org.apache.pulsar.shade.org.rocksdb.RocksObject;

public class EnvOptions
extends RocksObject {
    private RateLimiter rateLimiter;

    public EnvOptions() {
        super(EnvOptions.newEnvOptions());
    }

    public EnvOptions(DBOptions dBOptions) {
        super(EnvOptions.newEnvOptions(dBOptions.nativeHandle_));
    }

    public EnvOptions setUseMmapReads(boolean bl) {
        this.setUseMmapReads(this.nativeHandle_, bl);
        return this;
    }

    public boolean useMmapReads() {
        assert (this.isOwningHandle());
        return this.useMmapReads(this.nativeHandle_);
    }

    public EnvOptions setUseMmapWrites(boolean bl) {
        this.setUseMmapWrites(this.nativeHandle_, bl);
        return this;
    }

    public boolean useMmapWrites() {
        assert (this.isOwningHandle());
        return this.useMmapWrites(this.nativeHandle_);
    }

    public EnvOptions setUseDirectReads(boolean bl) {
        this.setUseDirectReads(this.nativeHandle_, bl);
        return this;
    }

    public boolean useDirectReads() {
        assert (this.isOwningHandle());
        return this.useDirectReads(this.nativeHandle_);
    }

    public EnvOptions setUseDirectWrites(boolean bl) {
        this.setUseDirectWrites(this.nativeHandle_, bl);
        return this;
    }

    public boolean useDirectWrites() {
        assert (this.isOwningHandle());
        return this.useDirectWrites(this.nativeHandle_);
    }

    public EnvOptions setAllowFallocate(boolean bl) {
        this.setAllowFallocate(this.nativeHandle_, bl);
        return this;
    }

    public boolean allowFallocate() {
        assert (this.isOwningHandle());
        return this.allowFallocate(this.nativeHandle_);
    }

    public EnvOptions setSetFdCloexec(boolean bl) {
        this.setSetFdCloexec(this.nativeHandle_, bl);
        return this;
    }

    public boolean setFdCloexec() {
        assert (this.isOwningHandle());
        return this.setFdCloexec(this.nativeHandle_);
    }

    public EnvOptions setBytesPerSync(long l) {
        this.setBytesPerSync(this.nativeHandle_, l);
        return this;
    }

    public long bytesPerSync() {
        assert (this.isOwningHandle());
        return this.bytesPerSync(this.nativeHandle_);
    }

    public EnvOptions setFallocateWithKeepSize(boolean bl) {
        this.setFallocateWithKeepSize(this.nativeHandle_, bl);
        return this;
    }

    public boolean fallocateWithKeepSize() {
        assert (this.isOwningHandle());
        return this.fallocateWithKeepSize(this.nativeHandle_);
    }

    public EnvOptions setCompactionReadaheadSize(long l) {
        this.setCompactionReadaheadSize(this.nativeHandle_, l);
        return this;
    }

    public long compactionReadaheadSize() {
        assert (this.isOwningHandle());
        return this.compactionReadaheadSize(this.nativeHandle_);
    }

    public EnvOptions setRandomAccessMaxBufferSize(long l) {
        this.setRandomAccessMaxBufferSize(this.nativeHandle_, l);
        return this;
    }

    public long randomAccessMaxBufferSize() {
        assert (this.isOwningHandle());
        return this.randomAccessMaxBufferSize(this.nativeHandle_);
    }

    public EnvOptions setWritableFileMaxBufferSize(long l) {
        this.setWritableFileMaxBufferSize(this.nativeHandle_, l);
        return this;
    }

    public long writableFileMaxBufferSize() {
        assert (this.isOwningHandle());
        return this.writableFileMaxBufferSize(this.nativeHandle_);
    }

    public EnvOptions setRateLimiter(RateLimiter rateLimiter) {
        this.rateLimiter = rateLimiter;
        this.setRateLimiter(this.nativeHandle_, rateLimiter.nativeHandle_);
        return this;
    }

    public RateLimiter rateLimiter() {
        assert (this.isOwningHandle());
        return this.rateLimiter;
    }

    private static native long newEnvOptions();

    private static native long newEnvOptions(long var0);

    @Override
    protected final native void disposeInternal(long var1);

    private native void setUseMmapReads(long var1, boolean var3);

    private native boolean useMmapReads(long var1);

    private native void setUseMmapWrites(long var1, boolean var3);

    private native boolean useMmapWrites(long var1);

    private native void setUseDirectReads(long var1, boolean var3);

    private native boolean useDirectReads(long var1);

    private native void setUseDirectWrites(long var1, boolean var3);

    private native boolean useDirectWrites(long var1);

    private native void setAllowFallocate(long var1, boolean var3);

    private native boolean allowFallocate(long var1);

    private native void setSetFdCloexec(long var1, boolean var3);

    private native boolean setFdCloexec(long var1);

    private native void setBytesPerSync(long var1, long var3);

    private native long bytesPerSync(long var1);

    private native void setFallocateWithKeepSize(long var1, boolean var3);

    private native boolean fallocateWithKeepSize(long var1);

    private native void setCompactionReadaheadSize(long var1, long var3);

    private native long compactionReadaheadSize(long var1);

    private native void setRandomAccessMaxBufferSize(long var1, long var3);

    private native long randomAccessMaxBufferSize(long var1);

    private native void setWritableFileMaxBufferSize(long var1, long var3);

    private native long writableFileMaxBufferSize(long var1);

    private native void setRateLimiter(long var1, long var3);

    static {
        RocksDB.loadLibrary();
    }
}

