/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.websocket.service;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.pulsar.broker.PulsarServerException;
import org.apache.pulsar.broker.web.JettyRequestLogFactory;
import org.apache.pulsar.broker.web.JsonMapperProvider;
import org.apache.pulsar.broker.web.WebExecutorThreadPool;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.jetty.tls.JettySslContextFactory;
import org.apache.pulsar.shade.com.google.common.collect.Lists;
import org.apache.pulsar.shade.javax.servlet.Servlet;
import org.apache.pulsar.shade.javax.servlet.ServletException;
import org.apache.pulsar.shade.javax.websocket.DeploymentException;
import org.apache.pulsar.shade.org.eclipse.jetty.server.AbstractNetworkConnector;
import org.apache.pulsar.shade.org.eclipse.jetty.server.Handler;
import org.apache.pulsar.shade.org.eclipse.jetty.server.Server;
import org.apache.pulsar.shade.org.eclipse.jetty.server.ServerConnector;
import org.apache.pulsar.shade.org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.apache.pulsar.shade.org.eclipse.jetty.server.handler.DefaultHandler;
import org.apache.pulsar.shade.org.eclipse.jetty.server.handler.HandlerCollection;
import org.apache.pulsar.shade.org.eclipse.jetty.server.handler.RequestLogHandler;
import org.apache.pulsar.shade.org.eclipse.jetty.servlet.ServletContextHandler;
import org.apache.pulsar.shade.org.eclipse.jetty.servlet.ServletHolder;
import org.apache.pulsar.shade.org.eclipse.jetty.util.ssl.SslContextFactory;
import org.apache.pulsar.shade.org.glassfish.jersey.server.ResourceConfig;
import org.apache.pulsar.shade.org.glassfish.jersey.servlet.ServletContainer;
import org.apache.pulsar.websocket.service.WebSocketProxyConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyServer {
    private final Server server;
    private final List<Handler> handlers = Lists.newArrayList();
    private final WebSocketProxyConfiguration conf;
    private final WebExecutorThreadPool executorService;
    private ServerConnector connector;
    private ServerConnector connectorTls;
    private static final Logger log = LoggerFactory.getLogger(ProxyServer.class);

    public ProxyServer(WebSocketProxyConfiguration config) throws PulsarClientException, MalformedURLException, PulsarServerException {
        this.conf = config;
        this.executorService = new WebExecutorThreadPool(config.getNumHttpServerThreads(), "pulsar-websocket-web");
        this.server = new Server(this.executorService);
        ArrayList<ServerConnector> connectors = new ArrayList<ServerConnector>();
        if (config.getWebServicePort().isPresent()) {
            this.connector = new ServerConnector(this.server);
            this.connector.setPort(config.getWebServicePort().get());
            connectors.add(this.connector);
        }
        if (config.getWebServicePortTls().isPresent()) {
            try {
                SslContextFactory sslCtxFactory = config.isTlsEnabledWithKeyStore() ? JettySslContextFactory.createServerSslContextWithKeystore(config.getTlsProvider(), config.getTlsKeyStoreType(), config.getTlsKeyStore(), config.getTlsKeyStorePassword(), config.isTlsAllowInsecureConnection(), config.getTlsTrustStoreType(), config.getTlsTrustStore(), config.getTlsTrustStorePassword(), config.isTlsRequireTrustedClientCertOnConnect(), config.getWebServiceTlsCiphers(), config.getWebServiceTlsProtocols(), config.getTlsCertRefreshCheckDurationSec()) : JettySslContextFactory.createServerSslContext(config.getTlsProvider(), config.isTlsAllowInsecureConnection(), config.getTlsTrustCertsFilePath(), config.getTlsCertificateFilePath(), config.getTlsKeyFilePath(), config.isTlsRequireTrustedClientCertOnConnect(), config.getWebServiceTlsCiphers(), config.getWebServiceTlsProtocols(), config.getTlsCertRefreshCheckDurationSec());
                this.connectorTls = new ServerConnector(this.server, sslCtxFactory);
                this.connectorTls.setPort(config.getWebServicePortTls().get());
                connectors.add(this.connectorTls);
            }
            catch (Exception e) {
                throw new PulsarServerException(e);
            }
        }
        connectors.stream().forEach(c -> c.setAcceptQueueSize(1024 / connectors.size()));
        this.server.setConnectors(connectors.toArray(new ServerConnector[connectors.size()]));
    }

    public void addWebSocketServlet(String basePath, Servlet socketServlet) throws ServletException, DeploymentException {
        ServletHolder servletHolder = new ServletHolder("ws-events", socketServlet);
        ServletContextHandler context = new ServletContextHandler(1);
        context.setContextPath(basePath);
        context.addServlet(servletHolder, "/*");
        this.handlers.add(context);
    }

    public void addRestResources(String basePath, String javaPackages, String attribute, Object attributeValue) {
        ResourceConfig config = new ResourceConfig();
        config.packages("org.apache.pulsar.shade.jersey.config.server.provider.packages", javaPackages);
        config.register((Class)JsonMapperProvider.class);
        ServletHolder servletHolder = new ServletHolder(new ServletContainer(config));
        servletHolder.setAsyncSupported(true);
        ServletContextHandler context = new ServletContextHandler(1);
        context.setContextPath(basePath);
        context.addServlet(servletHolder, "/*");
        context.setAttribute(attribute, attributeValue);
        this.handlers.add(context);
    }

    public void start() throws PulsarServerException {
        log.info("Starting web socket proxy at port {}", (Object)Arrays.stream(this.server.getConnectors()).map(ServerConnector.class::cast).map(AbstractNetworkConnector::getPort).map(Object::toString).collect(Collectors.joining(",")));
        RequestLogHandler requestLogHandler = new RequestLogHandler();
        requestLogHandler.setRequestLog(JettyRequestLogFactory.createRequestLogger());
        this.handlers.add(0, new ContextHandlerCollection());
        this.handlers.add(requestLogHandler);
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        contexts.setHandlers(this.handlers.toArray(new Handler[this.handlers.size()]));
        HandlerCollection handlerCollection = new HandlerCollection();
        handlerCollection.setHandlers(new Handler[]{contexts, new DefaultHandler(), requestLogHandler});
        this.server.setHandler(handlerCollection);
        try {
            this.server.start();
        }
        catch (Exception e) {
            throw new PulsarServerException(e);
        }
    }

    public void stop() throws Exception {
        this.server.stop();
        this.executorService.stop();
    }

    public Optional<Integer> getListenPortHTTP() {
        if (this.connector != null) {
            return Optional.of(this.connector.getLocalPort());
        }
        return Optional.empty();
    }

    public Optional<Integer> getListenPortHTTPS() {
        if (this.connectorTls != null) {
            return Optional.of(this.connectorTls.getLocalPort());
        }
        return Optional.empty();
    }
}

