/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.zookeeper;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.apache.pulsar.shade.com.google.common.collect.Lists;
import org.apache.pulsar.shade.org.apache.zookeeper.WatchedEvent;
import org.apache.pulsar.shade.org.apache.zookeeper.Watcher;
import org.apache.pulsar.shade.org.apache.zookeeper.data.Stat;
import org.apache.pulsar.zookeeper.ZooKeeperCache;
import org.apache.pulsar.zookeeper.ZooKeeperCacheListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ZooKeeperDataCache<T>
implements ZooKeeperCache.Deserializer<T>,
ZooKeeperCache.CacheUpdater<T>,
Watcher {
    private static final Logger LOG = LoggerFactory.getLogger(ZooKeeperDataCache.class);
    private final ZooKeeperCache cache;
    private final List<ZooKeeperCacheListener<T>> listeners = Lists.newCopyOnWriteArrayList();
    private final int zkOperationTimeoutSeconds;
    private static final int FALSE = 0;
    private static final int TRUE = 1;
    private static final AtomicIntegerFieldUpdater<ZooKeeperDataCache> IS_SHUTDOWN_UPDATER = AtomicIntegerFieldUpdater.newUpdater(ZooKeeperDataCache.class, "isShutdown");
    private volatile int isShutdown = 0;

    public ZooKeeperDataCache(ZooKeeperCache cache) {
        this.cache = cache;
        this.zkOperationTimeoutSeconds = cache.getZkOperationTimeoutSeconds();
    }

    public CompletableFuture<Optional<T>> getAsync(String path) {
        CompletableFuture future = new CompletableFuture();
        ((CompletableFuture)this.cache.getDataAsync(path, this, this).thenAccept(entry -> future.complete(entry.map(Map.Entry::getKey)))).exceptionally(ex -> {
            this.cache.asyncInvalidate(path);
            future.completeExceptionally((Throwable)ex);
            return null;
        });
        return future;
    }

    public CompletableFuture<Optional<Map.Entry<T, Stat>>> getWithStatAsync(String path) {
        return this.cache.getDataAsync(path, this, this).whenComplete((entry, ex) -> {
            if (ex != null) {
                this.cache.asyncInvalidate(path);
            }
        });
    }

    public Optional<T> get(String path) throws Exception {
        try {
            return this.getAsync(path).get(this.zkOperationTimeoutSeconds, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            this.cache.asyncInvalidate(path);
            throw e;
        }
    }

    public Optional<Map.Entry<T, Stat>> getWithStat(String path) throws Exception {
        return this.cache.getData(path, this, this);
    }

    public void clear() {
        this.cache.invalidateAllData();
    }

    public void invalidate(String path) {
        this.cache.invalidateData(path);
    }

    @Override
    public void reloadCache(String path) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Reloading ZooKeeperDataCache at path {}", (Object)path);
        }
        this.cache.invalidate(path);
        ((CompletableFuture)this.cache.getDataAsync(path, this, this).thenAccept(cacheEntry -> {
            if (!cacheEntry.isPresent()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Node [{}] does not exist", (Object)path);
                }
                return;
            }
            for (ZooKeeperCacheListener zooKeeperCacheListener : this.listeners) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Notifying listener {} at path {}", zooKeeperCacheListener, (Object)path);
                }
                zooKeeperCacheListener.onUpdate(path, ((Map.Entry)cacheEntry.get()).getKey(), (Stat)((Map.Entry)cacheEntry.get()).getValue());
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Notified listener {} at path {}", zooKeeperCacheListener, (Object)path);
            }
        })).exceptionally(ex -> {
            LOG.warn("Reloading ZooKeeperDataCache failed at path: {}", (Object)path, ex);
            return null;
        });
    }

    @Override
    public void registerListener(ZooKeeperCacheListener<T> listener) {
        this.listeners.add(listener);
    }

    @Override
    public void unregisterListener(ZooKeeperCacheListener<T> listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void process(WatchedEvent event) {
        LOG.info("[{}] Received ZooKeeper watch event: {}", (Object)this.cache.zkSession.get(), (Object)event);
        if (IS_SHUTDOWN_UPDATER.get(this) == 0) {
            this.cache.process(event, this);
        }
    }

    public T getDataIfPresent(String path) {
        return this.cache.getDataIfPresent(path);
    }

    public void close() {
        IS_SHUTDOWN_UPDATER.set(this, 1);
    }
}

