/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service.schema.validator;

import com.google.protobuf.Descriptors;
import org.apache.pulsar.broker.service.schema.exceptions.InvalidSchemaDataException;
import org.apache.pulsar.broker.service.schema.validator.SchemaDataValidator;
import org.apache.pulsar.client.impl.schema.ProtobufNativeSchemaUtils;
import org.apache.pulsar.common.protocol.schema.SchemaData;

public class ProtobufNativeSchemaDataValidator
implements SchemaDataValidator {
    private static final ProtobufNativeSchemaDataValidator INSTANCE = new ProtobufNativeSchemaDataValidator();

    @Override
    public void validate(SchemaData schemaData) throws InvalidSchemaDataException {
        Descriptors.Descriptor descriptor;
        try {
            descriptor = ProtobufNativeSchemaUtils.deserialize((byte[])schemaData.getData());
        }
        catch (Exception e) {
            throw new InvalidSchemaDataException("deserialize ProtobufNative Schema failed", e);
        }
        if (descriptor == null) {
            throw new InvalidSchemaDataException("protobuf root message descriptor is null , please recheck rootMessageTypeName or rootFileDescriptorName conf. ");
        }
    }

    public static ProtobufNativeSchemaDataValidator of() {
        return INSTANCE;
    }

    private ProtobufNativeSchemaDataValidator() {
    }
}

