/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.transaction.pendingack;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.broker.service.persistent.PersistentSubscription;
import org.apache.pulsar.broker.transaction.pendingack.PendingAckStore;

public interface TransactionPendingAckStoreProvider {
    public static TransactionPendingAckStoreProvider newProvider(String providerClassName) throws IOException {
        try {
            Class<?> providerClass = Class.forName(providerClassName);
            Object obj = providerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Preconditions.checkArgument((boolean)(obj instanceof TransactionPendingAckStoreProvider), (Object)("The factory has to be an instance of " + TransactionPendingAckStoreProvider.class.getName()));
            return (TransactionPendingAckStoreProvider)obj;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public CompletableFuture<PendingAckStore> newPendingAckStore(PersistentSubscription var1);

    public CompletableFuture<Boolean> checkInitializedBefore(PersistentSubscription var1);
}

