/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import java.util.List;
import java.util.Map;
import org.apache.pulsar.broker.service.BrokerServiceException;
import org.apache.pulsar.broker.service.Consumer;
import org.apache.pulsar.client.api.Range;
import org.apache.pulsar.common.util.Murmur3_32Hash;

public interface StickyKeyConsumerSelector {
    public static final int DEFAULT_RANGE_SIZE = 65536;

    public void addConsumer(Consumer var1) throws BrokerServiceException.ConsumerAssignException;

    public void removeConsumer(Consumer var1);

    default public Consumer select(byte[] stickyKey) {
        return this.select(StickyKeyConsumerSelector.makeStickyKeyHash(stickyKey));
    }

    public static int makeStickyKeyHash(byte[] stickyKey) {
        return Murmur3_32Hash.getInstance().makeHash(stickyKey);
    }

    public Consumer select(int var1);

    public Map<Consumer, List<Range>> getConsumerKeyHashRanges();
}

