/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service.plugin;

import java.io.IOException;
import org.apache.bookkeeper.mledger.Entry;
import org.apache.pulsar.broker.service.plugin.EntryFilter;
import org.apache.pulsar.broker.service.plugin.FilterContext;
import org.apache.pulsar.common.nar.NarClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntryFilterWithClassLoader
implements EntryFilter {
    private static final Logger log = LoggerFactory.getLogger(EntryFilterWithClassLoader.class);
    private final EntryFilter entryFilter;
    private final NarClassLoader classLoader;

    public EntryFilterWithClassLoader(EntryFilter entryFilter, NarClassLoader classLoader) {
        this.entryFilter = entryFilter;
        this.classLoader = classLoader;
    }

    @Override
    public EntryFilter.FilterResult filterEntry(Entry entry, FilterContext context) {
        return this.entryFilter.filterEntry(entry, context);
    }

    @Override
    public void close() {
        this.entryFilter.close();
        try {
            this.classLoader.close();
        }
        catch (IOException e) {
            log.error("close EntryFilterWithClassLoader failed", (Throwable)e);
        }
    }
}

