/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service.schema.validator;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.jsonSchema.JsonSchema;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.avro.Schema;
import org.apache.avro.SchemaParseException;
import org.apache.pulsar.broker.service.schema.exceptions.InvalidSchemaDataException;
import org.apache.pulsar.broker.service.schema.validator.SchemaDataValidator;
import org.apache.pulsar.common.protocol.schema.SchemaData;
import org.apache.pulsar.common.schema.SchemaType;
import org.apache.pulsar.common.util.ObjectMapperFactory;

class StructSchemaDataValidator
implements SchemaDataValidator {
    private static final StructSchemaDataValidator INSTANCE = new StructSchemaDataValidator();

    public static StructSchemaDataValidator of() {
        return INSTANCE;
    }

    private StructSchemaDataValidator() {
    }

    @Override
    public void validate(SchemaData schemaData) throws InvalidSchemaDataException {
        byte[] data = schemaData.getData();
        try {
            Schema.Parser avroSchemaParser = new Schema.Parser();
            avroSchemaParser.setValidateDefaults(false);
            avroSchemaParser.parse(new String(data, StandardCharsets.UTF_8));
        }
        catch (SchemaParseException e) {
            if (schemaData.getType() == SchemaType.JSON) {
                ObjectMapper objectMapper = ObjectMapperFactory.getThreadLocal();
                try {
                    objectMapper.readValue(data, JsonSchema.class);
                }
                catch (IOException ioe) {
                    StructSchemaDataValidator.throwInvalidSchemaDataException(schemaData, ioe);
                }
            } else {
                StructSchemaDataValidator.throwInvalidSchemaDataException(schemaData, e);
            }
        }
        catch (Exception e) {
            StructSchemaDataValidator.throwInvalidSchemaDataException(schemaData, e);
        }
    }

    private static void throwInvalidSchemaDataException(SchemaData schemaData, Throwable cause) throws InvalidSchemaDataException {
        throw new InvalidSchemaDataException("Invalid schema definition data for " + schemaData.getType() + " schema", cause);
    }
}

