/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.admin.v1;

import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Response;
import org.apache.pulsar.broker.admin.impl.NamespacesBase;
import org.apache.pulsar.broker.web.RestException;
import org.apache.pulsar.common.api.proto.CommandGetTopicsOfNamespace;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.policies.data.AuthAction;
import org.apache.pulsar.common.policies.data.AutoSubscriptionCreationOverride;
import org.apache.pulsar.common.policies.data.AutoTopicCreationOverride;
import org.apache.pulsar.common.policies.data.BacklogQuota;
import org.apache.pulsar.common.policies.data.BookieAffinityGroupData;
import org.apache.pulsar.common.policies.data.BundlesData;
import org.apache.pulsar.common.policies.data.DispatchRate;
import org.apache.pulsar.common.policies.data.NamespaceOperation;
import org.apache.pulsar.common.policies.data.PersistencePolicies;
import org.apache.pulsar.common.policies.data.Policies;
import org.apache.pulsar.common.policies.data.PoliciesUtil;
import org.apache.pulsar.common.policies.data.PolicyName;
import org.apache.pulsar.common.policies.data.PolicyOperation;
import org.apache.pulsar.common.policies.data.PublishRate;
import org.apache.pulsar.common.policies.data.RetentionPolicies;
import org.apache.pulsar.common.policies.data.SchemaAutoUpdateCompatibilityStrategy;
import org.apache.pulsar.common.policies.data.SubscriptionAuthMode;
import org.apache.pulsar.common.policies.data.TenantOperation;
import org.apache.pulsar.common.policies.data.impl.DispatchRateImpl;
import org.apache.pulsar.metadata.api.MetadataStoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/namespaces")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Api(value="/namespaces", description="Namespaces admin apis", tags={"namespaces"}, hidden=true)
public class Namespaces
extends NamespacesBase {
    private static final Logger log = LoggerFactory.getLogger(Namespaces.class);

    @GET
    @Path(value="/{property}")
    @ApiOperation(value="Get the list of all the namespaces for a certain property.", response=String.class, responseContainer="Set")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Property doesn't exist")})
    public List<String> getTenantNamespaces(@PathParam(value="property") String property) {
        return this.internalGetTenantNamespaces(property);
    }

    @GET
    @Path(value="/{property}/{cluster}")
    @ApiOperation(hidden=true, value="Get the list of all the namespaces for a certain property on single cluster.", response=String.class, responseContainer="Set")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Tenant or cluster doesn't exist")})
    public List<String> getNamespacesForCluster(@PathParam(value="property") String tenant, @PathParam(value="cluster") String cluster) {
        this.validateTenantOperation(tenant, TenantOperation.LIST_NAMESPACES);
        ArrayList namespaces = Lists.newArrayList();
        if (!this.clusters().contains(cluster)) {
            log.warn("[{}] Failed to get namespace list for tenant: {}/{} - Cluster does not exist", new Object[]{this.clientAppId(), tenant, cluster});
            throw new RestException(Response.Status.NOT_FOUND, "Cluster does not exist");
        }
        try {
            for (String namespace : this.clusterResources().getNamespacesForCluster(tenant, cluster)) {
                namespaces.add(NamespaceName.get((String)tenant, (String)cluster, (String)namespace).toString());
            }
        }
        catch (MetadataStoreException.NotFoundException notFoundException) {
        }
        catch (Exception e) {
            log.error("[{}] Failed to get namespaces list: {}", (Object)this.clientAppId(), (Object)e);
            throw new RestException(e);
        }
        namespaces.sort(null);
        return namespaces;
    }

    @GET
    @Path(value="/{property}/{cluster}/{namespace}/destinations")
    @ApiOperation(hidden=true, value="Get the list of all the topics under a certain namespace.", response=String.class, responseContainer="Set")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin or operate permission on the namespace"), @ApiResponse(code=404, message="Property or cluster or namespace doesn't exist")})
    public void getTopics(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, @QueryParam(value="mode") @DefaultValue(value="PERSISTENT") CommandGetTopicsOfNamespace.Mode mode, @Suspended AsyncResponse asyncResponse) {
        this.validateNamespaceName(property, cluster, namespace);
        this.validateNamespaceOperation(NamespaceName.get((String)property, (String)namespace), NamespaceOperation.GET_TOPICS);
        this.getNamespacePolicies(this.namespaceName);
        ((CompletableFuture)this.pulsar().getNamespaceService().getListOfTopics(this.namespaceName, mode).thenAccept(arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0))).exceptionally(ex -> {
            log.error("Failed to get topics list for namespace {}", (Object)this.namespaceName, ex);
            asyncResponse.resume(ex);
            return null;
        });
    }

    @GET
    @Path(value="/{property}/{cluster}/{namespace}")
    @ApiOperation(hidden=true, value="Get the dump all the policies specified for a namespace.", response=Policies.class)
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Property or cluster or namespace doesn't exist")})
    public Policies getPolicies(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace) {
        this.validateNamespaceName(property, cluster, namespace);
        this.validateNamespacePolicyOperation(NamespaceName.get((String)property, (String)namespace), PolicyName.ALL, PolicyOperation.READ);
        return this.getNamespacePolicies(this.namespaceName);
    }

    @PUT
    @Path(value="/{property}/{cluster}/{namespace}")
    @ApiOperation(hidden=true, value="Creates a new empty namespace with no policies attached.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Property or cluster or namespace doesn't exist"), @ApiResponse(code=409, message="Namespace already exists"), @ApiResponse(code=412, message="Namespace name is not valid")})
    public void createNamespace(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, BundlesData initialBundles) {
        this.validateNamespaceName(property, cluster, namespace);
        if (!this.namespaceName.isGlobal()) {
            this.validateClusterForTenant(this.namespaceName.getTenant(), this.namespaceName.getCluster());
        }
        Policies policies = new Policies();
        if (initialBundles != null && initialBundles.getNumBundles() > 0) {
            policies.bundles = initialBundles.getBoundaries() == null || initialBundles.getBoundaries().size() == 0 ? PoliciesUtil.getBundles((int)initialBundles.getNumBundles()) : this.validateBundlesData(initialBundles);
        } else {
            int defaultNumberOfBundles = this.config().getDefaultNumberOfNamespaceBundles();
            policies.bundles = PoliciesUtil.getBundles((int)defaultNumberOfBundles);
        }
        this.internalCreateNamespace(policies);
    }

    @DELETE
    @Path(value="/{property}/{cluster}/{namespace}")
    @ApiOperation(hidden=true, value="Delete a namespace and all the topics under it.")
    @ApiResponses(value={@ApiResponse(code=307, message="Current broker doesn't serve the namespace"), @ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Property or cluster or namespace doesn't exist"), @ApiResponse(code=405, message="Broker doesn't allow forced deletion of namespaces"), @ApiResponse(code=409, message="Namespace is not empty")})
    public void deleteNamespace(@Suspended AsyncResponse asyncResponse, @PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, @QueryParam(value="force") @DefaultValue(value="false") boolean force, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        try {
            this.validateNamespaceName(property, cluster, namespace);
            this.internalDeleteNamespace(asyncResponse, authoritative, force);
        }
        catch (WebApplicationException wae) {
            asyncResponse.resume((Throwable)wae);
        }
        catch (Exception e) {
            asyncResponse.resume((Throwable)((Object)new RestException(e)));
        }
    }

    @DELETE
    @Path(value="/{property}/{cluster}/{namespace}/{bundle}")
    @ApiOperation(hidden=true, value="Delete a namespace bundle and all the topics under it.")
    @ApiResponses(value={@ApiResponse(code=307, message="Current broker doesn't serve the namespace"), @ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Property or cluster or namespace doesn't exist"), @ApiResponse(code=409, message="Namespace bundle is not empty")})
    public void deleteNamespaceBundle(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, @PathParam(value="bundle") String bundleRange, @QueryParam(value="force") @DefaultValue(value="false") boolean force, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        this.validateNamespaceName(property, cluster, namespace);
        this.internalDeleteNamespaceBundle(bundleRange, authoritative, force);
    }

    @GET
    @Path(value="/{property}/{cluster}/{namespace}/permissions")
    @ApiOperation(hidden=true, value="Retrieve the permissions for a namespace.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Property or cluster or namespace doesn't exist"), @ApiResponse(code=409, message="Namespace is not empty")})
    public Map<String, Set<AuthAction>> getPermissions(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace) {
        this.validateNamespaceName(property, cluster, namespace);
        this.validateNamespaceOperation(NamespaceName.get((String)property, (String)namespace), NamespaceOperation.GET_PERMISSION);
        Policies policies = this.getNamespacePolicies(this.namespaceName);
        return policies.auth_policies.getNamespaceAuthentication();
    }

    @GET
    @Path(value="/{property}/{cluster}/{namespace}/permissions/subscription")
    @ApiOperation(value="Retrieve the permissions for a subscription.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Property or cluster or namespace doesn't exist"), @ApiResponse(code=409, message="Namespace is not empty")})
    public Map<String, Set<String>> getPermissionOnSubscription(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace) {
        this.validateNamespaceName(property, cluster, namespace);
        this.validateNamespaceOperation(NamespaceName.get((String)property, (String)namespace), NamespaceOperation.GET_PERMISSION);
        Policies policies = this.getNamespacePolicies(this.namespaceName);
        return policies.auth_policies.getSubscriptionAuthentication();
    }

    @POST
    @Path(value="/{property}/{cluster}/{namespace}/permissions/{role}")
    @ApiOperation(hidden=true, value="Grant a new permission to a role on a namespace.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Property or cluster or namespace doesn't exist"), @ApiResponse(code=409, message="Concurrent modification"), @ApiResponse(code=501, message="Authorization is not enabled")})
    public void grantPermissionOnNamespace(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, @PathParam(value="role") String role, Set<AuthAction> actions) {
        this.validateNamespaceName(property, cluster, namespace);
        this.internalGrantPermissionOnNamespace(role, actions);
    }

    @POST
    @Path(value="/{property}/{cluster}/{namespace}/permissions/subscription/{subscription}")
    @ApiOperation(hidden=true, value="Grant a new permission to roles for a subscription. [Tenant admin is allowed to perform this operation]")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Property or cluster or namespace doesn't exist"), @ApiResponse(code=409, message="Concurrent modification"), @ApiResponse(code=501, message="Authorization is not enabled")})
    public void grantPermissionOnSubscription(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, @PathParam(value="subscription") String subscription, Set<String> roles) {
        this.validateNamespaceName(property, cluster, namespace);
        this.internalGrantPermissionOnSubscription(subscription, roles);
    }

    @DELETE
    @Path(value="/{property}/{cluster}/{namespace}/permissions/{role}")
    @ApiOperation(hidden=true, value="Revoke all permissions to a role on a namespace.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Property or cluster or namespace doesn't exist")})
    public void revokePermissionsOnNamespace(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, @PathParam(value="role") String role) {
        this.validateNamespaceName(property, cluster, namespace);
        this.internalRevokePermissionsOnNamespace(role);
    }

    @DELETE
    @Path(value="/{property}/{cluster}/{namespace}/permissions/{subscription}/{role}")
    @ApiOperation(hidden=true, value="Revoke subscription admin-api access permission for a role.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Property or cluster or namespace doesn't exist")})
    public void revokePermissionOnSubscription(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, @PathParam(value="subscription") String subscription, @PathParam(value="role") String role) {
        this.validateNamespaceName(property, cluster, namespace);
        this.internalRevokePermissionsOnSubscription(subscription, role);
    }

    @GET
    @Path(value="/{property}/{cluster}/{namespace}/replication")
    @ApiOperation(hidden=true, value="Get the replication clusters for a namespace.", response=String.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Property or cluster or namespace doesn't exist"), @ApiResponse(code=412, message="Namespace is not global")})
    public Set<String> getNamespaceReplicationClusters(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace) {
        this.validateNamespaceName(property, cluster, namespace);
        this.validateNamespacePolicyOperation(NamespaceName.get((String)property, (String)namespace), PolicyName.REPLICATION, PolicyOperation.READ);
        return this.internalGetNamespaceReplicationClusters();
    }

    @POST
    @Path(value="/{property}/{cluster}/{namespace}/replication")
    @ApiOperation(hidden=true, value="Set the replication clusters for a namespace.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Property or cluster or namespace doesn't exist"), @ApiResponse(code=409, message="Peer-cluster can't be part of replication-cluster"), @ApiResponse(code=412, message="Namespace is not global or invalid cluster ids")})
    public void setNamespaceReplicationClusters(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, List<String> clusterIds) {
        this.validateNamespaceName(property, cluster, namespace);
        this.internalSetNamespaceReplicationClusters(clusterIds);
    }

    @GET
    @Path(value="/{property}/{cluster}/{namespace}/messageTTL")
    @ApiOperation(hidden=true, value="Get the message TTL for the namespace")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Property or cluster or namespace doesn't exist")})
    public Integer getNamespaceMessageTTL(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace) {
        this.validateNamespaceName(property, cluster, namespace);
        this.validateNamespacePolicyOperation(NamespaceName.get((String)property, (String)namespace), PolicyName.TTL, PolicyOperation.READ);
        Policies policies = this.getNamespacePolicies(this.namespaceName);
        return policies.message_ttl_in_seconds;
    }

    @POST
    @Path(value="/{property}/{cluster}/{namespace}/messageTTL")
    @ApiOperation(hidden=true, value="Set message TTL in seconds for namespace")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Property or cluster or namespace doesn't exist"), @ApiResponse(code=412, message="Invalid TTL")})
    public void setNamespaceMessageTTL(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, int messageTTL) {
        this.validateNamespaceName(property, cluster, namespace);
        this.internalSetNamespaceMessageTTL(messageTTL);
    }

    @DELETE
    @Path(value="/{property}/{cluster}/{namespace}/messageTTL")
    @ApiOperation(value="Set message TTL in seconds for namespace")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Tenant or cluster or namespace doesn't exist"), @ApiResponse(code=412, message="Invalid TTL")})
    public void removeNamespaceMessageTTL(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace) {
        this.validateNamespaceName(property, cluster, namespace);
        this.internalSetNamespaceMessageTTL(null);
    }

    @GET
    @Path(value="/{property}/{cluster}/{namespace}/subscriptionExpirationTime")
    @ApiOperation(hidden=true, value="Get the subscription expiration time for the namespace")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Property or cluster or namespace doesn't exist")})
    public Integer getSubscriptionExpirationTime(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace) {
        this.validateAdminAccessForTenant(property);
        this.validateNamespaceName(property, cluster, namespace);
        Policies policies = this.getNamespacePolicies(this.namespaceName);
        return policies.subscription_expiration_time_minutes;
    }

    @POST
    @Path(value="/{property}/{cluster}/{namespace}/subscriptionExpirationTime")
    @ApiOperation(hidden=true, value="Set subscription expiration time in minutes for namespace")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Property or cluster or namespace doesn't exist"), @ApiResponse(code=412, message="Invalid expiration time")})
    public void setSubscriptionExpirationTime(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, int expirationTime) {
        this.validateNamespaceName(property, cluster, namespace);
        this.internalSetSubscriptionExpirationTime(expirationTime);
    }

    @DELETE
    @Path(value="/{property}/{cluster}/{namespace}/subscriptionExpirationTime")
    @ApiOperation(hidden=true, value="Remove subscription expiration time for namespace")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Property or cluster or namespace doesn't exist")})
    public void removeSubscriptionExpirationTime(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace) {
        this.validateNamespaceName(property, cluster, namespace);
        this.internalSetSubscriptionExpirationTime(null);
    }

    @POST
    @Path(value="/{property}/{cluster}/{namespace}/antiAffinity")
    @ApiOperation(value="Set anti-affinity group for a namespace")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Property or cluster or namespace doesn't exist"), @ApiResponse(code=412, message="Invalid antiAffinityGroup")})
    public void setNamespaceAntiAffinityGroup(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, String antiAffinityGroup) {
        this.validateNamespaceName(property, cluster, namespace);
        this.internalSetNamespaceAntiAffinityGroup(antiAffinityGroup);
    }

    @GET
    @Path(value="/{property}/{cluster}/{namespace}/antiAffinity")
    @ApiOperation(value="Get anti-affinity group of a namespace.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Property or cluster or namespace doesn't exist")})
    public String getNamespaceAntiAffinityGroup(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace) {
        this.validateNamespaceName(property, cluster, namespace);
        return this.internalGetNamespaceAntiAffinityGroup();
    }

    @GET
    @Path(value="{cluster}/antiAffinity/{group}")
    @ApiOperation(value="Get all namespaces that are grouped by given anti-affinity group in a given cluster. api can be only accessed by admin of any of the existing property")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=412, message="Cluster not exist/Anti-affinity group can't be empty.")})
    public List<String> getAntiAffinityNamespaces(@PathParam(value="cluster") String cluster, @PathParam(value="group") String antiAffinityGroup, @QueryParam(value="property") String property) {
        return this.internalGetAntiAffinityNamespaces(cluster, antiAffinityGroup, property);
    }

    @DELETE
    @Path(value="/{property}/{cluster}/{namespace}/antiAffinity")
    @ApiOperation(value="Remove anti-affinity group of a namespace.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace does not exist"), @ApiResponse(code=409, message="Concurrent modification")})
    public void removeNamespaceAntiAffinityGroup(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace) {
        this.validateNamespaceName(property, cluster, namespace);
        this.internalRemoveNamespaceAntiAffinityGroup();
    }

    @POST
    @Path(value="/{property}/{cluster}/{namespace}/deduplication")
    @ApiOperation(hidden=true, value="Enable or disable broker side deduplication for all topics in a namespace")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Property or cluster or namespace doesn't exist")})
    public void modifyDeduplication(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, boolean enableDeduplication) {
        this.validateNamespaceName(property, cluster, namespace);
        this.internalModifyDeduplication(enableDeduplication);
    }

    @GET
    @Path(value="/{property}/{cluster}/{namespace}/autoTopicCreation")
    @ApiOperation(value="Get autoTopicCreation info in a namespace")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Tenant or cluster or namespace doesn't exist")})
    public AutoTopicCreationOverride getAutoTopicCreation(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace) {
        this.validateNamespaceName(property, cluster, namespace);
        return this.internalGetAutoTopicCreation();
    }

    @POST
    @Path(value="/{property}/{cluster}/{namespace}/autoTopicCreation")
    @ApiOperation(value="Override broker's allowAutoTopicCreation setting for a namespace")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Tenant or cluster or namespace doesn't exist"), @ApiResponse(code=406, message="The number of partitions should be less than or equal to maxNumPartitionsPerPartitionedTopic"), @ApiResponse(code=400, message="Invalid autoTopicCreation override")})
    public void setAutoTopicCreation(@Suspended AsyncResponse asyncResponse, @PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, AutoTopicCreationOverride autoTopicCreationOverride) {
        try {
            this.validateNamespaceName(property, cluster, namespace);
            this.internalSetAutoTopicCreation(asyncResponse, autoTopicCreationOverride);
        }
        catch (RestException e) {
            asyncResponse.resume((Throwable)((Object)e));
        }
        catch (Exception e) {
            asyncResponse.resume((Throwable)((Object)new RestException(e)));
        }
    }

    @DELETE
    @Path(value="/{property}/{cluster}/{namespace}/autoTopicCreation")
    @ApiOperation(value="Remove override of broker's allowAutoTopicCreation in a namespace")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Tenant or cluster or namespace doesn't exist")})
    public void removeAutoTopicCreation(@Suspended AsyncResponse asyncResponse, @PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace) {
        try {
            this.validateNamespaceName(property, cluster, namespace);
            this.internalRemoveAutoTopicCreation(asyncResponse);
        }
        catch (RestException e) {
            asyncResponse.resume((Throwable)((Object)e));
        }
        catch (Exception e) {
            asyncResponse.resume((Throwable)((Object)new RestException(e)));
        }
    }

    @POST
    @Path(value="/{property}/{cluster}/{namespace}/autoSubscriptionCreation")
    @ApiOperation(value="Override broker's allowAutoSubscriptionCreation setting for a namespace")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Tenant or cluster or namespace doesn't exist"), @ApiResponse(code=400, message="Invalid autoSubscriptionCreation override")})
    public void setAutoSubscriptionCreation(@Suspended AsyncResponse asyncResponse, @PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, AutoSubscriptionCreationOverride autoSubscriptionCreationOverride) {
        try {
            this.validateNamespaceName(property, cluster, namespace);
            this.internalSetAutoSubscriptionCreation(asyncResponse, autoSubscriptionCreationOverride);
        }
        catch (RestException e) {
            asyncResponse.resume((Throwable)((Object)e));
        }
        catch (Exception e) {
            asyncResponse.resume((Throwable)((Object)new RestException(e)));
        }
    }

    @GET
    @Path(value="/{property}/{cluster}/{namespace}/autoSubscriptionCreation")
    @ApiOperation(value="Get autoSubscriptionCreation info in a namespace")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Property or cluster or namespace doesn't exist")})
    public AutoSubscriptionCreationOverride getAutoSubscriptionCreation(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace) {
        this.validateNamespaceName(property, cluster, namespace);
        return this.internalGetAutoSubscriptionCreation();
    }

    @DELETE
    @Path(value="/{property}/{cluster}/{namespace}/autoSubscriptionCreation")
    @ApiOperation(value="Remove override of broker's allowAutoSubscriptionCreation in a namespace")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Tenant or cluster or namespace doesn't exist")})
    public void removeAutoSubscriptionCreation(@Suspended AsyncResponse asyncResponse, @PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace) {
        try {
            this.validateNamespaceName(property, cluster, namespace);
            this.internalRemoveAutoSubscriptionCreation(asyncResponse);
        }
        catch (RestException e) {
            asyncResponse.resume((Throwable)((Object)e));
        }
        catch (Exception e) {
            asyncResponse.resume((Throwable)((Object)new RestException(e)));
        }
    }

    @GET
    @Path(value="/{property}/{cluster}/{namespace}/bundles")
    @ApiOperation(hidden=true, value="Get the bundles split data.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Property or cluster or namespace doesn't exist"), @ApiResponse(code=412, message="Namespace is not setup to split in bundles")})
    public BundlesData getBundlesData(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace) {
        this.validatePoliciesReadOnlyAccess();
        this.validateNamespaceName(property, cluster, namespace);
        this.validateNamespaceOperation(NamespaceName.get((String)property, (String)namespace), NamespaceOperation.GET_BUNDLE);
        Policies policies = this.getNamespacePolicies(this.namespaceName);
        return policies.bundles;
    }

    @PUT
    @Path(value="/{property}/{cluster}/{namespace}/unload")
    @ApiOperation(hidden=true, value="Unload namespace", notes="Unload an active namespace from the current broker serving it. Performing this operation will let the brokerremoves all producers, consumers, and connections using this namespace, and close all topics (includingtheir persistent store). During that operation, the namespace is marked as tentatively unavailable until thebroker completes the unloading action. This operation requires strictly super user privileges, since it wouldresult in non-persistent message loss and unexpected connection closure to the clients.")
    @ApiResponses(value={@ApiResponse(code=307, message="Current broker doesn't serve the namespace"), @ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Property or cluster or namespace doesn't exist"), @ApiResponse(code=412, message="Namespace is already unloaded or Namespace has bundles activated")})
    public void unloadNamespace(@Suspended AsyncResponse asyncResponse, @PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace) {
        try {
            this.validateNamespaceName(property, cluster, namespace);
            this.internalUnloadNamespace(asyncResponse);
        }
        catch (WebApplicationException wae) {
            asyncResponse.resume((Throwable)wae);
        }
        catch (Exception e) {
            asyncResponse.resume((Throwable)((Object)new RestException(e)));
        }
    }

    @PUT
    @Path(value="/{property}/{cluster}/{namespace}/{bundle}/unload")
    @ApiOperation(hidden=true, value="Unload a namespace bundle")
    @ApiResponses(value={@ApiResponse(code=307, message="Current broker doesn't serve the namespace"), @ApiResponse(code=403, message="Don't have admin permission")})
    public void unloadNamespaceBundle(@Suspended AsyncResponse asyncResponse, @PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, @PathParam(value="bundle") String bundleRange, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        this.validateNamespaceName(property, cluster, namespace);
        this.internalUnloadNamespaceBundle(asyncResponse, bundleRange, authoritative);
    }

    @PUT
    @Path(value="/{property}/{cluster}/{namespace}/{bundle}/split")
    @ApiOperation(hidden=true, value="Split a namespace bundle")
    @ApiResponses(value={@ApiResponse(code=307, message="Current broker doesn't serve the namespace"), @ApiResponse(code=403, message="Don't have admin permission")})
    public void splitNamespaceBundle(@Suspended AsyncResponse asyncResponse, @PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, @PathParam(value="bundle") String bundleRange, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative, @QueryParam(value="unload") @DefaultValue(value="false") boolean unload) {
        try {
            this.validateNamespaceName(property, cluster, namespace);
            this.internalSplitNamespaceBundle(asyncResponse, bundleRange, authoritative, unload, "range_equally_divide");
        }
        catch (WebApplicationException wae) {
            asyncResponse.resume((Throwable)wae);
        }
        catch (Exception e) {
            asyncResponse.resume((Throwable)((Object)new RestException(e)));
        }
    }

    @POST
    @Path(value="/{property}/{cluster}/{namespace}/publishRate")
    @ApiOperation(hidden=true, value="Set publish-rate throttling for all topics of the namespace")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission")})
    public void setPublishRate(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, PublishRate publishRate) {
        this.validateNamespaceName(property, cluster, namespace);
        this.internalSetPublishRate(publishRate);
    }

    @GET
    @Path(value="/{property}/{cluster}/{namespace}/publishRate")
    @ApiOperation(hidden=true, value="Get publish-rate configured for the namespace, null means publish-rate not configured, -1 means msg-publish-rate or byte-publish-rate not configured in publish-rate yet")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace does not exist")})
    public PublishRate getPublishRate(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace) {
        this.validateNamespaceName(property, cluster, namespace);
        return this.internalGetPublishRate();
    }

    @POST
    @Path(value="/{property}/{cluster}/{namespace}/dispatchRate")
    @ApiOperation(hidden=true, value="Set dispatch-rate throttling for all topics of the namespace")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission")})
    public void setDispatchRate(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, DispatchRateImpl dispatchRate) {
        this.validateNamespaceName(property, cluster, namespace);
        this.internalSetTopicDispatchRate(dispatchRate);
    }

    @GET
    @Path(value="/{property}/{cluster}/{namespace}/dispatchRate")
    @ApiOperation(hidden=true, value="Get dispatch-rate configured for the namespace, null means dispatch-rate not configured, -1 means msg-dispatch-rate or byte-dispatch-rate not configured in dispatch-rate yet")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace does not exist")})
    public DispatchRate getDispatchRate(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace) {
        this.validateNamespaceName(property, cluster, namespace);
        return this.internalGetTopicDispatchRate();
    }

    @POST
    @Path(value="/{property}/{cluster}/{namespace}/subscriptionDispatchRate")
    @ApiOperation(value="Set Subscription dispatch-rate throttling for all topics of the namespace")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission")})
    public void setSubscriptionDispatchRate(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, DispatchRateImpl dispatchRate) {
        this.validateNamespaceName(property, cluster, namespace);
        this.internalSetSubscriptionDispatchRate(dispatchRate);
    }

    @GET
    @Path(value="/{property}/{cluster}/{namespace}/subscriptionDispatchRate")
    @ApiOperation(value="Get subscription dispatch-rate configured for the namespace, null means subscription dispatch-rate not configured, -1 means msg-dispatch-rate or byte-dispatch-rate not configured in dispatch-rate yet")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace does not exist")})
    public DispatchRate getSubscriptionDispatchRate(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace) {
        this.validateNamespaceName(property, cluster, namespace);
        return this.internalGetSubscriptionDispatchRate();
    }

    @DELETE
    @Path(value="/{property}/{cluster}/{namespace}/subscriptionDispatchRate")
    @ApiOperation(value="Delete subscription dispatch-rate throttling for all topics of the namespace")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Property or cluster or namespace doesn't exist"), @ApiResponse(code=409, message="Concurrent modification")})
    public void deleteSubscriptionDispatchRate(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace) {
        this.validateNamespaceName(property, cluster, namespace);
        this.internalDeleteSubscriptionDispatchRate();
    }

    @POST
    @Path(value="/{tenant}/{cluster}/{namespace}/replicatorDispatchRate")
    @ApiOperation(value="Set replicator dispatch-rate throttling for all topics of the namespace")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission")})
    public void setReplicatorDispatchRate(@PathParam(value="tenant") String tenant, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, @ApiParam(value="Replicator dispatch rate for all topics of the specified namespace") DispatchRateImpl dispatchRate) {
        this.validateNamespaceName(tenant, cluster, namespace);
        this.internalSetReplicatorDispatchRate(dispatchRate);
    }

    @GET
    @Path(value="/{tenant}/{cluster}/{namespace}/replicatorDispatchRate")
    @ApiOperation(value="Get replicator dispatch-rate configured for the namespace, null means replicator dispatch-rate not configured, -1 means msg-dispatch-rate or byte-dispatch-rate not configured in dispatch-rate yet")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace does not exist")})
    public DispatchRate getReplicatorDispatchRate(@PathParam(value="tenant") String tenant, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace) {
        this.validateNamespaceName(tenant, cluster, namespace);
        return this.internalGetReplicatorDispatchRate();
    }

    @GET
    @Path(value="/{property}/{cluster}/{namespace}/backlogQuotaMap")
    @ApiOperation(hidden=true, value="Get backlog quota map on a namespace.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace does not exist")})
    public Map<BacklogQuota.BacklogQuotaType, BacklogQuota> getBacklogQuotaMap(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace) {
        this.validateNamespaceName(property, cluster, namespace);
        this.validateNamespacePolicyOperation(NamespaceName.get((String)property, (String)namespace), PolicyName.BACKLOG, PolicyOperation.READ);
        Policies policies = this.getNamespacePolicies(this.namespaceName);
        return policies.backlog_quota_map;
    }

    @POST
    @Path(value="/{property}/{cluster}/{namespace}/backlogQuota")
    @ApiOperation(hidden=true, value=" Set a backlog quota for all the topics on a namespace.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace does not exist"), @ApiResponse(code=409, message="Concurrent modification"), @ApiResponse(code=412, message="Specified backlog quota exceeds retention quota. Increase retention quota and retry request")})
    public void setBacklogQuota(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, @QueryParam(value="backlogQuotaType") BacklogQuota.BacklogQuotaType backlogQuotaType, BacklogQuota backlogQuota) {
        this.validateNamespaceName(property, cluster, namespace);
        this.internalSetBacklogQuota(backlogQuotaType, backlogQuota);
    }

    @DELETE
    @Path(value="/{property}/{cluster}/{namespace}/backlogQuota")
    @ApiOperation(hidden=true, value="Remove a backlog quota policy from a namespace.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace does not exist"), @ApiResponse(code=409, message="Concurrent modification")})
    public void removeBacklogQuota(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, @QueryParam(value="backlogQuotaType") BacklogQuota.BacklogQuotaType backlogQuotaType) {
        this.validateNamespaceName(property, cluster, namespace);
        this.internalRemoveBacklogQuota(backlogQuotaType);
    }

    @GET
    @Path(value="/{property}/{cluster}/{namespace}/retention")
    @ApiOperation(hidden=true, value="Get retention config on a namespace.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace does not exist")})
    public RetentionPolicies getRetention(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace) {
        this.validateNamespaceName(property, cluster, namespace);
        return this.internalGetRetention();
    }

    @POST
    @Path(value="/{property}/{cluster}/{namespace}/retention")
    @ApiOperation(hidden=true, value=" Set retention configuration on a namespace.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace does not exist"), @ApiResponse(code=409, message="Concurrent modification"), @ApiResponse(code=412, message="Retention Quota must exceed backlog quota")})
    public void setRetention(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, RetentionPolicies retention) {
        this.validateNamespaceName(property, cluster, namespace);
        this.internalSetRetention(retention);
    }

    @POST
    @Path(value="/{property}/{cluster}/{namespace}/persistence")
    @ApiOperation(hidden=true, value="Set the persistence configuration for all the topics on a namespace.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace does not exist"), @ApiResponse(code=409, message="Concurrent modification"), @ApiResponse(code=400, message="Invalid persistence policies")})
    public void setPersistence(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, PersistencePolicies persistence) {
        this.validateNamespaceName(property, cluster, namespace);
        this.internalSetPersistence(persistence);
    }

    @POST
    @Path(value="/{property}/{cluster}/{namespace}/persistence/bookieAffinity")
    @ApiOperation(hidden=true, value="Set the bookie-affinity-group to namespace-local policy.")
    @ApiResponses(value={@ApiResponse(code=307, message="Current broker doesn't serve the namespace"), @ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace does not exist"), @ApiResponse(code=409, message="Concurrent modification")})
    public void setBookieAffinityGroup(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, BookieAffinityGroupData bookieAffinityGroup) {
        this.validateNamespaceName(property, cluster, namespace);
        this.internalSetBookieAffinityGroup(bookieAffinityGroup);
    }

    @GET
    @Path(value="/{property}/{cluster}/{namespace}/persistence/bookieAffinity")
    @ApiOperation(hidden=true, value="Get the bookie-affinity-group from namespace-local policy.")
    @ApiResponses(value={@ApiResponse(code=307, message="Current broker doesn't serve the namespace"), @ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace does not exist"), @ApiResponse(code=409, message="Concurrent modification")})
    public BookieAffinityGroupData getBookieAffinityGroup(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace) {
        this.validateNamespaceName(property, cluster, namespace);
        return this.internalGetBookieAffinityGroup();
    }

    @DELETE
    @Path(value="/{property}/{cluster}/{namespace}/persistence/bookieAffinity")
    @ApiOperation(hidden=true, value="Delete the bookie-affinity-group from namespace-local policy.")
    @ApiResponses(value={@ApiResponse(code=307, message="Current broker doesn't serve the namespace"), @ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace does not exist"), @ApiResponse(code=409, message="Concurrent modification")})
    public void deleteBookieAffinityGroup(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace) {
        this.validateNamespaceName(property, cluster, namespace);
        this.internalDeleteBookieAffinityGroup();
    }

    @GET
    @Path(value="/{property}/{cluster}/{namespace}/persistence")
    @ApiOperation(hidden=true, value="Get the persistence configuration for a namespace.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace does not exist"), @ApiResponse(code=409, message="Concurrent modification")})
    public PersistencePolicies getPersistence(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace) {
        this.validateNamespaceName(property, cluster, namespace);
        return this.internalGetPersistence();
    }

    @POST
    @Path(value="/{property}/{cluster}/{namespace}/clearBacklog")
    @ApiOperation(hidden=true, value="Clear backlog for all topics on a namespace.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin or operate permission on the namespace"), @ApiResponse(code=404, message="Namespace does not exist")})
    public void clearNamespaceBacklog(@Suspended AsyncResponse asyncResponse, @PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        try {
            this.validateNamespaceName(property, cluster, namespace);
            this.internalClearNamespaceBacklog(asyncResponse, authoritative);
        }
        catch (WebApplicationException wae) {
            asyncResponse.resume((Throwable)wae);
        }
        catch (Exception e) {
            asyncResponse.resume((Throwable)((Object)new RestException(e)));
        }
    }

    @POST
    @Path(value="/{property}/{cluster}/{namespace}/{bundle}/clearBacklog")
    @ApiOperation(hidden=true, value="Clear backlog for all topics on a namespace bundle.")
    @ApiResponses(value={@ApiResponse(code=307, message="Current broker doesn't serve the namespace"), @ApiResponse(code=403, message="Don't have admin or operate permission on the namespace"), @ApiResponse(code=404, message="Namespace does not exist")})
    public void clearNamespaceBundleBacklog(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, @PathParam(value="bundle") String bundleRange, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        this.validateNamespaceName(property, cluster, namespace);
        this.internalClearNamespaceBundleBacklog(bundleRange, authoritative);
    }

    @POST
    @Path(value="/{property}/{cluster}/{namespace}/clearBacklog/{subscription}")
    @ApiOperation(hidden=true, value="Clear backlog for a given subscription on all topics on a namespace.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin or operate permission on the namespace"), @ApiResponse(code=404, message="Namespace does not exist")})
    public void clearNamespaceBacklogForSubscription(@Suspended AsyncResponse asyncResponse, @PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, @PathParam(value="subscription") String subscription, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        try {
            this.validateNamespaceName(property, cluster, namespace);
            this.internalClearNamespaceBacklogForSubscription(asyncResponse, subscription, authoritative);
        }
        catch (WebApplicationException wae) {
            asyncResponse.resume((Throwable)wae);
        }
        catch (Exception e) {
            asyncResponse.resume((Throwable)((Object)new RestException(e)));
        }
    }

    @POST
    @Path(value="/{property}/{cluster}/{namespace}/{bundle}/clearBacklog/{subscription}")
    @ApiOperation(hidden=true, value="Clear backlog for a given subscription on all topics on a namespace bundle.")
    @ApiResponses(value={@ApiResponse(code=307, message="Current broker doesn't serve the namespace"), @ApiResponse(code=403, message="Don't have admin or operate permission on the namespace"), @ApiResponse(code=404, message="Namespace does not exist")})
    public void clearNamespaceBundleBacklogForSubscription(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, @PathParam(value="subscription") String subscription, @PathParam(value="bundle") String bundleRange, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        this.validateNamespaceName(property, cluster, namespace);
        this.internalClearNamespaceBundleBacklogForSubscription(subscription, bundleRange, authoritative);
    }

    @POST
    @Path(value="/{property}/{cluster}/{namespace}/unsubscribe/{subscription}")
    @ApiOperation(hidden=true, value="Unsubscribes the given subscription on all topics on a namespace.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin or operate permission on the namespace"), @ApiResponse(code=404, message="Namespace does not exist")})
    public void unsubscribeNamespace(@Suspended AsyncResponse asyncResponse, @PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, @PathParam(value="subscription") String subscription, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        try {
            this.validateNamespaceName(property, cluster, namespace);
            this.internalUnsubscribeNamespace(asyncResponse, subscription, authoritative);
        }
        catch (WebApplicationException wae) {
            asyncResponse.resume((Throwable)wae);
        }
        catch (Exception e) {
            asyncResponse.resume((Throwable)((Object)new RestException(e)));
        }
    }

    @POST
    @Path(value="/{property}/{cluster}/{namespace}/{bundle}/unsubscribe/{subscription}")
    @ApiOperation(hidden=true, value="Unsubscribes the given subscription on all topics on a namespace bundle.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin or operate permission on the namespace"), @ApiResponse(code=404, message="Namespace does not exist")})
    public void unsubscribeNamespaceBundle(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, @PathParam(value="subscription") String subscription, @PathParam(value="bundle") String bundleRange, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        this.validateNamespaceName(property, cluster, namespace);
        this.internalUnsubscribeNamespaceBundle(subscription, bundleRange, authoritative);
    }

    @POST
    @Path(value="/{property}/{cluster}/{namespace}/subscriptionAuthMode")
    @ApiOperation(value=" Set a subscription auth mode for all the topics on a namespace.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace does not exist"), @ApiResponse(code=409, message="Concurrent modification")})
    public void setSubscriptionAuthMode(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, SubscriptionAuthMode subscriptionAuthMode) {
        this.validateNamespaceName(property, cluster, namespace);
        this.internalSetSubscriptionAuthMode(subscriptionAuthMode);
    }

    @GET
    @Path(value="/{property}/{cluster}/{namespace}/subscriptionAuthMode")
    @ApiOperation(value="Get subscription auth mode in a namespace")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Property or cluster or namespace doesn't exist")})
    public SubscriptionAuthMode getSubscriptionAuthMode(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace) {
        this.validateNamespaceName(property, cluster, namespace);
        return this.internalGetSubscriptionAuthMode();
    }

    @POST
    @Path(value="/{property}/{cluster}/{namespace}/encryptionRequired")
    @ApiOperation(hidden=true, value="Message encryption is required or not for all topics in a namespace")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Property or cluster or namespace doesn't exist"), @ApiResponse(code=409, message="Concurrent modification")})
    public void modifyEncryptionRequired(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, boolean encryptionRequired) {
        this.validateNamespaceName(property, cluster, namespace);
        this.internalModifyEncryptionRequired(encryptionRequired);
    }

    @GET
    @Path(value="/{property}/{cluster}/{namespace}/encryptionRequired")
    @ApiOperation(value="Get message encryption required status in a namespace")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Property or cluster or namespace doesn't exist")})
    public Boolean getEncryptionRequired(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace) {
        this.validateAdminAccessForTenant(property);
        this.validateNamespaceName(property, cluster, namespace);
        return this.internalGetEncryptionRequired();
    }

    @GET
    @Path(value="/{property}/{cluster}/{namespace}/maxProducersPerTopic")
    @ApiOperation(value="Get maxProducersPerTopic config on a namespace.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace does not exist")})
    public int getMaxProducersPerTopic(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace) {
        this.validateNamespaceName(property, cluster, namespace);
        return this.internalGetMaxProducersPerTopic();
    }

    @POST
    @Path(value="/{property}/{cluster}/{namespace}/maxProducersPerTopic")
    @ApiOperation(value=" Set maxProducersPerTopic configuration on a namespace.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace does not exist"), @ApiResponse(code=409, message="Concurrent modification"), @ApiResponse(code=412, message="maxProducersPerTopic value is not valid")})
    public void setMaxProducersPerTopic(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, int maxProducersPerTopic) {
        this.validateNamespaceName(property, cluster, namespace);
        this.internalSetMaxProducersPerTopic(maxProducersPerTopic);
    }

    @GET
    @Path(value="/{property}/{cluster}/{namespace}/maxConsumersPerTopic")
    @ApiOperation(value="Get maxConsumersPerTopic config on a namespace.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace does not exist")})
    public Integer getMaxConsumersPerTopic(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace) {
        this.validateNamespaceName(property, cluster, namespace);
        return this.internalGetMaxConsumersPerTopic();
    }

    @POST
    @Path(value="/{property}/{cluster}/{namespace}/maxConsumersPerTopic")
    @ApiOperation(value=" Set maxConsumersPerTopic configuration on a namespace.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace does not exist"), @ApiResponse(code=409, message="Concurrent modification"), @ApiResponse(code=412, message="maxConsumersPerTopic value is not valid")})
    public void setMaxConsumersPerTopic(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, int maxConsumersPerTopic) {
        this.validateNamespaceName(property, cluster, namespace);
        this.internalSetMaxConsumersPerTopic(maxConsumersPerTopic);
    }

    @GET
    @Path(value="/{property}/{cluster}/{namespace}/maxConsumersPerSubscription")
    @ApiOperation(value="Get maxConsumersPerSubscription config on a namespace.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace does not exist")})
    public Integer getMaxConsumersPerSubscription(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace) {
        this.validateNamespaceName(property, cluster, namespace);
        return this.internalGetMaxConsumersPerSubscription();
    }

    @POST
    @Path(value="/{property}/{cluster}/{namespace}/maxConsumersPerSubscription")
    @ApiOperation(value=" Set maxConsumersPerSubscription configuration on a namespace.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace does not exist"), @ApiResponse(code=409, message="Concurrent modification"), @ApiResponse(code=412, message="maxConsumersPerSubscription value is not valid")})
    public void setMaxConsumersPerSubscription(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, int maxConsumersPerSubscription) {
        this.validateNamespaceName(property, cluster, namespace);
        this.internalSetMaxConsumersPerSubscription(maxConsumersPerSubscription);
    }

    @DELETE
    @Path(value="/{property}/{cluster}/{namespace}/maxConsumersPerSubscription")
    @ApiOperation(value="Remove maxConsumersPerSubscription configuration on a namespace.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Property or cluster or namespace doesn't exist"), @ApiResponse(code=409, message="Concurrent modification")})
    public void removeMaxConsumersPerSubscription(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace) {
        this.validateNamespaceName(property, cluster, namespace);
        this.internalSetMaxConsumersPerSubscription(null);
    }

    @GET
    @Path(value="/{property}/{cluster}/{namespace}/compactionThreshold")
    @ApiOperation(value="Maximum number of uncompacted bytes in topics before compaction is triggered.", notes="The backlog size is compared to the threshold periodically. A threshold of 0 disabled automatic compaction")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace doesn't exist")})
    public Long getCompactionThreshold(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace) {
        this.validateNamespaceName(property, cluster, namespace);
        return this.internalGetCompactionThreshold();
    }

    @PUT
    @Path(value="/{property}/{cluster}/{namespace}/compactionThreshold")
    @ApiOperation(value="Set maximum number of uncompacted bytes in a topic before compaction is triggered.", notes="The backlog size is compared to the threshold periodically. A threshold of 0 disabled automatic compaction")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace doesn't exist"), @ApiResponse(code=409, message="Concurrent modification"), @ApiResponse(code=412, message="compactionThreshold value is not valid")})
    public void setCompactionThreshold(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, long newThreshold) {
        this.validateNamespaceName(property, cluster, namespace);
        this.internalSetCompactionThreshold(newThreshold);
    }

    @GET
    @Path(value="/{property}/{cluster}/{namespace}/offloadThreshold")
    @ApiOperation(value="Maximum number of bytes stored on the pulsar cluster for a topic, before the broker will start offloading to longterm storage", notes="A negative value disables automatic offloading")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace doesn't exist")})
    public long getOffloadThreshold(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace) {
        this.validateNamespaceName(property, cluster, namespace);
        return this.internalGetOffloadThreshold();
    }

    @PUT
    @Path(value="/{property}/{cluster}/{namespace}/offloadThreshold")
    @ApiOperation(value="Set maximum number of bytes stored on the pulsar cluster for a topic, before the broker will start offloading to longterm storage", notes="A negative value disables automatic offloading")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace doesn't exist"), @ApiResponse(code=409, message="Concurrent modification"), @ApiResponse(code=412, message="offloadThreshold value is not valid")})
    public void setOffloadThreshold(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, long newThreshold) {
        this.validateNamespaceName(property, cluster, namespace);
        this.internalSetOffloadThreshold(newThreshold);
    }

    @GET
    @Path(value="/{tenant}/{cluster}/{namespace}/schemaAutoUpdateCompatibilityStrategy")
    @ApiOperation(value="The strategy used to check the compatibility of new schemas, provided by producers, before automatically updating the schema", notes="The value AutoUpdateDisabled prevents producers from updating the schema.  If set to AutoUpdateDisabled, schemas must be updated through the REST api")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace doesn't exist"), @ApiResponse(code=409, message="Concurrent modification")})
    public SchemaAutoUpdateCompatibilityStrategy getSchemaAutoUpdateCompatibilityStrategy(@PathParam(value="tenant") String tenant, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace) {
        this.validateNamespaceName(tenant, cluster, namespace);
        return this.internalGetSchemaAutoUpdateCompatibilityStrategy();
    }

    @PUT
    @Path(value="/{tenant}/{cluster}/{namespace}/schemaAutoUpdateCompatibilityStrategy")
    @ApiOperation(value="Update the strategy used to check the compatibility of new schemas, provided by producers, before automatically updating the schema", notes="The value AutoUpdateDisabled prevents producers from updating the schema.  If set to AutoUpdateDisabled, schemas must be updated through the REST api")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace doesn't exist"), @ApiResponse(code=409, message="Concurrent modification")})
    public void setSchemaAutoUpdateCompatibilityStrategy(@PathParam(value="tenant") String tenant, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, SchemaAutoUpdateCompatibilityStrategy strategy) {
        this.validateNamespaceName(tenant, cluster, namespace);
        this.internalSetSchemaAutoUpdateCompatibilityStrategy(strategy);
    }
}

