/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.admin.v3;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.concurrent.CompletableFuture;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.Encoded;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Response;
import org.apache.pulsar.broker.admin.impl.TransactionsBase;
import org.apache.pulsar.broker.service.BrokerServiceException;
import org.apache.pulsar.broker.web.RestException;
import org.apache.pulsar.common.util.FutureUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/transactions")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Api(value="/transactions", description="Transactions admin apis", tags={"transactions"})
public class Transactions
extends TransactionsBase {
    private static final Logger log = LoggerFactory.getLogger(Transactions.class);

    @GET
    @Path(value="/coordinatorStats")
    @ApiOperation(value="Get transaction coordinator stats.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=503, message="This Broker is not configured with transactionCoordinatorEnabled=true."), @ApiResponse(code=404, message="Transaction coordinator not found"), @ApiResponse(code=409, message="Concurrent modification")})
    public void getCoordinatorStats(@Suspended AsyncResponse asyncResponse, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative, @QueryParam(value="coordinatorId") Integer coordinatorId) {
        this.internalGetCoordinatorStats(asyncResponse, authoritative, coordinatorId);
    }

    @GET
    @Path(value="/transactionInBufferStats/{tenant}/{namespace}/{topic}/{mostSigBits}/{leastSigBits}")
    @ApiOperation(value="Get transaction state in transaction buffer.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Tenant or cluster or namespace or topic doesn't exist"), @ApiResponse(code=503, message="This Broker is not configured with transactionCoordinatorEnabled=true."), @ApiResponse(code=307, message="Topic is not owned by this broker!"), @ApiResponse(code=400, message="Topic is not a persistent topic!"), @ApiResponse(code=409, message="Concurrent modification")})
    public void getTransactionInBufferStats(@Suspended AsyncResponse asyncResponse, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative, @PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic, @PathParam(value="mostSigBits") String mostSigBits, @PathParam(value="leastSigBits") String leastSigBits) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        this.internalGetTransactionInBufferStats(asyncResponse, authoritative, Long.parseLong(mostSigBits), Long.parseLong(leastSigBits));
    }

    @GET
    @Path(value="/transactionInPendingAckStats/{tenant}/{namespace}/{topic}/{subName}/{mostSigBits}/{leastSigBits}")
    @ApiOperation(value="Get transaction state in pending ack.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Tenant or cluster or namespace or topic doesn't exist"), @ApiResponse(code=503, message="This Broker is not configured with transactionCoordinatorEnabled=true."), @ApiResponse(code=307, message="Topic is not owned by this broker!"), @ApiResponse(code=400, message="Topic is not a persistent topic!"), @ApiResponse(code=409, message="Concurrent modification")})
    public void getTransactionInPendingAckStats(@Suspended AsyncResponse asyncResponse, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative, @PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic, @PathParam(value="mostSigBits") String mostSigBits, @PathParam(value="leastSigBits") String leastSigBits, @PathParam(value="subName") String subName) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        this.internalGetTransactionInPendingAckStats(asyncResponse, authoritative, Long.parseLong(mostSigBits), Long.parseLong(leastSigBits), subName);
    }

    @GET
    @Path(value="/transactionBufferStats/{tenant}/{namespace}/{topic}")
    @ApiOperation(value="Get transaction buffer stats in topic.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Tenant or cluster or namespace or topic doesn't exist"), @ApiResponse(code=503, message="This Broker is not configured with transactionCoordinatorEnabled=true."), @ApiResponse(code=307, message="Topic is not owned by this broker!"), @ApiResponse(code=400, message="Topic is not a persistent topic!"), @ApiResponse(code=409, message="Concurrent modification")})
    public void getTransactionBufferStats(@Suspended AsyncResponse asyncResponse, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative, @PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        this.internalGetTransactionBufferStats(asyncResponse, authoritative);
    }

    @GET
    @Path(value="/pendingAckStats/{tenant}/{namespace}/{topic}/{subName}")
    @ApiOperation(value="Get transaction pending ack stats in topic.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Tenant or cluster or namespace or topic or subName doesn't exist"), @ApiResponse(code=503, message="This Broker is not configured with transactionCoordinatorEnabled=true."), @ApiResponse(code=307, message="Topic is not owned by this broker!"), @ApiResponse(code=400, message="Topic is not a persistent topic!"), @ApiResponse(code=409, message="Concurrent modification")})
    public void getPendingAckStats(@Suspended AsyncResponse asyncResponse, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative, @PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic, @PathParam(value="subName") String subName) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        this.internalGetPendingAckStats(asyncResponse, authoritative, subName);
    }

    @GET
    @Path(value="/transactionMetadata/{mostSigBits}/{leastSigBits}")
    @ApiOperation(value="Get transaction metadata")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Tenant or cluster or namespace or topic or coordinator or transaction doesn't exist"), @ApiResponse(code=503, message="This Broker is not configured with transactionCoordinatorEnabled=true."), @ApiResponse(code=307, message="Topic is not owned by this broker!"), @ApiResponse(code=400, message="Topic is not a persistent topic!"), @ApiResponse(code=409, message="Concurrent modification")})
    public void getTransactionMetadata(@Suspended AsyncResponse asyncResponse, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative, @PathParam(value="mostSigBits") String mostSigBits, @PathParam(value="leastSigBits") String leastSigBits) {
        this.internalGetTransactionMetadata(asyncResponse, authoritative, Integer.parseInt(mostSigBits), Long.parseLong(leastSigBits));
    }

    @GET
    @Path(value="/slowTransactions/{timeout}")
    @ApiOperation(value="Get slow transactions.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Tenant or cluster or namespace or topic or coordinator or transaction doesn't exist"), @ApiResponse(code=503, message="This Broker is not configured with transactionCoordinatorEnabled=true."), @ApiResponse(code=307, message="Topic don't owner by this broker!"), @ApiResponse(code=400, message="Topic is not a persistent topic!"), @ApiResponse(code=409, message="Concurrent modification")})
    public void getSlowTransactions(@Suspended AsyncResponse asyncResponse, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative, @PathParam(value="timeout") String timeout, @QueryParam(value="coordinatorId") Integer coordinatorId) {
        this.internalGetSlowTransactions(asyncResponse, authoritative, Long.parseLong(timeout), coordinatorId);
    }

    @GET
    @Path(value="/coordinatorInternalStats/{coordinatorId}")
    @ApiOperation(value="Get coordinator internal stats.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=503, message="This Broker is not configured with transactionCoordinatorEnabled=true."), @ApiResponse(code=404, message="Transaction coordinator not found"), @ApiResponse(code=405, message="Broker don't use MLTransactionMetadataStore!"), @ApiResponse(code=409, message="Concurrent modification")})
    public void getCoordinatorInternalStats(@Suspended AsyncResponse asyncResponse, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative, @PathParam(value="coordinatorId") String coordinatorId, @QueryParam(value="metadata") @DefaultValue(value="false") boolean metadata) {
        this.internalGetCoordinatorInternalStats(asyncResponse, authoritative, metadata, Integer.parseInt(coordinatorId));
    }

    @GET
    @Path(value="/pendingAckInternalStats/{tenant}/{namespace}/{topic}/{subName}")
    @ApiOperation(value="Get transaction pending ack internal stats.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Tenant or cluster or namespace or topic or subscription name doesn't exist"), @ApiResponse(code=503, message="This Broker is not configured with transactionCoordinatorEnabled=true."), @ApiResponse(code=307, message="Topic is not owned by this broker!"), @ApiResponse(code=405, message="Pending ack handle don't use managedLedger!"), @ApiResponse(code=400, message="Topic is not a persistent topic!"), @ApiResponse(code=409, message="Concurrent modification")})
    public void getPendingAckInternalStats(@Suspended AsyncResponse asyncResponse, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative, @PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic, @PathParam(value="subName") String subName, @QueryParam(value="metadata") @DefaultValue(value="false") boolean metadata) {
        try {
            this.validateTopicName(tenant, namespace, encodedTopic);
            ((CompletableFuture)this.internalGetPendingAckInternalStats(authoritative, this.topicName, subName, metadata).thenAccept(stats -> asyncResponse.resume(stats))).exceptionally(ex -> {
                Throwable cause = FutureUtil.unwrapCompletionException((Throwable)ex);
                log.error("[{}] Failed to get pending ack internal stats {}", new Object[]{this.clientAppId(), this.topicName, cause});
                if (cause instanceof BrokerServiceException.ServiceUnitNotReadyException) {
                    asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.SERVICE_UNAVAILABLE, cause)));
                } else if (cause instanceof BrokerServiceException.NotAllowedException) {
                    asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.METHOD_NOT_ALLOWED, cause)));
                } else if (cause instanceof BrokerServiceException.SubscriptionNotFoundException) {
                    asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.NOT_FOUND, cause)));
                } else {
                    asyncResponse.resume((Throwable)((Object)new RestException(cause)));
                }
                return null;
            });
        }
        catch (Exception ex2) {
            Transactions.resumeAsyncResponseExceptionally(asyncResponse, ex2);
        }
    }
}

