/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.AdaptiveRecvByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.ssl.SslContext;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.ScheduledFuture;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.ws.rs.core.Response;
import org.apache.bookkeeper.common.util.OrderedExecutor;
import org.apache.bookkeeper.common.util.OrderedScheduler;
import org.apache.bookkeeper.mledger.AsyncCallbacks;
import org.apache.bookkeeper.mledger.LedgerOffloader;
import org.apache.bookkeeper.mledger.ManagedLedger;
import org.apache.bookkeeper.mledger.ManagedLedgerConfig;
import org.apache.bookkeeper.mledger.ManagedLedgerException;
import org.apache.bookkeeper.mledger.ManagedLedgerFactory;
import org.apache.bookkeeper.mledger.intercept.ManagedLedgerInterceptor;
import org.apache.bookkeeper.mledger.util.Futures;
import org.apache.bookkeeper.mledger.util.SafeRun;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.bookie.rackawareness.IsolatedBookieEnsemblePlacementPolicy;
import org.apache.pulsar.broker.PulsarServerException;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.TransactionMetadataStoreService;
import org.apache.pulsar.broker.authentication.AuthenticationService;
import org.apache.pulsar.broker.authorization.AuthorizationService;
import org.apache.pulsar.broker.cache.BundlesQuotas;
import org.apache.pulsar.broker.delayed.DelayedDeliveryTrackerFactory;
import org.apache.pulsar.broker.delayed.DelayedDeliveryTrackerLoader;
import org.apache.pulsar.broker.intercept.BrokerInterceptor;
import org.apache.pulsar.broker.intercept.ManagedLedgerInterceptorImpl;
import org.apache.pulsar.broker.loadbalance.LoadManager;
import org.apache.pulsar.broker.resources.LocalPoliciesResources;
import org.apache.pulsar.broker.resources.NamespaceResources;
import org.apache.pulsar.broker.service.AbstractTopic;
import org.apache.pulsar.broker.service.BacklogQuotaManager;
import org.apache.pulsar.broker.service.BrokerServiceException;
import org.apache.pulsar.broker.service.Dispatcher;
import org.apache.pulsar.broker.service.DistributedIdGenerator;
import org.apache.pulsar.broker.service.GracefulExecutorServicesShutdown;
import org.apache.pulsar.broker.service.PublishRateLimiter;
import org.apache.pulsar.broker.service.PublishRateLimiterImpl;
import org.apache.pulsar.broker.service.PulsarChannelInitializer;
import org.apache.pulsar.broker.service.PulsarStats;
import org.apache.pulsar.broker.service.Replicator;
import org.apache.pulsar.broker.service.Topic;
import org.apache.pulsar.broker.service.TransportCnx;
import org.apache.pulsar.broker.service.nonpersistent.NonPersistentTopic;
import org.apache.pulsar.broker.service.persistent.DispatchRateLimiter;
import org.apache.pulsar.broker.service.persistent.PersistentDispatcherMultipleConsumers;
import org.apache.pulsar.broker.service.persistent.PersistentTopic;
import org.apache.pulsar.broker.service.persistent.SystemTopic;
import org.apache.pulsar.broker.service.plugin.EntryFilterProvider;
import org.apache.pulsar.broker.service.plugin.EntryFilterWithClassLoader;
import org.apache.pulsar.broker.stats.ClusterReplicationMetrics;
import org.apache.pulsar.broker.stats.prometheus.metrics.ObserverGauge;
import org.apache.pulsar.broker.stats.prometheus.metrics.Summary;
import org.apache.pulsar.broker.validator.BindAddressValidator;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminBuilder;
import org.apache.pulsar.client.api.ClientBuilder;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.impl.ClientBuilderImpl;
import org.apache.pulsar.client.impl.conf.ClientConfigurationData;
import org.apache.pulsar.common.allocator.PulsarByteBufAllocator;
import org.apache.pulsar.common.configuration.BindAddress;
import org.apache.pulsar.common.configuration.FieldContext;
import org.apache.pulsar.common.events.EventsTopicNames;
import org.apache.pulsar.common.intercept.AppendIndexMetadataInterceptor;
import org.apache.pulsar.common.intercept.BrokerEntryMetadataInterceptor;
import org.apache.pulsar.common.intercept.BrokerEntryMetadataUtils;
import org.apache.pulsar.common.intercept.ManagedLedgerPayloadProcessor;
import org.apache.pulsar.common.naming.NamespaceBundle;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.ServiceUnitId;
import org.apache.pulsar.common.naming.TopicDomain;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.partition.PartitionedTopicMetadata;
import org.apache.pulsar.common.policies.data.AutoSubscriptionCreationOverride;
import org.apache.pulsar.common.policies.data.AutoTopicCreationOverride;
import org.apache.pulsar.common.policies.data.BacklogQuota;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.pulsar.common.policies.data.LocalPolicies;
import org.apache.pulsar.common.policies.data.OffloadPoliciesImpl;
import org.apache.pulsar.common.policies.data.PersistencePolicies;
import org.apache.pulsar.common.policies.data.PersistentOfflineTopicStats;
import org.apache.pulsar.common.policies.data.Policies;
import org.apache.pulsar.common.policies.data.PublishRate;
import org.apache.pulsar.common.policies.data.RetentionPolicies;
import org.apache.pulsar.common.policies.data.TopicPolicies;
import org.apache.pulsar.common.policies.data.TopicType;
import org.apache.pulsar.common.policies.data.stats.TopicStatsImpl;
import org.apache.pulsar.common.protocol.schema.SchemaVersion;
import org.apache.pulsar.common.stats.Metrics;
import org.apache.pulsar.common.util.FieldParser;
import org.apache.pulsar.common.util.FutureUtil;
import org.apache.pulsar.common.util.RateLimiter;
import org.apache.pulsar.common.util.RestException;
import org.apache.pulsar.common.util.collections.ConcurrentOpenHashMap;
import org.apache.pulsar.common.util.collections.ConcurrentOpenHashSet;
import org.apache.pulsar.common.util.netty.ChannelFutures;
import org.apache.pulsar.common.util.netty.EventLoopUtil;
import org.apache.pulsar.common.util.netty.NettyFutureUtil;
import org.apache.pulsar.compaction.Compactor;
import org.apache.pulsar.metadata.api.MetadataStore;
import org.apache.pulsar.metadata.api.MetadataStoreException;
import org.apache.pulsar.metadata.api.Notification;
import org.apache.pulsar.metadata.api.NotificationType;
import org.apache.pulsar.policies.data.loadbalancer.NamespaceBundleStats;
import org.apache.pulsar.transaction.coordinator.TransactionCoordinatorID;
import org.apache.pulsar.transaction.coordinator.TransactionMetadataStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrokerService
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(BrokerService.class);
    private static final Duration FUTURE_DEADLINE_TIMEOUT_DURATION = Duration.ofSeconds(60L);
    private static final TimeoutException FUTURE_DEADLINE_TIMEOUT_EXCEPTION = FutureUtil.createTimeoutException((String)"Future didn't finish within deadline", BrokerService.class, (String)"futureWithDeadline(...)");
    private static final TimeoutException FAILED_TO_LOAD_TOPIC_TIMEOUT_EXCEPTION = FutureUtil.createTimeoutException((String)"Failed to load topic within timeout", BrokerService.class, (String)"futureWithDeadline(...)");
    private static final long GRACEFUL_SHUTDOWN_QUIET_PERIOD_MAX_MS = 5000L;
    private static final double GRACEFUL_SHUTDOWN_QUIET_PERIOD_RATIO_OF_TOTAL_TIMEOUT = 0.25;
    private static final double GRACEFUL_SHUTDOWN_TIMEOUT_RATIO_OF_TOTAL_TIMEOUT = 0.5;
    private final PulsarService pulsar;
    private final ManagedLedgerFactory managedLedgerFactory;
    private final ConcurrentOpenHashMap<String, CompletableFuture<Optional<Topic>>> topics;
    private final ConcurrentOpenHashMap<String, PulsarClient> replicationClients;
    private final ConcurrentOpenHashMap<String, PulsarAdmin> clusterAdmins;
    private final ConcurrentOpenHashMap<String, ConcurrentOpenHashMap<String, ConcurrentOpenHashMap<String, Topic>>> multiLayerTopicsMap;
    private final ConcurrentOpenHashMap<String, ConcurrentOpenHashSet<Integer>> owningTopics;
    private int numberOfNamespaceBundles = 0;
    private final EventLoopGroup acceptorGroup;
    private final EventLoopGroup workerGroup;
    private final OrderedExecutor topicOrderedExecutor;
    private final ConcurrentOpenHashMap<TopicName, PersistentOfflineTopicStats> offlineTopicStatCache;
    private static final ConcurrentOpenHashMap<String, ConfigField> dynamicConfigurationMap = BrokerService.prepareDynamicConfigurationMap();
    private final ConcurrentOpenHashMap<String, Consumer<?>> configRegisteredListeners;
    private final ConcurrentLinkedQueue<TopicLoadingContext> pendingTopicLoadingQueue;
    private AuthorizationService authorizationService = null;
    private final ScheduledExecutorService statsUpdater;
    private final ScheduledExecutorService backlogQuotaChecker;
    protected final AtomicReference<Semaphore> lookupRequestSemaphore;
    protected final AtomicReference<Semaphore> topicLoadRequestSemaphore;
    private final ObserverGauge pendingLookupRequests;
    private final ObserverGauge pendingTopicLoadRequests;
    private final ScheduledExecutorService inactivityMonitor;
    private final ScheduledExecutorService messageExpiryMonitor;
    private final ScheduledExecutorService compactionMonitor;
    private final ScheduledExecutorService consumedLedgersMonitor;
    protected final PublishRateLimiterMonitor topicPublishRateLimiterMonitor;
    protected final PublishRateLimiterMonitor brokerPublishRateLimiterMonitor;
    private ScheduledExecutorService deduplicationSnapshotMonitor;
    protected volatile PublishRateLimiter brokerPublishRateLimiter = PublishRateLimiter.DISABLED_RATE_LIMITER;
    protected volatile DispatchRateLimiter brokerDispatchRateLimiter = null;
    private DistributedIdGenerator producerNameGenerator;
    public static final String PRODUCER_NAME_GENERATOR_PATH = "/counters/producer-name";
    private final BacklogQuotaManager backlogQuotaManager;
    private final int keepAliveIntervalSeconds;
    private final PulsarStats pulsarStats;
    private final AuthenticationService authenticationService;
    public static final String MANAGED_LEDGER_PATH_ZNODE = "/managed-ledgers";
    private static final LongAdder totalUnackedMessages = new LongAdder();
    private final int maxUnackedMessages;
    public final int maxUnackedMsgsPerDispatcher;
    private static final AtomicBoolean blockedDispatcherOnHighUnackedMsgs = new AtomicBoolean(false);
    private final ConcurrentOpenHashSet<PersistentDispatcherMultipleConsumers> blockedDispatchers;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final DelayedDeliveryTrackerFactory delayedDeliveryTrackerFactory;
    private final ServerBootstrap defaultServerBootstrap;
    private final List<EventLoopGroup> protocolHandlersWorkerGroups = new ArrayList<EventLoopGroup>();
    private final BundlesQuotas bundlesQuotas;
    private PulsarChannelInitializer.Factory pulsarChannelInitFactory = PulsarChannelInitializer.DEFAULT_FACTORY;
    private final List<Channel> listenChannels = new ArrayList<Channel>(2);
    private Channel listenChannel;
    private Channel listenChannelTls;
    private boolean preciseTopicPublishRateLimitingEnable;
    private final LongAdder pausedConnections = new LongAdder();
    private BrokerInterceptor interceptor;
    private ImmutableMap<String, EntryFilterWithClassLoader> entryFilters;
    private Set<BrokerEntryMetadataInterceptor> brokerEntryMetadataInterceptors;
    private Set<ManagedLedgerPayloadProcessor> brokerEntryPayloadProcessors;

    public BrokerService(PulsarService pulsar, EventLoopGroup eventLoopGroup) throws Exception {
        this.pulsar = pulsar;
        this.preciseTopicPublishRateLimitingEnable = pulsar.getConfiguration().isPreciseTopicPublishRateLimiterEnable();
        this.managedLedgerFactory = pulsar.getManagedLedgerFactory();
        this.topics = ConcurrentOpenHashMap.newBuilder().build();
        this.replicationClients = ConcurrentOpenHashMap.newBuilder().build();
        this.clusterAdmins = ConcurrentOpenHashMap.newBuilder().build();
        this.keepAliveIntervalSeconds = pulsar.getConfiguration().getKeepAliveIntervalSeconds();
        this.configRegisteredListeners = ConcurrentOpenHashMap.newBuilder().build();
        this.pendingTopicLoadingQueue = Queues.newConcurrentLinkedQueue();
        this.multiLayerTopicsMap = ConcurrentOpenHashMap.newBuilder().build();
        this.owningTopics = ConcurrentOpenHashMap.newBuilder().build();
        this.pulsarStats = new PulsarStats(pulsar);
        this.offlineTopicStatCache = ConcurrentOpenHashMap.newBuilder().build();
        this.topicOrderedExecutor = OrderedScheduler.newSchedulerBuilder().numThreads(pulsar.getConfiguration().getNumWorkerThreadsForNonPersistentTopic()).name("broker-topic-workers").build();
        DefaultThreadFactory acceptorThreadFactory = new DefaultThreadFactory("pulsar-acceptor");
        this.acceptorGroup = EventLoopUtil.newEventLoopGroup((int)pulsar.getConfiguration().getNumAcceptorThreads(), (boolean)false, (ThreadFactory)acceptorThreadFactory);
        this.workerGroup = eventLoopGroup;
        this.statsUpdater = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new DefaultThreadFactory("pulsar-stats-updater"));
        this.authorizationService = new AuthorizationService(pulsar.getConfiguration(), this.pulsar().getPulsarResources());
        if (!pulsar.getConfiguration().getEntryFilterNames().isEmpty()) {
            this.entryFilters = EntryFilterProvider.createEntryFilters(pulsar.getConfiguration());
        }
        pulsar.getLocalMetadataStore().registerListener(this::handleMetadataChanges);
        pulsar.getConfigurationMetadataStore().registerListener(this::handleMetadataChanges);
        this.inactivityMonitor = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new DefaultThreadFactory("pulsar-inactivity-monitor"));
        this.messageExpiryMonitor = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new DefaultThreadFactory("pulsar-msg-expiry-monitor"));
        this.compactionMonitor = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new DefaultThreadFactory("pulsar-compaction-monitor"));
        this.consumedLedgersMonitor = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new DefaultThreadFactory("consumed-Ledgers-monitor"));
        this.topicPublishRateLimiterMonitor = new PublishRateLimiterMonitor("pulsar-topic-publish-rate-limiter-monitor");
        this.brokerPublishRateLimiterMonitor = new PublishRateLimiterMonitor("pulsar-broker-publish-rate-limiter-monitor");
        this.backlogQuotaManager = new BacklogQuotaManager(pulsar);
        this.backlogQuotaChecker = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new DefaultThreadFactory("pulsar-backlog-quota-checker"));
        this.authenticationService = new AuthenticationService(pulsar.getConfiguration());
        this.blockedDispatchers = ConcurrentOpenHashSet.newBuilder().build();
        this.updateConfigurationAndRegisterListeners();
        this.lookupRequestSemaphore = new AtomicReference<Semaphore>(new Semaphore(pulsar.getConfiguration().getMaxConcurrentLookupRequest(), false));
        this.topicLoadRequestSemaphore = new AtomicReference<Semaphore>(new Semaphore(pulsar.getConfiguration().getMaxConcurrentTopicLoadRequest(), false));
        if (pulsar.getConfiguration().getMaxUnackedMessagesPerBroker() > 0 && pulsar.getConfiguration().getMaxUnackedMessagesPerSubscriptionOnBrokerBlocked() > 0.0) {
            this.maxUnackedMessages = pulsar.getConfiguration().getMaxUnackedMessagesPerBroker();
            this.maxUnackedMsgsPerDispatcher = (int)((double)this.maxUnackedMessages * pulsar.getConfiguration().getMaxUnackedMessagesPerSubscriptionOnBrokerBlocked() / 100.0);
            log.info("Enabling per-broker unack-message limit {} and dispatcher-limit {} on blocked-broker", (Object)this.maxUnackedMessages, (Object)this.maxUnackedMsgsPerDispatcher);
            pulsar.getExecutor().scheduleAtFixedRate((Runnable)SafeRun.safeRun(this::checkUnAckMessageDispatching), 600L, 30L, TimeUnit.SECONDS);
        } else {
            this.maxUnackedMessages = 0;
            this.maxUnackedMsgsPerDispatcher = 0;
            log.info("Disabling per broker unack-msg blocking due invalid unAckMsgSubscriptionPercentageLimitOnBrokerBlocked {} ", (Object)pulsar.getConfiguration().getMaxUnackedMessagesPerSubscriptionOnBrokerBlocked());
        }
        this.delayedDeliveryTrackerFactory = DelayedDeliveryTrackerLoader.loadDelayedDeliveryTrackerFactory(pulsar.getConfiguration());
        this.defaultServerBootstrap = this.defaultServerBootstrap();
        this.pendingLookupRequests = ObserverGauge.build("pulsar_broker_lookup_pending_requests", "-").supplier(() -> pulsar.getConfig().getMaxConcurrentLookupRequest() - this.lookupRequestSemaphore.get().availablePermits()).register();
        this.pendingTopicLoadRequests = ObserverGauge.build("pulsar_broker_topic_load_pending_requests", "-").supplier(() -> pulsar.getConfig().getMaxConcurrentTopicLoadRequest() - this.topicLoadRequestSemaphore.get().availablePermits()).register();
        this.brokerEntryMetadataInterceptors = BrokerEntryMetadataUtils.loadBrokerEntryMetadataInterceptors((Set)pulsar.getConfiguration().getBrokerEntryMetadataInterceptors(), (ClassLoader)BrokerService.class.getClassLoader());
        this.brokerEntryPayloadProcessors = BrokerEntryMetadataUtils.loadInterceptors((Set)pulsar.getConfiguration().getBrokerEntryPayloadProcessors(), (ClassLoader)BrokerService.class.getClassLoader());
        this.bundlesQuotas = new BundlesQuotas((MetadataStore)pulsar.getLocalMetadataStore());
    }

    public void startProtocolHandlers(Map<String, Map<InetSocketAddress, ChannelInitializer<SocketChannel>>> protocolHandlers) {
        protocolHandlers.forEach((protocol, initializers) -> initializers.forEach((address, initializer) -> {
            try {
                this.startProtocolHandler((String)protocol, (SocketAddress)address, (ChannelInitializer<SocketChannel>)initializer);
            }
            catch (IOException e) {
                log.error("{}", (Object)e.getMessage(), (Object)e.getCause());
                throw new RuntimeException(e.getMessage(), e.getCause());
            }
        }));
    }

    private void startProtocolHandler(String protocol, SocketAddress address, ChannelInitializer<SocketChannel> initializer) throws IOException {
        ServerBootstrap bootstrap;
        ServiceConfiguration configuration = this.pulsar.getConfiguration();
        boolean useSeparateThreadPool = configuration.isUseSeparateThreadPoolForProtocolHandlers();
        if (useSeparateThreadPool) {
            bootstrap = new ServerBootstrap();
            bootstrap.childOption(ChannelOption.ALLOCATOR, (Object)PulsarByteBufAllocator.DEFAULT);
            bootstrap.childOption(ChannelOption.TCP_NODELAY, (Object)true);
            bootstrap.childOption(ChannelOption.RCVBUF_ALLOCATOR, (Object)new AdaptiveRecvByteBufAllocator(1024, 16384, 0x100000));
            EventLoopUtil.enableTriggeredMode((ServerBootstrap)bootstrap);
            DefaultThreadFactory defaultThreadFactory = new DefaultThreadFactory("pulsar-ph-" + protocol);
            EventLoopGroup dedicatedWorkerGroup = EventLoopUtil.newEventLoopGroup((int)configuration.getNumIOThreads(), (boolean)false, (ThreadFactory)defaultThreadFactory);
            bootstrap.channel(EventLoopUtil.getServerSocketChannelClass((EventLoopGroup)dedicatedWorkerGroup));
            this.protocolHandlersWorkerGroups.add(dedicatedWorkerGroup);
            bootstrap.group(this.acceptorGroup, dedicatedWorkerGroup);
        } else {
            bootstrap = this.defaultServerBootstrap.clone();
        }
        bootstrap.childHandler(initializer);
        try {
            bootstrap.bind(address).sync();
        }
        catch (Exception e) {
            throw new IOException("Failed to bind protocol `" + protocol + "` on " + address, e);
        }
        log.info("Successfully bind protocol `{}` on {}", (Object)protocol, (Object)address);
    }

    private ServerBootstrap defaultServerBootstrap() {
        ServerBootstrap bootstrap = new ServerBootstrap();
        bootstrap.childOption(ChannelOption.ALLOCATOR, (Object)PulsarByteBufAllocator.DEFAULT);
        bootstrap.group(this.acceptorGroup, this.workerGroup);
        bootstrap.childOption(ChannelOption.TCP_NODELAY, (Object)true);
        bootstrap.childOption(ChannelOption.RCVBUF_ALLOCATOR, (Object)new AdaptiveRecvByteBufAllocator(1024, 16384, 0x100000));
        bootstrap.channel(EventLoopUtil.getServerSocketChannelClass((EventLoopGroup)this.workerGroup));
        EventLoopUtil.enableTriggeredMode((ServerBootstrap)bootstrap);
        return bootstrap;
    }

    public void start() throws Exception {
        this.producerNameGenerator = new DistributedIdGenerator(this.pulsar.getCoordinationService(), PRODUCER_NAME_GENERATOR_PATH, this.pulsar.getConfiguration().getClusterName());
        ServiceConfiguration serviceConfig = this.pulsar.getConfiguration();
        List bindAddresses = BindAddressValidator.validateBindAddresses((ServiceConfiguration)serviceConfig, Arrays.asList("pulsar", "pulsar+ssl"));
        String internalListenerName = serviceConfig.getInternalListenerName();
        if (bindAddresses.size() == 0) {
            throw new IllegalArgumentException("At least one broker bind address must be configured");
        }
        for (BindAddress a : bindAddresses) {
            InetSocketAddress addr = new InetSocketAddress(a.getAddress().getHost(), a.getAddress().getPort());
            boolean isTls = "pulsar+ssl".equals(a.getAddress().getScheme());
            PulsarChannelInitializer.PulsarChannelOptions opts = PulsarChannelInitializer.PulsarChannelOptions.builder().enableTLS(isTls).listenerName(a.getListenerName()).build();
            ServerBootstrap b = this.defaultServerBootstrap.clone();
            b.childHandler((ChannelHandler)this.pulsarChannelInitFactory.newPulsarChannelInitializer(this.pulsar, opts));
            try {
                Channel ch = b.bind((SocketAddress)addr).sync().channel();
                this.listenChannels.add(ch);
                if (StringUtils.isBlank((CharSequence)a.getListenerName()) || StringUtils.equalsIgnoreCase((CharSequence)a.getListenerName(), (CharSequence)internalListenerName)) {
                    if (this.listenChannel == null && !isTls) {
                        this.listenChannel = ch;
                    }
                    if (this.listenChannelTls == null && isTls) {
                        this.listenChannelTls = ch;
                    }
                }
                log.info("Started Pulsar Broker service on {}, TLS: {}, listener: {}", new Object[]{ch.localAddress(), isTls ? SslContext.defaultServerProvider().toString() : "(none)", StringUtils.defaultString((String)a.getListenerName(), (String)"(none)")});
            }
            catch (Exception e) {
                throw new IOException("Failed to bind Pulsar broker on " + addr, e);
            }
        }
        this.startStatsUpdater(serviceConfig.getStatsUpdateInitialDelayInSecs(), serviceConfig.getStatsUpdateFrequencyInSecs());
        this.startInactivityMonitor();
        this.startMessageExpiryMonitor();
        this.startCompactionMonitor();
        this.startConsumedLedgersMonitor();
        this.startBacklogQuotaChecker();
        this.updateBrokerPublisherThrottlingMaxRate();
        this.updateBrokerDispatchThrottlingMaxRate();
        this.startCheckReplicationPolicies();
        this.startDeduplicationSnapshotMonitor();
    }

    protected void startStatsUpdater(int statsUpdateInitialDelayInSecs, int statsUpdateFrequencyInSecs) {
        this.statsUpdater.scheduleAtFixedRate((Runnable)SafeRun.safeRun(this::updateRates), statsUpdateInitialDelayInSecs, statsUpdateFrequencyInSecs, TimeUnit.SECONDS);
        this.updateRates();
    }

    protected void startDeduplicationSnapshotMonitor() {
        int interval = this.pulsar().getConfiguration().getBrokerDeduplicationSnapshotFrequencyInSeconds();
        if (interval > 0 && this.pulsar().getConfiguration().isBrokerDeduplicationEnabled()) {
            this.deduplicationSnapshotMonitor = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new DefaultThreadFactory("deduplication-snapshot-monitor"));
            this.deduplicationSnapshotMonitor.scheduleAtFixedRate((Runnable)SafeRun.safeRun(() -> this.forEachTopic(Topic::checkDeduplicationSnapshot)), interval, interval, TimeUnit.SECONDS);
        }
    }

    protected void startInactivityMonitor() {
        if (this.pulsar().getConfiguration().isBrokerDeleteInactiveTopicsEnabled()) {
            int interval = this.pulsar().getConfiguration().getBrokerDeleteInactiveTopicsFrequencySeconds();
            this.inactivityMonitor.scheduleAtFixedRate((Runnable)SafeRun.safeRun(() -> this.checkGC()), interval, interval, TimeUnit.SECONDS);
        }
        long duplicationCheckerIntervalInSeconds = TimeUnit.MINUTES.toSeconds(this.pulsar().getConfiguration().getBrokerDeduplicationProducerInactivityTimeoutMinutes()) / 3L;
        this.inactivityMonitor.scheduleAtFixedRate((Runnable)SafeRun.safeRun(this::checkMessageDeduplicationInfo), duplicationCheckerIntervalInSeconds, duplicationCheckerIntervalInSeconds, TimeUnit.SECONDS);
        if (this.pulsar().getConfiguration().getSubscriptionExpiryCheckIntervalInMinutes() > 0) {
            long subscriptionExpiryCheckIntervalInSeconds = TimeUnit.MINUTES.toSeconds(this.pulsar().getConfiguration().getSubscriptionExpiryCheckIntervalInMinutes());
            this.inactivityMonitor.scheduleAtFixedRate((Runnable)SafeRun.safeRun(this::checkInactiveSubscriptions), subscriptionExpiryCheckIntervalInSeconds, subscriptionExpiryCheckIntervalInSeconds, TimeUnit.SECONDS);
        }
    }

    protected void startMessageExpiryMonitor() {
        int interval = this.pulsar().getConfiguration().getMessageExpiryCheckIntervalInMinutes();
        this.messageExpiryMonitor.scheduleAtFixedRate((Runnable)SafeRun.safeRun(this::checkMessageExpiry), interval, interval, TimeUnit.MINUTES);
    }

    protected void startCheckReplicationPolicies() {
        int interval = this.pulsar.getConfig().getReplicationPolicyCheckDurationSeconds();
        if (interval > 0) {
            this.messageExpiryMonitor.scheduleAtFixedRate((Runnable)SafeRun.safeRun(this::checkReplicationPolicies), interval, interval, TimeUnit.SECONDS);
        }
    }

    protected void startCompactionMonitor() {
        int interval = this.pulsar().getConfiguration().getBrokerServiceCompactionMonitorIntervalInSeconds();
        if (interval > 0) {
            this.compactionMonitor.scheduleAtFixedRate((Runnable)SafeRun.safeRun(() -> this.checkCompaction()), interval, interval, TimeUnit.SECONDS);
        }
    }

    protected void startConsumedLedgersMonitor() {
        int interval = this.pulsar().getConfiguration().getRetentionCheckIntervalInSeconds();
        if (interval > 0) {
            this.consumedLedgersMonitor.scheduleAtFixedRate((Runnable)SafeRun.safeRun(this::checkConsumedLedgers), interval, interval, TimeUnit.SECONDS);
        }
    }

    protected void startBacklogQuotaChecker() {
        if (this.pulsar().getConfiguration().isBacklogQuotaCheckEnabled()) {
            int interval = this.pulsar().getConfiguration().getBacklogQuotaCheckIntervalInSeconds();
            log.info("Scheduling a thread to check backlog quota after [{}] seconds in background", (Object)interval);
            this.backlogQuotaChecker.scheduleAtFixedRate((Runnable)SafeRun.safeRun(this::monitorBacklogQuota), interval, interval, TimeUnit.SECONDS);
        } else {
            log.info("Backlog quota check monitoring is disabled");
        }
    }

    public void setupTopicPublishRateLimiterMonitor() {
        long topicTickTimeMs = this.pulsar().getConfiguration().getTopicPublisherThrottlingTickTimeMillis();
        if (topicTickTimeMs > 0L) {
            this.topicPublishRateLimiterMonitor.startOrUpdate(topicTickTimeMs, this::checkTopicPublishThrottlingRate, this::refreshTopicPublishRate);
        } else {
            this.topicPublishRateLimiterMonitor.stop();
        }
    }

    public void setupBrokerPublishRateLimiterMonitor() {
        long brokerTickTimeMs = this.pulsar().getConfiguration().getBrokerPublisherThrottlingTickTimeMillis();
        if (brokerTickTimeMs > 0L) {
            this.brokerPublishRateLimiterMonitor.startOrUpdate(brokerTickTimeMs, this::checkBrokerPublishThrottlingRate, this::refreshBrokerPublishRate);
        } else {
            this.brokerPublishRateLimiterMonitor.stop();
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.closeAsync().get();
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new PulsarServerException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public CompletableFuture<Void> closeAndRemoveReplicationClient(String clusterName) {
        ArrayList futures = new ArrayList((int)this.topics.size());
        this.topics.forEach((__, future) -> {
            CompletableFuture f = new CompletableFuture();
            futures.add(f);
            future.whenComplete((ot, ex) -> {
                Replicator r;
                if (ot.isPresent() && (r = (Replicator)((Topic)ot.get()).getReplicators().get((Object)clusterName)) != null && r.isConnected()) {
                    r.disconnect(false).whenComplete((v, e) -> f.complete(null));
                    return;
                }
                f.complete(null);
            });
        });
        return FutureUtil.waitForAll(futures).thenCompose(__ -> {
            PulsarClient client = (PulsarClient)this.replicationClients.remove((Object)clusterName);
            if (client == null) {
                return CompletableFuture.completedFuture(null);
            }
            return client.closeAsync();
        });
    }

    public CompletableFuture<Void> closeAsync() {
        try {
            log.info("Shutting down Pulsar Broker service");
            this.unloadNamespaceBundlesGracefully();
            this.replicationClients.forEach((cluster, client) -> {
                try {
                    client.shutdown();
                }
                catch (Exception e) {
                    log.warn("Error shutting down repl client for cluster {}", cluster, (Object)e);
                }
            });
            this.clusterAdmins.forEach((cluster, admin) -> {
                try {
                    admin.close();
                }
                catch (Exception e) {
                    log.warn("Error shutting down repl admin for cluster {}", cluster, (Object)e);
                }
            });
            if (this.entryFilters != null) {
                this.entryFilters.forEach((name, filter) -> {
                    try {
                        filter.close();
                    }
                    catch (Exception e) {
                        log.warn("Error shutting down entry filter {}", name, (Object)e);
                    }
                });
            }
            CompletableFuture cancellableDownstreamFutureReference = new CompletableFuture();
            log.info("Event loops shutting down gracefully...");
            ArrayList<CompletableFuture<Void>> shutdownEventLoops = new ArrayList<CompletableFuture<Void>>();
            shutdownEventLoops.add(this.shutdownEventLoopGracefully(this.acceptorGroup));
            shutdownEventLoops.add(this.shutdownEventLoopGracefully(this.workerGroup));
            for (EventLoopGroup group : this.protocolHandlersWorkerGroups) {
                shutdownEventLoops.add(this.shutdownEventLoopGracefully(group));
            }
            CompletionStage shutdownFuture = ((CompletableFuture)CompletableFuture.allOf(shutdownEventLoops.toArray(new CompletableFuture[0])).handle((v, t) -> {
                if (t != null) {
                    log.warn("Error shutting down event loops gracefully", t);
                } else {
                    log.info("Event loops shutdown completed.");
                }
                return null;
            })).thenCompose(__ -> {
                log.info("Continuing to second phase in shutdown.");
                ArrayList<CompletableFuture<Void>> asyncCloseFutures = new ArrayList<CompletableFuture<Void>>();
                this.listenChannels.forEach(ch -> {
                    if (ch.isOpen()) {
                        asyncCloseFutures.add(this.closeChannel((Channel)ch));
                    }
                });
                if (this.interceptor != null) {
                    this.interceptor.close();
                    this.interceptor = null;
                }
                try {
                    this.authenticationService.close();
                }
                catch (IOException e) {
                    log.warn("Error in closing authenticationService", (Throwable)e);
                }
                this.pulsarStats.close();
                try {
                    this.delayedDeliveryTrackerFactory.close();
                }
                catch (IOException e) {
                    log.warn("Error in closing delayedDeliveryTrackerFactory", (Throwable)e);
                }
                asyncCloseFutures.add(GracefulExecutorServicesShutdown.initiate().timeout(Duration.ofMillis((long)(0.5 * (double)this.pulsar.getConfiguration().getBrokerShutdownTimeoutMs()))).shutdown(new ExecutorService[]{this.statsUpdater, this.inactivityMonitor, this.messageExpiryMonitor, this.compactionMonitor, this.consumedLedgersMonitor, this.backlogQuotaChecker, this.topicOrderedExecutor, this.topicPublishRateLimiterMonitor.scheduler, this.brokerPublishRateLimiterMonitor.scheduler, this.deduplicationSnapshotMonitor}).handle());
                CompletableFuture combined = FutureUtil.waitForAllAndSupportCancel(asyncCloseFutures);
                cancellableDownstreamFutureReference.complete(combined);
                combined.handle((v, t) -> {
                    if (t == null) {
                        log.info("Broker service completely shut down");
                    } else if (t instanceof CancellationException) {
                        log.warn("Broker service didn't complete gracefully. Terminating Broker service.");
                    } else {
                        log.warn("Broker service shut down completed with exception", t);
                    }
                    return null;
                });
                return combined;
            });
            FutureUtil.whenCancelledOrTimedOut((CompletableFuture)shutdownFuture, () -> cancellableDownstreamFutureReference.thenAccept(future -> future.cancel(false)));
            return shutdownFuture;
        }
        catch (Exception e) {
            return FutureUtil.failedFuture((Throwable)e);
        }
    }

    CompletableFuture<Void> shutdownEventLoopGracefully(EventLoopGroup eventLoopGroup) {
        long brokerShutdownTimeoutMs = this.pulsar.getConfiguration().getBrokerShutdownTimeoutMs();
        long quietPeriod = Math.min((long)(0.25 * (double)brokerShutdownTimeoutMs), 5000L);
        long timeout = (long)(0.5 * (double)brokerShutdownTimeoutMs);
        return NettyFutureUtil.toCompletableFutureVoid((Future)eventLoopGroup.shutdownGracefully(quietPeriod, timeout, TimeUnit.MILLISECONDS));
    }

    private CompletableFuture<Void> closeChannel(Channel channel) {
        return ChannelFutures.toCompletableFuture((ChannelFuture)channel.close()).handle((c, t) -> {
            if (t != null && !(t instanceof RejectedExecutionException)) {
                log.warn("Cannot close channel {}", (Object)channel, t);
            }
            return null;
        });
    }

    public void unloadNamespaceBundlesGracefully() {
        this.unloadNamespaceBundlesGracefully(0, true);
    }

    public void unloadNamespaceBundlesGracefully(int maxConcurrentUnload, boolean closeWithoutWaitingClientDisconnect) {
        try {
            log.info("Unloading namespace-bundles...");
            if (this.pulsar.getLoadManager() != null && this.pulsar.getLoadManager().get() != null) {
                try {
                    this.pulsar.getLoadManager().get().disableBroker();
                }
                catch (PulsarServerException.NotFoundException ne) {
                    log.warn("Broker load-manager znode doesn't exist ", (Throwable)ne);
                }
            }
            long closeTopicsStartTime = System.nanoTime();
            Set<NamespaceBundle> serviceUnits = this.pulsar.getNamespaceService().getOwnedServiceUnits();
            if (serviceUnits != null) {
                try (RateLimiter rateLimiter = maxConcurrentUnload > 0 ? RateLimiter.builder().scheduledExecutorService(this.pulsar.getExecutor()).rateTime(1L).timeUnit(TimeUnit.SECONDS).permits((long)maxConcurrentUnload).build() : null;){
                    serviceUnits.forEach(su -> {
                        if (su != null) {
                            try {
                                if (rateLimiter != null) {
                                    rateLimiter.acquire(1L);
                                }
                                this.pulsar.getNamespaceService().unloadNamespaceBundle((NamespaceBundle)su, this.pulsar.getConfiguration().getNamespaceBundleUnloadingTimeoutMs(), TimeUnit.MILLISECONDS, closeWithoutWaitingClientDisconnect).get();
                            }
                            catch (Exception e) {
                                log.warn("Failed to unload namespace bundle {}", su, (Object)e);
                            }
                        }
                    });
                }
            }
            double closeTopicsTimeSeconds = (double)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - closeTopicsStartTime) / 1000.0;
            log.info("Unloading {} namespace-bundles completed in {} seconds", (Object)serviceUnits.size(), (Object)closeTopicsTimeSeconds);
        }
        catch (Exception e) {
            log.error("Failed to disable broker from loadbalancer list {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public CompletableFuture<Optional<Topic>> getTopicIfExists(String topic) {
        return this.getTopic(topic, false);
    }

    public CompletableFuture<Topic> getOrCreateTopic(String topic) {
        return this.getTopic(topic, this.isAllowAutoTopicCreation(topic)).thenApply(Optional::get);
    }

    public CompletableFuture<Optional<Topic>> getTopic(String topic, boolean createIfMissing) {
        return this.getTopic(topic, createIfMissing, null);
    }

    public CompletableFuture<Optional<Topic>> getTopic(String topic, boolean createIfMissing, Map<String, String> properties) {
        try {
            boolean isPersistentTopic;
            CompletableFuture topicFuture = (CompletableFuture)this.topics.get((Object)topic);
            if (topicFuture != null) {
                if (topicFuture.isCompletedExceptionally() || topicFuture.isDone() && !topicFuture.getNow(Optional.empty()).isPresent()) {
                    this.topics.remove((Object)topic, (Object)topicFuture);
                } else {
                    if (createIfMissing) {
                        if (topicFuture.isDone() && topicFuture.getNow(Optional.empty()).isPresent()) {
                            return topicFuture;
                        }
                        return topicFuture.thenCompose(value -> {
                            if (!value.isPresent()) {
                                return this.getTopic(topic, createIfMissing, properties);
                            }
                            return CompletableFuture.completedFuture(value);
                        });
                    }
                    return topicFuture;
                }
            }
            if (isPersistentTopic = TopicName.get((String)topic).getDomain().equals((Object)TopicDomain.persistent)) {
                return (CompletableFuture)this.topics.computeIfAbsent((Object)topic, topicName -> this.loadOrCreatePersistentTopic((String)topicName, createIfMissing, properties));
            }
            return (CompletableFuture)this.topics.computeIfAbsent((Object)topic, name -> {
                TopicName topicName = TopicName.get((String)name);
                if (topicName.isPartitioned()) {
                    TopicName partitionedTopicName = TopicName.get((String)topicName.getPartitionedTopicName());
                    return this.fetchPartitionedTopicMetadataAsync(partitionedTopicName).thenCompose(metadata -> {
                        if (topicName.getPartitionIndex() < metadata.partitions) {
                            return this.createNonPersistentTopic((String)name);
                        }
                        return CompletableFuture.completedFuture(Optional.empty());
                    });
                }
                if (createIfMissing) {
                    return this.createNonPersistentTopic((String)name);
                }
                return CompletableFuture.completedFuture(Optional.empty());
            });
        }
        catch (IllegalArgumentException e) {
            log.warn("[{}] Illegalargument exception when loading topic", (Object)topic, (Object)e);
            return FutureUtil.failedFuture((Throwable)e);
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof BrokerServiceException.ServiceUnitNotReadyException) {
                log.warn("[{}] Service unit is not ready when loading the topic", (Object)topic);
            } else {
                log.warn("[{}] Unexpected exception when loading topic: {}", new Object[]{topic, e.getMessage(), e});
            }
            return FutureUtil.failedFuture((Throwable)cause);
        }
    }

    public CompletableFuture<SchemaVersion> deleteSchemaStorage(String topic) {
        Optional<Topic> optTopic = this.getTopicReference(topic);
        if (optTopic.isPresent()) {
            return optTopic.get().deleteSchema();
        }
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<Void> deleteTopic(String topic, boolean forceDelete) {
        return this.deleteTopic(topic, forceDelete, false);
    }

    public CompletableFuture<Void> deleteTopic(String topic, boolean forceDelete, boolean deleteSchema) {
        TopicName tn;
        Optional<Topic> optTopic = this.getTopicReference(topic);
        if (optTopic.isPresent()) {
            Topic t = optTopic.get();
            if (forceDelete) {
                if (deleteSchema) {
                    return t.deleteSchema().thenCompose(schemaVersion -> {
                        log.info("Successfully delete topic {}'s schema of version {}", (Object)t.getName(), schemaVersion);
                        return t.deleteForcefully();
                    });
                }
                return t.deleteForcefully();
            }
            if (t.isReplicated()) {
                List clusters = t.getReplicators().keys();
                log.error("Delete forbidden topic {} is replicated on clusters {}", (Object)topic, (Object)clusters);
                return FutureUtil.failedFuture((Throwable)new IllegalStateException("Delete forbidden topic is replicated on clusters " + clusters));
            }
            if (deleteSchema) {
                return t.deleteSchema().thenCompose(schemaVersion -> {
                    log.info("Successfully delete topic {}'s schema of version {}", (Object)t.getName(), schemaVersion);
                    return t.delete();
                });
            }
            return t.delete();
        }
        if (log.isDebugEnabled()) {
            log.debug("Topic {} is not loaded, try to delete from metadata", (Object)topic);
        }
        if (!(tn = TopicName.get((String)topic)).isPersistent()) {
            return CompletableFuture.completedFuture(null);
        }
        final CompletableFuture<Void> future = new CompletableFuture<Void>();
        CompletableFuture<Void> deleteTopicAuthenticationFuture = new CompletableFuture<Void>();
        this.deleteTopicAuthenticationWithRetry(topic, deleteTopicAuthenticationFuture, 5);
        deleteTopicAuthenticationFuture.whenComplete((v, ex) -> {
            if (ex != null) {
                future.completeExceptionally((Throwable)ex);
                return;
            }
            this.managedLedgerFactory.asyncDelete(tn.getPersistenceNamingEncoding(), new AsyncCallbacks.DeleteLedgerCallback(){

                public void deleteLedgerComplete(Object ctx) {
                    future.complete(null);
                }

                public void deleteLedgerFailed(ManagedLedgerException exception, Object ctx) {
                    future.completeExceptionally(exception);
                }
            }, null);
        });
        return future;
    }

    public void deleteTopicAuthenticationWithRetry(String topic, CompletableFuture<Void> future, int count) {
        if (count == 0) {
            log.error("The number of retries has exhausted for topic {}", (Object)topic);
            future.completeExceptionally(new MetadataStoreException("The number of retries has exhausted"));
            return;
        }
        NamespaceName namespaceName = TopicName.get((String)topic).getNamespaceObject();
        ((CompletableFuture)this.pulsar.getPulsarResources().getNamespaceResources().getPoliciesAsync(namespaceName).thenAccept(optPolicies -> {
            if (!optPolicies.isPresent() || !((Policies)optPolicies.get()).auth_policies.getTopicAuthentication().containsKey(topic)) {
                if (log.isDebugEnabled()) {
                    log.debug("Authentication policies not found for topic {}", (Object)topic);
                }
                future.complete(null);
                return;
            }
            ((CompletableFuture)this.pulsar.getPulsarResources().getNamespaceResources().setPoliciesAsync(TopicName.get((String)topic).getNamespaceObject(), p -> {
                p.auth_policies.getTopicAuthentication().remove(topic);
                return p;
            }).thenAccept(v -> {
                log.info("Successfully delete authentication policies for topic {}", (Object)topic);
                future.complete(null);
            })).exceptionally(ex1 -> {
                if (ex1.getCause() instanceof MetadataStoreException.BadVersionException) {
                    log.warn("Failed to delete authentication policies because of bad version. Retry to delete authentication policies for topic {}", (Object)topic);
                    this.deleteTopicAuthenticationWithRetry(topic, future, count - 1);
                } else {
                    log.error("Failed to delete authentication policies for topic {}", (Object)topic, ex1);
                    future.completeExceptionally((Throwable)ex1);
                }
                return null;
            });
        })).exceptionally(ex -> {
            log.error("Failed to get policies for topic {}", (Object)topic, ex);
            future.completeExceptionally((Throwable)ex);
            return null;
        });
    }

    private CompletableFuture<Optional<Topic>> createNonPersistentTopic(String topic) {
        CompletableFuture<Optional<Topic>> topicFuture = new CompletableFuture<Optional<Topic>>();
        if (!this.pulsar.getConfiguration().isEnableNonPersistentTopics()) {
            if (log.isDebugEnabled()) {
                log.debug("Broker is unable to load non-persistent topic {}", (Object)topic);
            }
            return FutureUtil.failedFuture((Throwable)new BrokerServiceException.NotAllowedException("Broker is not unable to load non-persistent topic"));
        }
        long topicCreateTimeMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
        NonPersistentTopic nonPersistentTopic = new NonPersistentTopic(topic, this);
        CompletableFuture<Void> isOwner = this.checkTopicNsOwnership(topic);
        ((CompletableFuture)isOwner.thenRun(() -> ((CompletableFuture)((CompletableFuture)nonPersistentTopic.initialize().thenCompose(__ -> nonPersistentTopic.checkReplication())).thenRun(() -> {
            log.info("Created topic {}", (Object)nonPersistentTopic);
            long topicLoadLatencyMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime()) - topicCreateTimeMs;
            this.pulsarStats.recordTopicLoadTimeValue(topic, topicLoadLatencyMs);
            this.addTopicToStatsMaps(TopicName.get((String)topic), nonPersistentTopic);
            topicFuture.complete(Optional.of(nonPersistentTopic));
        })).exceptionally(ex -> {
            log.warn("Replication check failed. Removing topic from topics list {}, {}", (Object)topic, (Object)ex.getCause());
            nonPersistentTopic.stopReplProducers().whenComplete((v, exception) -> {
                this.pulsar.getExecutor().execute(() -> this.topics.remove((Object)topic, (Object)topicFuture));
                topicFuture.completeExceptionally((Throwable)ex);
            });
            return null;
        }))).exceptionally(e -> {
            log.warn("CheckTopicNsOwnership fail when createNonPersistentTopic! {}", (Object)topic, (Object)e.getCause());
            topicFuture.complete(Optional.of(nonPersistentTopic));
            this.pulsar.getExecutor().execute(() -> this.topics.remove((Object)topic, (Object)topicFuture));
            return null;
        });
        return topicFuture;
    }

    private <T> CompletableFuture<T> futureWithDeadline() {
        return FutureUtil.createFutureWithTimeout((Duration)FUTURE_DEADLINE_TIMEOUT_DURATION, (ScheduledExecutorService)this.executor(), () -> FUTURE_DEADLINE_TIMEOUT_EXCEPTION);
    }

    public PulsarClient getReplicationClient(String cluster, Optional<ClusterData> clusterDataOp) {
        PulsarClient client = (PulsarClient)this.replicationClients.get((Object)cluster);
        if (client != null) {
            return client;
        }
        return (PulsarClient)this.replicationClients.computeIfAbsent((Object)cluster, key -> {
            try {
                String serviceUrlTls;
                ClusterData data = (ClusterData)clusterDataOp.orElseThrow(() -> new MetadataStoreException.NotFoundException(cluster));
                ClientBuilder clientBuilder = PulsarClient.builder().enableTcpNoDelay(false).connectionsPerBroker(this.pulsar.getConfiguration().getReplicationConnectionsPerBroker()).statsInterval(0L, TimeUnit.SECONDS);
                if (data.getAuthenticationPlugin() != null && data.getAuthenticationParameters() != null) {
                    clientBuilder.authentication(data.getAuthenticationPlugin(), data.getAuthenticationParameters());
                } else if (this.pulsar.getConfiguration().isAuthenticationEnabled()) {
                    clientBuilder.authentication(this.pulsar.getConfiguration().getBrokerClientAuthenticationPlugin(), this.pulsar.getConfiguration().getBrokerClientAuthenticationParameters());
                }
                String string = serviceUrlTls = StringUtils.isNotBlank((CharSequence)data.getBrokerServiceUrlTls()) ? data.getBrokerServiceUrlTls() : data.getServiceUrlTls();
                if (data.isBrokerClientTlsEnabled()) {
                    this.configTlsSettings(clientBuilder, serviceUrlTls, data.isBrokerClientTlsEnabledWithKeyStore(), data.isTlsAllowInsecureConnection(), data.getBrokerClientTlsTrustStoreType(), data.getBrokerClientTlsTrustStore(), data.getBrokerClientTlsTrustStorePassword(), data.getBrokerClientTrustCertsFilePath());
                } else if (this.pulsar.getConfiguration().isBrokerClientTlsEnabled()) {
                    this.configTlsSettings(clientBuilder, serviceUrlTls, this.pulsar.getConfiguration().isBrokerClientTlsEnabledWithKeyStore(), this.pulsar.getConfiguration().isTlsAllowInsecureConnection(), this.pulsar.getConfiguration().getBrokerClientTlsTrustStoreType(), this.pulsar.getConfiguration().getBrokerClientTlsTrustStore(), this.pulsar.getConfiguration().getBrokerClientTlsTrustStorePassword(), this.pulsar.getConfiguration().getBrokerClientTrustCertsFilePath());
                } else {
                    clientBuilder.serviceUrl(StringUtils.isNotBlank((CharSequence)data.getBrokerServiceUrl()) ? data.getBrokerServiceUrl() : data.getServiceUrl());
                }
                if (data.getProxyProtocol() != null && StringUtils.isNotBlank((CharSequence)data.getProxyServiceUrl())) {
                    clientBuilder.proxyServiceUrl(data.getProxyServiceUrl(), data.getProxyProtocol());
                    log.info("Configuring proxy-url {} with protocol {}", (Object)data.getProxyServiceUrl(), (Object)data.getProxyProtocol());
                }
                if (StringUtils.isNotBlank((CharSequence)data.getListenerName())) {
                    clientBuilder.listenerName(data.getListenerName());
                    log.info("Configuring listenerName {}", (Object)data.getListenerName());
                }
                ClientConfigurationData conf = ((ClientBuilderImpl)clientBuilder).getClientConfigurationData();
                return this.pulsar.createClientImpl(conf);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    private void configTlsSettings(ClientBuilder clientBuilder, String serviceUrl, boolean brokerClientTlsEnabledWithKeyStore, boolean isTlsAllowInsecureConnection, String brokerClientTlsTrustStoreType, String brokerClientTlsTrustStore, String brokerClientTlsTrustStorePassword, String brokerClientTrustCertsFilePath) {
        clientBuilder.serviceUrl(serviceUrl).enableTls(true).allowTlsInsecureConnection(isTlsAllowInsecureConnection);
        if (brokerClientTlsEnabledWithKeyStore) {
            clientBuilder.useKeyStoreTls(true).tlsTrustStoreType(brokerClientTlsTrustStoreType).tlsTrustStorePath(brokerClientTlsTrustStore).tlsTrustStorePassword(brokerClientTlsTrustStorePassword);
        } else {
            clientBuilder.tlsTrustCertsFilePath(brokerClientTrustCertsFilePath);
        }
    }

    public PulsarAdmin getClusterPulsarAdmin(String cluster, Optional<ClusterData> clusterDataOp) {
        PulsarAdmin admin = (PulsarAdmin)this.clusterAdmins.get((Object)cluster);
        if (admin != null) {
            return admin;
        }
        return (PulsarAdmin)this.clusterAdmins.computeIfAbsent((Object)cluster, key -> {
            try {
                ClusterData data = (ClusterData)clusterDataOp.orElseThrow(() -> new MetadataStoreException.NotFoundException(cluster));
                ServiceConfiguration conf = this.pulsar.getConfig();
                boolean isTlsUrl = conf.isBrokerClientTlsEnabled() && StringUtils.isNotBlank((CharSequence)data.getServiceUrlTls());
                String adminApiUrl = isTlsUrl ? data.getServiceUrlTls() : data.getServiceUrl();
                PulsarAdminBuilder builder = PulsarAdmin.builder().serviceHttpUrl(adminApiUrl).authentication(conf.getBrokerClientAuthenticationPlugin(), conf.getBrokerClientAuthenticationParameters());
                if (isTlsUrl) {
                    builder.allowTlsInsecureConnection(conf.isTlsAllowInsecureConnection());
                    if (conf.isBrokerClientTlsEnabledWithKeyStore()) {
                        builder.useKeyStoreTls(true).tlsTrustStoreType(conf.getBrokerClientTlsTrustStoreType()).tlsTrustStorePath(conf.getBrokerClientTlsTrustStore()).tlsTrustStorePassword(conf.getBrokerClientTlsTrustStorePassword());
                    } else {
                        builder.tlsTrustCertsFilePath(conf.getBrokerClientTrustCertsFilePath());
                    }
                }
                builder.readTimeout(conf.getMetadataStoreOperationTimeoutSeconds(), TimeUnit.SECONDS);
                PulsarAdmin adminClient = builder.build();
                log.info("created admin with url {} ", (Object)adminApiUrl);
                return adminClient;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    protected CompletableFuture<Optional<Topic>> loadOrCreatePersistentTopic(String topic, boolean createIfMissing, Map<String, String> properties) throws RuntimeException {
        CompletableFuture topicFuture = FutureUtil.createFutureWithTimeout((Duration)Duration.ofSeconds(this.pulsar.getConfiguration().getTopicLoadTimeoutSeconds()), (ScheduledExecutorService)this.executor(), () -> FAILED_TO_LOAD_TOPIC_TIMEOUT_EXCEPTION);
        if (!this.pulsar.getConfiguration().isEnablePersistentTopics()) {
            if (log.isDebugEnabled()) {
                log.debug("Broker is unable to load persistent topic {}", (Object)topic);
            }
            topicFuture.completeExceptionally(new BrokerServiceException.NotAllowedException("Broker is not unable to load persistent topic"));
            return topicFuture;
        }
        ((CompletableFuture)this.checkTopicNsOwnership(topic).thenRun(() -> {
            Semaphore topicLoadSemaphore = this.topicLoadRequestSemaphore.get();
            if (topicLoadSemaphore.tryAcquire()) {
                this.createPersistentTopic(topic, createIfMissing, topicFuture, properties);
                topicFuture.handle((persistentTopic, ex) -> {
                    topicLoadSemaphore.release();
                    this.createPendingLoadTopic();
                    return null;
                });
            } else {
                this.pendingTopicLoadingQueue.add(new TopicLoadingContext(topic, topicFuture, properties));
                if (log.isDebugEnabled()) {
                    log.debug("topic-loading for {} added into pending queue", (Object)topic);
                }
            }
        })).exceptionally(ex -> {
            topicFuture.completeExceptionally(ex.getCause());
            return null;
        });
        return topicFuture;
    }

    private void createPersistentTopic(final String topic, final boolean createIfMissing, final CompletableFuture<Optional<Topic>> topicFuture, Map<String, String> properties) {
        final long topicCreateTimeMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
        final TopicName topicName = TopicName.get((String)topic);
        if (!this.pulsar.getNamespaceService().isServiceUnitActive(topicName)) {
            String msg = String.format("Namespace is being unloaded, cannot add topic %s", topic);
            log.warn(msg);
            this.pulsar.getExecutor().execute(() -> this.topics.remove((Object)topic, (Object)topicFuture));
            topicFuture.completeExceptionally(new BrokerServiceException.ServiceUnitNotReadyException(msg));
            return;
        }
        if (PulsarService.isTransactionSystemTopic(topicName)) {
            String msg = String.format("Can not create transaction system topic %s", topic);
            log.warn(msg);
            this.pulsar.getExecutor().execute(() -> this.topics.remove((Object)topic, (Object)topicFuture));
            topicFuture.completeExceptionally(new BrokerServiceException.NotAllowedException(msg));
            return;
        }
        CompletableFuture<Object> maxTopicsCheck = createIfMissing ? this.checkMaxTopicsPerNamespace(topicName, 1) : CompletableFuture.completedFuture(null);
        ((CompletableFuture)((CompletableFuture)maxTopicsCheck.thenCompose(__ -> this.getManagedLedgerConfig(topicName))).thenAccept(managedLedgerConfig -> {
            if (this.isBrokerEntryMetadataEnabled() || this.isBrokerPayloadProcessorEnabled()) {
                HashSet<BrokerEntryMetadataInterceptor> interceptors = new HashSet<BrokerEntryMetadataInterceptor>();
                for (BrokerEntryMetadataInterceptor interceptor : this.brokerEntryMetadataInterceptors) {
                    if (interceptor instanceof AppendIndexMetadataInterceptor) {
                        interceptors.add((BrokerEntryMetadataInterceptor)new AppendIndexMetadataInterceptor());
                        continue;
                    }
                    interceptors.add(interceptor);
                }
                managedLedgerConfig.setManagedLedgerInterceptor((ManagedLedgerInterceptor)new ManagedLedgerInterceptorImpl(interceptors, this.brokerEntryPayloadProcessors));
            }
            managedLedgerConfig.setCreateIfMissing(createIfMissing);
            managedLedgerConfig.setProperties(properties);
            this.managedLedgerFactory.asyncOpen(topicName.getPersistenceNamingEncoding(), managedLedgerConfig, new AsyncCallbacks.OpenLedgerCallback(){

                public void openLedgerComplete(ManagedLedger ledger, Object ctx) {
                    try {
                        PersistentTopic persistentTopic = BrokerService.this.isSystemTopic(topic) ? new SystemTopic(topic, ledger, BrokerService.this) : new PersistentTopic(topic, ledger, BrokerService.this);
                        ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)persistentTopic.initialize().thenCompose(__ -> persistentTopic.preCreateSubscriptionForCompactionIfNeeded())).thenCompose(__ -> persistentTopic.checkReplication())).thenCompose(v -> persistentTopic.checkDeduplicationStatus())).thenRun(() -> {
                            log.info("Created topic {} - dedup is {}", (Object)topic, (Object)(persistentTopic.isDeduplicationEnabled() ? "enabled" : "disabled"));
                            long topicLoadLatencyMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime()) - topicCreateTimeMs;
                            BrokerService.this.pulsarStats.recordTopicLoadTimeValue(topic, topicLoadLatencyMs);
                            if (topicFuture.isCompletedExceptionally()) {
                                log.warn("{} future is already completed with failure {}, closing the topic", (Object)topic, (Object)FutureUtil.getException((CompletableFuture)topicFuture));
                                persistentTopic.stopReplProducers().whenComplete((v, exception) -> BrokerService.this.topics.remove((Object)topic, (Object)topicFuture));
                            } else {
                                BrokerService.this.addTopicToStatsMaps(topicName, persistentTopic);
                                topicFuture.complete(Optional.of(persistentTopic));
                            }
                        })).exceptionally(ex -> {
                            log.warn("Replication or dedup check failed. Removing topic from topics list {}, {}", (Object)topic, ex);
                            persistentTopic.stopReplProducers().whenComplete((v, exception) -> {
                                BrokerService.this.topics.remove((Object)topic, (Object)topicFuture);
                                topicFuture.completeExceptionally((Throwable)ex);
                            });
                            return null;
                        });
                    }
                    catch (PulsarServerException e) {
                        log.warn("Failed to create topic {}-{}", (Object)topic, (Object)e.getMessage());
                        BrokerService.this.pulsar.getExecutor().execute(() -> BrokerService.this.topics.remove((Object)topic, (Object)topicFuture));
                        topicFuture.completeExceptionally(e);
                    }
                }

                public void openLedgerFailed(ManagedLedgerException exception, Object ctx) {
                    if (!createIfMissing && exception instanceof ManagedLedgerException.ManagedLedgerNotFoundException) {
                        topicFuture.complete(Optional.empty());
                    } else {
                        log.warn("Failed to create topic {}", (Object)topic, (Object)exception);
                        BrokerService.this.pulsar.getExecutor().execute(() -> BrokerService.this.topics.remove((Object)topic, (Object)topicFuture));
                        topicFuture.completeExceptionally(new BrokerServiceException.PersistenceException(exception));
                    }
                }
            }, () -> this.isTopicNsOwnedByBroker(topicName), null);
        })).exceptionally(exception -> {
            log.warn("[{}] Failed to get topic configuration: {}", new Object[]{topic, exception.getMessage(), exception});
            this.pulsar.getExecutor().execute(() -> this.topics.remove((Object)topic, (Object)topicFuture));
            topicFuture.completeExceptionally((Throwable)exception);
            return null;
        });
    }

    public CompletableFuture<ManagedLedgerConfig> getManagedLedgerConfig(TopicName topicName) {
        NamespaceName namespace = topicName.getNamespaceObject();
        ServiceConfiguration serviceConfig = this.pulsar.getConfiguration();
        NamespaceResources nsr = this.pulsar.getPulsarResources().getNamespaceResources();
        LocalPoliciesResources lpr = this.pulsar.getPulsarResources().getLocalPolicies();
        return nsr.getPoliciesAsync(namespace).thenCombine((CompletionStage)lpr.getLocalPoliciesAsync(namespace), (policies, localPolicies) -> {
            HashMap properties;
            PersistencePolicies persistencePolicies = null;
            RetentionPolicies retentionPolicies = null;
            OffloadPoliciesImpl topicLevelOffloadPolicies = null;
            if (this.pulsar.getConfig().isTopicLevelPoliciesEnabled()) {
                try {
                    TopicPolicies topicPolicies = this.pulsar.getTopicPoliciesService().getTopicPolicies(topicName);
                    if (topicPolicies != null) {
                        persistencePolicies = topicPolicies.getPersistence();
                        retentionPolicies = topicPolicies.getRetentionPolicies();
                        topicLevelOffloadPolicies = topicPolicies.getOffloadPolicies();
                    }
                }
                catch (BrokerServiceException.TopicPoliciesCacheNotInitException e) {
                    log.debug("Topic {} policies have not been initialized yet.", (Object)topicName);
                }
            }
            if (persistencePolicies == null) {
                persistencePolicies = policies.map(p -> p.persistence).orElseGet(() -> new PersistencePolicies(serviceConfig.getManagedLedgerDefaultEnsembleSize(), serviceConfig.getManagedLedgerDefaultWriteQuorum(), serviceConfig.getManagedLedgerDefaultAckQuorum(), serviceConfig.getManagedLedgerDefaultMarkDeleteRateLimit()));
            }
            if (retentionPolicies == null) {
                retentionPolicies = policies.map(p -> p.retention_policies).orElseGet(() -> new RetentionPolicies(serviceConfig.getDefaultRetentionTimeInMinutes(), serviceConfig.getDefaultRetentionSizeInMB()));
            }
            ManagedLedgerConfig managedLedgerConfig = new ManagedLedgerConfig();
            managedLedgerConfig.setEnsembleSize(persistencePolicies.getBookkeeperEnsemble());
            managedLedgerConfig.setWriteQuorumSize(persistencePolicies.getBookkeeperWriteQuorum());
            managedLedgerConfig.setAckQuorumSize(persistencePolicies.getBookkeeperAckQuorum());
            if (serviceConfig.isStrictBookieAffinityEnabled()) {
                managedLedgerConfig.setBookKeeperEnsemblePlacementPolicyClassName(IsolatedBookieEnsemblePlacementPolicy.class);
                if (localPolicies.isPresent() && ((LocalPolicies)localPolicies.get()).bookieAffinityGroup != null) {
                    properties = Maps.newHashMap();
                    properties.put("isolationBookieGroups", ((LocalPolicies)localPolicies.get()).bookieAffinityGroup.getBookkeeperAffinityGroupPrimary());
                    properties.put("secondaryIsolationBookieGroups", ((LocalPolicies)localPolicies.get()).bookieAffinityGroup.getBookkeeperAffinityGroupSecondary());
                    managedLedgerConfig.setBookKeeperEnsemblePlacementPolicyProperties((Map)properties);
                } else if (this.isSystemTopic(topicName)) {
                    properties = Maps.newHashMap();
                    properties.put("isolationBookieGroups", "*");
                    properties.put("secondaryIsolationBookieGroups", "*");
                    managedLedgerConfig.setBookKeeperEnsemblePlacementPolicyProperties((Map)properties);
                } else {
                    properties = Maps.newHashMap();
                    properties.put("isolationBookieGroups", "");
                    properties.put("secondaryIsolationBookieGroups", "");
                    managedLedgerConfig.setBookKeeperEnsemblePlacementPolicyProperties((Map)properties);
                }
            } else if (localPolicies.isPresent() && ((LocalPolicies)localPolicies.get()).bookieAffinityGroup != null) {
                managedLedgerConfig.setBookKeeperEnsemblePlacementPolicyClassName(IsolatedBookieEnsemblePlacementPolicy.class);
                properties = Maps.newHashMap();
                properties.put("isolationBookieGroups", ((LocalPolicies)localPolicies.get()).bookieAffinityGroup.getBookkeeperAffinityGroupPrimary());
                properties.put("secondaryIsolationBookieGroups", ((LocalPolicies)localPolicies.get()).bookieAffinityGroup.getBookkeeperAffinityGroupSecondary());
                managedLedgerConfig.setBookKeeperEnsemblePlacementPolicyProperties((Map)properties);
            }
            managedLedgerConfig.setThrottleMarkDelete(persistencePolicies.getManagedLedgerMaxMarkDeleteRate());
            managedLedgerConfig.setDigestType(serviceConfig.getManagedLedgerDigestType());
            managedLedgerConfig.setPassword(serviceConfig.getManagedLedgerPassword());
            managedLedgerConfig.setMaxUnackedRangesToPersist(serviceConfig.getManagedLedgerMaxUnackedRangesToPersist());
            managedLedgerConfig.setMaxUnackedRangesToPersistInZk(serviceConfig.getManagedLedgerMaxUnackedRangesToPersistInZooKeeper());
            managedLedgerConfig.setMaxEntriesPerLedger(serviceConfig.getManagedLedgerMaxEntriesPerLedger());
            managedLedgerConfig.setMinimumRolloverTime(serviceConfig.getManagedLedgerMinLedgerRolloverTimeMinutes(), TimeUnit.MINUTES);
            managedLedgerConfig.setMaximumRolloverTime(serviceConfig.getManagedLedgerMaxLedgerRolloverTimeMinutes(), TimeUnit.MINUTES);
            managedLedgerConfig.setMaxSizePerLedgerMb(serviceConfig.getManagedLedgerMaxSizePerLedgerMbytes());
            managedLedgerConfig.setMetadataOperationsTimeoutSeconds(serviceConfig.getManagedLedgerMetadataOperationsTimeoutSeconds());
            managedLedgerConfig.setReadEntryTimeoutSeconds(serviceConfig.getManagedLedgerReadEntryTimeoutSeconds());
            managedLedgerConfig.setAddEntryTimeoutSeconds(serviceConfig.getManagedLedgerAddEntryTimeoutSeconds());
            managedLedgerConfig.setMetadataEnsembleSize(serviceConfig.getManagedLedgerDefaultEnsembleSize());
            managedLedgerConfig.setUnackedRangesOpenCacheSetEnabled(serviceConfig.isManagedLedgerUnackedRangesOpenCacheSetEnabled());
            managedLedgerConfig.setMetadataWriteQuorumSize(serviceConfig.getManagedLedgerDefaultWriteQuorum());
            managedLedgerConfig.setMetadataAckQuorumSize(serviceConfig.getManagedLedgerDefaultAckQuorum());
            managedLedgerConfig.setMetadataMaxEntriesPerLedger(serviceConfig.getManagedLedgerCursorMaxEntriesPerLedger());
            managedLedgerConfig.setLedgerRolloverTimeout(serviceConfig.getManagedLedgerCursorRolloverTimeInSeconds());
            managedLedgerConfig.setRetentionTime(retentionPolicies.getRetentionTimeInMinutes(), TimeUnit.MINUTES);
            managedLedgerConfig.setRetentionSizeInMB(retentionPolicies.getRetentionSizeInMB());
            managedLedgerConfig.setAutoSkipNonRecoverableData(serviceConfig.isAutoSkipNonRecoverableData());
            managedLedgerConfig.setLazyCursorRecovery(serviceConfig.isLazyCursorRecovery());
            managedLedgerConfig.setInactiveLedgerRollOverTime(serviceConfig.getManagedLedgerInactiveLedgerRolloverTimeSeconds(), TimeUnit.SECONDS);
            OffloadPoliciesImpl nsLevelOffloadPolicies = policies.map(p -> p.offload_policies).orElse(null);
            OffloadPoliciesImpl offloadPolicies = OffloadPoliciesImpl.mergeConfiguration((OffloadPoliciesImpl)topicLevelOffloadPolicies, (OffloadPoliciesImpl)OffloadPoliciesImpl.oldPoliciesCompatible((OffloadPoliciesImpl)nsLevelOffloadPolicies, (Policies)policies.orElse(null)), (Properties)this.getPulsar().getConfig().getProperties());
            if (topicLevelOffloadPolicies != null) {
                try {
                    LedgerOffloader topicLevelLedgerOffLoader = this.pulsar().createManagedLedgerOffloader(offloadPolicies);
                    managedLedgerConfig.setLedgerOffloader(topicLevelLedgerOffLoader);
                }
                catch (PulsarServerException e) {
                    throw new RuntimeException(e);
                }
            } else {
                managedLedgerConfig.setLedgerOffloader(this.pulsar.getManagedLedgerOffloader(namespace, offloadPolicies));
            }
            managedLedgerConfig.setDeletionAtBatchIndexLevelEnabled(serviceConfig.isAcknowledgmentAtBatchIndexLevelEnabled());
            managedLedgerConfig.setNewEntriesCheckDelayInMillis(serviceConfig.getManagedLedgerNewEntriesCheckDelayInMillis());
            return managedLedgerConfig;
        });
    }

    private void addTopicToStatsMaps(TopicName topicName, Topic topic) {
        ((CompletableFuture)this.pulsar.getNamespaceService().getBundleAsync(topicName).thenAccept(namespaceBundle -> {
            if (namespaceBundle != null) {
                ConcurrentOpenHashMap<String, ConcurrentOpenHashMap<String, ConcurrentOpenHashMap<String, Topic>>> concurrentOpenHashMap = this.multiLayerTopicsMap;
                synchronized (concurrentOpenHashMap) {
                    String serviceUnit = namespaceBundle.toString();
                    ((ConcurrentOpenHashMap)((ConcurrentOpenHashMap)this.multiLayerTopicsMap.computeIfAbsent((Object)topicName.getNamespace(), k -> ConcurrentOpenHashMap.newBuilder().build())).computeIfAbsent((Object)serviceUnit, k -> ConcurrentOpenHashMap.newBuilder().build())).put((Object)topicName.toString(), (Object)topic);
                }
            }
            this.invalidateOfflineTopicStatCache(topicName);
        })).exceptionally(ex -> {
            log.warn("Got exception when retrieving bundle name during create persistent topic", ex);
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshTopicToStatsMaps(NamespaceBundle oldBundle) {
        block5: {
            Preconditions.checkNotNull((Object)oldBundle);
            try {
                List<Topic> topics = this.getAllTopicsFromNamespaceBundle(oldBundle.getNamespaceObject().toString(), oldBundle.toString());
                if (CollectionUtils.isEmpty(topics)) break block5;
                topics.stream().forEach(t -> this.addTopicToStatsMaps(TopicName.get((String)t.getName()), (Topic)t));
                ConcurrentOpenHashMap<String, ConcurrentOpenHashMap<String, ConcurrentOpenHashMap<String, Topic>>> concurrentOpenHashMap = this.multiLayerTopicsMap;
                synchronized (concurrentOpenHashMap) {
                    ((ConcurrentOpenHashMap)this.multiLayerTopicsMap.get((Object)oldBundle.getNamespaceObject().toString())).remove((Object)oldBundle.toString());
                    this.pulsarStats.invalidBundleStats(oldBundle.toString());
                }
            }
            catch (Exception e) {
                log.warn("Got exception while refreshing topicStats map", (Throwable)e);
            }
        }
    }

    public PersistentOfflineTopicStats getOfflineTopicStat(TopicName topicName) {
        return (PersistentOfflineTopicStats)this.offlineTopicStatCache.get((Object)topicName);
    }

    public void cacheOfflineTopicStats(TopicName topicName, PersistentOfflineTopicStats offlineTopicStats) {
        this.offlineTopicStatCache.put((Object)topicName, (Object)offlineTopicStats);
    }

    public void invalidateOfflineTopicStatCache(TopicName topicName) {
        PersistentOfflineTopicStats removed = (PersistentOfflineTopicStats)this.offlineTopicStatCache.remove((Object)topicName);
        if (removed != null) {
            log.info("Removed cached offline topic stat for {} ", (Object)topicName.getPersistenceNamingEncoding());
        }
    }

    public Optional<Topic> getTopicReference(String topic) {
        CompletableFuture future = (CompletableFuture)this.topics.get((Object)topic);
        if (future != null && future.isDone() && !future.isCompletedExceptionally()) {
            return (Optional)future.join();
        }
        return Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRates() {
        PulsarStats pulsarStats = this.pulsarStats;
        synchronized (pulsarStats) {
            this.pulsarStats.updateStats(this.multiLayerTopicsMap);
            Summary.rotateLatencyCollection();
        }
    }

    public void getDimensionMetrics(Consumer<ByteBuf> consumer) {
        this.pulsarStats.getDimensionMetrics(consumer);
    }

    public List<Metrics> getTopicMetrics() {
        return this.pulsarStats.getTopicMetrics();
    }

    public Map<String, NamespaceBundleStats> getBundleStats() {
        return this.pulsarStats.getBundleStats();
    }

    public Semaphore getLookupRequestSemaphore() {
        return this.lookupRequestSemaphore.get();
    }

    public void checkGC() {
        this.forEachTopic(Topic::checkGC);
    }

    public void checkMessageExpiry() {
        this.forEachTopic(Topic::checkMessageExpiry);
    }

    public void checkReplicationPolicies() {
        this.forEachTopic(Topic::checkReplication);
    }

    public void checkCompaction() {
        this.forEachTopic(t -> {
            if (t instanceof PersistentTopic) {
                ((PersistentTopic)t).checkCompaction();
            }
        });
    }

    private void checkConsumedLedgers() {
        this.forEachTopic(t -> {
            if (t instanceof PersistentTopic) {
                Optional.ofNullable(((PersistentTopic)t).getManagedLedger()).ifPresent(managedLedger -> managedLedger.trimConsumedLedgersInBackground(Futures.NULL_PROMISE));
            }
        });
    }

    public void checkMessageDeduplicationInfo() {
        this.forEachTopic(Topic::checkMessageDeduplicationInfo);
    }

    public void checkInactiveSubscriptions() {
        this.forEachTopic(Topic::checkInactiveSubscriptions);
    }

    public void checkTopicPublishThrottlingRate() {
        this.forEachTopic(Topic::checkTopicPublishThrottlingRate);
    }

    private void refreshTopicPublishRate() {
        this.forEachTopic(Topic::resetTopicPublishCountAndEnableReadIfRequired);
    }

    public void checkBrokerPublishThrottlingRate() {
        this.brokerPublishRateLimiter.checkPublishRate();
        if (this.brokerPublishRateLimiter.isPublishRateExceeded()) {
            this.forEachTopic(topic -> ((AbstractTopic)topic).disableProducerRead());
        }
    }

    private void refreshBrokerPublishRate() {
        boolean doneReset = this.brokerPublishRateLimiter.resetPublishCount();
        this.forEachTopic(topic -> topic.resetBrokerPublishCountAndEnableReadIfRequired(doneReset));
    }

    public void forEachTopic(Consumer<Topic> consumer) {
        this.topics.forEach((n, t) -> {
            Optional<Topic> topic = BrokerService.extractTopic(t);
            topic.ifPresent(consumer::accept);
        });
    }

    public BacklogQuotaManager getBacklogQuotaManager() {
        return this.backlogQuotaManager;
    }

    public void monitorBacklogQuota() {
        this.forEachTopic(topic -> {
            if (topic instanceof PersistentTopic) {
                PersistentTopic persistentTopic = (PersistentTopic)topic;
                if (persistentTopic.isSizeBacklogExceeded()) {
                    this.getBacklogQuotaManager().handleExceededBacklogQuota(persistentTopic, BacklogQuota.BacklogQuotaType.destination_storage, false);
                } else {
                    ((CompletableFuture)persistentTopic.checkTimeBacklogExceeded().thenAccept(isExceeded -> {
                        if (isExceeded.booleanValue()) {
                            this.getBacklogQuotaManager().handleExceededBacklogQuota(persistentTopic, BacklogQuota.BacklogQuotaType.message_age, this.pulsar.getConfiguration().isPreciseTimeBasedBacklogQuotaCheck());
                        } else if (log.isDebugEnabled()) {
                            log.debug("quota not exceeded for [{}]", (Object)topic.getName());
                        }
                    })).exceptionally(throwable -> {
                        log.error("Error when checkTimeBacklogExceeded({}) in monitorBacklogQuota", (Object)persistentTopic.getName(), throwable);
                        return null;
                    });
                }
            }
        });
    }

    public boolean isTopicNsOwnedByBroker(TopicName topicName) {
        try {
            return this.pulsar.getNamespaceService().isServiceUnitOwned((ServiceUnitId)topicName);
        }
        catch (Exception e) {
            log.warn("Failed to check the ownership of the topic: {}, {}", (Object)topicName, (Object)e.getMessage());
            return false;
        }
    }

    public CompletableFuture<Void> checkTopicNsOwnership(String topic) {
        TopicName topicName = TopicName.get((String)topic);
        return this.pulsar.getNamespaceService().checkTopicOwnership(topicName).thenCompose(ownedByThisInstance -> {
            if (ownedByThisInstance.booleanValue()) {
                return CompletableFuture.completedFuture(null);
            }
            String msg = String.format("Namespace bundle for topic (%s) not served by this instance. Please redo the lookup. Request is denied: namespace=%s", topic, topicName.getNamespace());
            log.warn(msg);
            return FutureUtil.failedFuture((Throwable)new BrokerServiceException.ServiceUnitNotReadyException(msg));
        });
    }

    public CompletableFuture<Integer> unloadServiceUnit(NamespaceBundle serviceUnit, boolean closeWithoutWaitingClientDisconnect, long timeout, TimeUnit unit) {
        CompletableFuture<Integer> future = this.unloadServiceUnit(serviceUnit, closeWithoutWaitingClientDisconnect);
        ScheduledFuture taskTimeout = this.executor().schedule(() -> {
            if (!future.isDone()) {
                log.warn("Unloading of {} has timed out", (Object)serviceUnit);
                future.complete(0);
            }
        }, timeout, unit);
        future.whenComplete((arg_0, arg_1) -> BrokerService.lambda$unloadServiceUnit$80((java.util.concurrent.ScheduledFuture)taskTimeout, arg_0, arg_1));
        return future;
    }

    private CompletableFuture<Integer> unloadServiceUnit(NamespaceBundle serviceUnit, boolean closeWithoutWaitingClientDisconnect) {
        ArrayList closeFutures = Lists.newArrayList();
        this.topics.forEach((name, topicFuture) -> {
            TopicName topicName = TopicName.get((String)name);
            if (serviceUnit.includes(topicName)) {
                log.info("[{}] Unloading topic", (Object)topicName);
                closeFutures.add(topicFuture.thenCompose(t -> t.isPresent() ? ((Topic)t.get()).close(closeWithoutWaitingClientDisconnect) : CompletableFuture.completedFuture(null)));
            }
        });
        if (this.getPulsar().getConfig().isTransactionCoordinatorEnabled() && serviceUnit.getNamespaceObject().equals((Object)NamespaceName.SYSTEM_NAMESPACE)) {
            TransactionMetadataStoreService metadataStoreService = this.getPulsar().getTransactionMetadataStoreService();
            this.getPulsar().getTransactionMetadataStoreService().getStores().values().stream().filter(store -> serviceUnit.includes(TopicName.TRANSACTION_COORDINATOR_ASSIGN.getPartition((int)store.getTransactionCoordinatorID().getId()))).map(TransactionMetadataStore::getTransactionCoordinatorID).forEach(tcId -> closeFutures.add(metadataStoreService.removeTransactionMetadataStore((TransactionCoordinatorID)tcId)));
        }
        return FutureUtil.waitForAll((List)closeFutures).thenApply(v -> closeFutures.size());
    }

    public void cleanUnloadedTopicFromCache(NamespaceBundle serviceUnit) {
        for (String topic : this.topics.keys()) {
            TopicName topicName = TopicName.get((String)topic);
            if (!serviceUnit.includes(topicName) || !this.getTopicReference(topic).isPresent()) continue;
            log.info("[{}][{}] Clean unloaded topic from cache.", (Object)serviceUnit.toString(), (Object)topic);
            this.pulsar.getBrokerService().removeTopicFromCache(topicName.toString(), serviceUnit);
        }
    }

    public AuthorizationService getAuthorizationService() {
        return this.authorizationService;
    }

    public CompletableFuture<Void> removeTopicFromCache(String topic) {
        TopicName topicName = TopicName.get((String)topic);
        return this.pulsar.getNamespaceService().getBundleAsync(topicName).thenAccept(namespaceBundle -> this.removeTopicFromCache(topic, (NamespaceBundle)namespaceBundle));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTopicFromCache(String topic, NamespaceBundle namespaceBundle) {
        String bundleName = namespaceBundle.toString();
        String namespaceName = TopicName.get((String)topic).getNamespaceObject().toString();
        ConcurrentOpenHashMap<String, ConcurrentOpenHashMap<String, ConcurrentOpenHashMap<String, Topic>>> concurrentOpenHashMap = this.multiLayerTopicsMap;
        synchronized (concurrentOpenHashMap) {
            ConcurrentOpenHashMap namespaceMap = (ConcurrentOpenHashMap)this.multiLayerTopicsMap.get((Object)namespaceName);
            if (namespaceMap != null) {
                ConcurrentOpenHashMap bundleMap = (ConcurrentOpenHashMap)namespaceMap.get((Object)bundleName);
                if (bundleMap != null) {
                    bundleMap.remove((Object)topic);
                    if (bundleMap.isEmpty()) {
                        namespaceMap.remove((Object)bundleName);
                    }
                }
                if (namespaceMap.isEmpty()) {
                    this.multiLayerTopicsMap.remove((Object)namespaceName);
                    ClusterReplicationMetrics clusterReplicationMetrics = this.pulsarStats.getClusterReplicationMetrics();
                    this.replicationClients.forEach((cluster, client) -> clusterReplicationMetrics.remove(clusterReplicationMetrics.getKeyName(namespaceName, (String)cluster)));
                }
            }
        }
        this.topics.remove((Object)topic);
        try {
            Compactor compactor = this.pulsar.getCompactor(false);
            if (compactor != null) {
                compactor.getStats().removeTopic(topic);
            }
        }
        catch (PulsarServerException pulsarServerException) {
            // empty catch block
        }
    }

    public int getNumberOfNamespaceBundles() {
        this.numberOfNamespaceBundles = 0;
        this.multiLayerTopicsMap.forEach((namespaceName, bundles) -> {
            this.numberOfNamespaceBundles = (int)((long)this.numberOfNamespaceBundles + bundles.size());
        });
        return this.numberOfNamespaceBundles;
    }

    public ConcurrentOpenHashMap<String, CompletableFuture<Optional<Topic>>> getTopics() {
        return this.topics;
    }

    private void handleMetadataChanges(Notification n) {
        if (n.getType() == NotificationType.Modified && NamespaceResources.pathIsFromNamespace((String)n.getPath())) {
            NamespaceName ns = NamespaceResources.namespaceFromPath((String)n.getPath());
            this.handlePoliciesUpdates(ns);
        } else if (n.getType() == NotificationType.Modified && NamespaceResources.pathIsNamespaceLocalPolicies((String)n.getPath())) {
            NamespaceName ns = NamespaceResources.namespaceFromLocalPoliciesPath((String)n.getPath());
            this.handleLocalPoliciesUpdates(ns);
        } else if (this.pulsar().getPulsarResources().getDynamicConfigResources().isDynamicConfigurationPath(n.getPath())) {
            this.handleDynamicConfigurationUpdates();
        }
    }

    private void handleLocalPoliciesUpdates(NamespaceName namespace) {
        this.pulsar.getPulsarResources().getLocalPolicies().getLocalPoliciesAsync(namespace).thenAccept(optLocalPolicies -> {
            if (!optLocalPolicies.isPresent()) {
                return;
            }
            LocalPolicies localPolicies = (LocalPolicies)optLocalPolicies.get();
            log.info("[{}] updating with {}", (Object)namespace, (Object)localPolicies);
            this.topics.forEach((name, topicFuture) -> {
                if (namespace.includes(TopicName.get((String)name))) {
                    topicFuture.thenAccept(topic -> {
                        if (log.isDebugEnabled()) {
                            log.debug("Notifying topic that local policies have changed: {}", name);
                        }
                        topic.ifPresent(t -> {
                            if (t instanceof PersistentTopic) {
                                PersistentTopic topic1 = (PersistentTopic)t;
                                topic1.onLocalPoliciesUpdate();
                            }
                        });
                    });
                }
            });
        });
    }

    private void handlePoliciesUpdates(NamespaceName namespace) {
        this.pulsar.getPulsarResources().getNamespaceResources().getPoliciesAsync(namespace).thenAccept(optPolicies -> {
            if (!optPolicies.isPresent()) {
                return;
            }
            Policies policies = (Policies)optPolicies.get();
            log.info("[{}] updating with {}", (Object)namespace, (Object)policies);
            this.topics.forEach((name, topicFuture) -> {
                if (namespace.includes(TopicName.get((String)name))) {
                    topicFuture.thenAccept(topic -> {
                        if (log.isDebugEnabled()) {
                            log.debug("Notifying topic that policies have changed: {}", name);
                        }
                        topic.ifPresent(t -> t.onPoliciesUpdate(policies));
                    });
                }
            });
            this.unloadDeletedReplNamespace(policies, namespace);
        });
    }

    private void handleDynamicConfigurationUpdates() {
        this.pulsar().getPulsarResources().getDynamicConfigResources().getDynamicConfigurationAsync().thenAccept(optMap -> {
            if (!optMap.isPresent()) {
                return;
            }
            Map data = (Map)optMap.get();
            data.forEach((configKey, value) -> {
                Field configField = ((ConfigField)BrokerService.dynamicConfigurationMap.get((Object)configKey)).field;
                Object newValue = FieldParser.value((String)((String)data.get(configKey)), (Field)configField);
                if (configField != null) {
                    Consumer listener = (Consumer)this.configRegisteredListeners.get(configKey);
                    try {
                        Object existingValue = configField.get(this.pulsar.getConfiguration());
                        configField.set(this.pulsar.getConfiguration(), newValue);
                        log.info("Successfully updated configuration {}/{}", configKey, data.get(configKey));
                        if (listener != null && !existingValue.equals(newValue)) {
                            listener.accept(newValue);
                        }
                    }
                    catch (Exception e) {
                        log.error("Failed to update config {}/{}", configKey, newValue);
                    }
                } else {
                    log.error("Found non-dynamic field in dynamicConfigMap {}/{}", configKey, newValue);
                }
            });
        });
    }

    private void unloadDeletedReplNamespace(Policies data, NamespaceName namespace) {
        if (!namespace.isGlobal()) {
            return;
        }
        String localCluster = this.pulsar.getConfiguration().getClusterName();
        if (!data.replication_clusters.contains(localCluster)) {
            this.pulsar().getNamespaceService().getNamespaceBundleFactory().getBundlesAsync(namespace).thenAccept(bundles -> bundles.getBundles().forEach(bundle -> this.pulsar.getNamespaceService().isNamespaceBundleOwned((NamespaceBundle)bundle).thenAccept(isExist -> {
                if (isExist.booleanValue()) {
                    this.pulsar().getExecutor().submit(() -> {
                        try {
                            this.pulsar().getAdminClient().namespaces().unloadNamespaceBundle(namespace.toString(), bundle.getBundleRange());
                        }
                        catch (Exception e) {
                            log.error("Failed to unload namespace-bundle {}-{} that not owned by {}, {}", new Object[]{namespace.toString(), bundle.toString(), localCluster, e.getMessage()});
                        }
                    });
                }
            })));
        }
    }

    public PulsarService pulsar() {
        return this.pulsar;
    }

    public EventLoopGroup executor() {
        return this.workerGroup;
    }

    public ConcurrentOpenHashMap<String, PulsarClient> getReplicationClients() {
        return this.replicationClients;
    }

    public boolean isAuthenticationEnabled() {
        return this.pulsar.getConfiguration().isAuthenticationEnabled();
    }

    public boolean isAuthorizationEnabled() {
        return this.pulsar.getConfiguration().isAuthorizationEnabled();
    }

    public int getKeepAliveIntervalSeconds() {
        return this.keepAliveIntervalSeconds;
    }

    public String generateUniqueProducerName() {
        return this.producerNameGenerator.getNextId();
    }

    public Map<String, TopicStatsImpl> getTopicStats() {
        HashMap<String, TopicStatsImpl> stats = new HashMap<String, TopicStatsImpl>();
        this.forEachTopic(topic -> stats.put(topic.getName(), topic.getStats(false, false, false)));
        return stats;
    }

    public AuthenticationService getAuthenticationService() {
        return this.authenticationService;
    }

    public List<Topic> getAllTopicsFromNamespaceBundle(String namespace, String bundle) {
        ConcurrentOpenHashMap map1 = (ConcurrentOpenHashMap)this.multiLayerTopicsMap.get((Object)namespace);
        if (map1 == null) {
            return Collections.emptyList();
        }
        ConcurrentOpenHashMap map2 = (ConcurrentOpenHashMap)map1.get((Object)bundle);
        if (map2 == null) {
            return Collections.emptyList();
        }
        return map2.values();
    }

    private void updateConfigurationAndRegisterListeners() {
        this.addDynamicConfigValidator("loadManagerClassName", className -> {
            try {
                Class.forName(className);
            }
            catch (ClassNotFoundException | NoClassDefFoundError e) {
                log.warn("Configured load-manager class {} not found {}", className, (Object)e.getMessage());
                return false;
            }
            return true;
        });
        this.updateDynamicServiceConfiguration();
        this.registerConfigurationListener("maxConcurrentLookupRequest", maxConcurrentLookupRequest -> this.lookupRequestSemaphore.set(new Semaphore((Integer)maxConcurrentLookupRequest, false)));
        this.registerConfigurationListener("maxConcurrentTopicLoadRequest", maxConcurrentTopicLoadRequest -> this.topicLoadRequestSemaphore.set(new Semaphore((Integer)maxConcurrentTopicLoadRequest, false)));
        this.registerConfigurationListener("loadManagerClassName", className -> this.pulsar.getExecutor().execute(() -> {
            try {
                LoadManager newLoadManager = LoadManager.create(this.pulsar);
                log.info("Created load manager: {}", className);
                this.pulsar.getLoadManager().get().stop();
                newLoadManager.start();
                this.pulsar.getLoadManager().set(newLoadManager);
            }
            catch (Exception ex) {
                log.warn("Failed to change load manager", (Throwable)ex);
            }
        }));
        this.registerConfigurationListener("managedLedgerCacheSizeMB", managedLedgerCacheSizeMB -> this.managedLedgerFactory.getEntryCacheManager().updateCacheSizeAndThreshold((long)((Integer)managedLedgerCacheSizeMB).intValue() * 1024L * 1024L));
        this.registerConfigurationListener("managedLedgerCacheEvictionWatermark", cacheEvictionWatermark -> this.managedLedgerFactory.getEntryCacheManager().updateCacheEvictionWatermark(((Double)cacheEvictionWatermark).doubleValue()));
        this.registerConfigurationListener("managedLedgerCacheEvictionTimeThresholdMillis", cacheEvictionTimeThresholdMills -> this.managedLedgerFactory.updateCacheEvictionTimeThreshold(TimeUnit.MILLISECONDS.toNanos((Long)cacheEvictionTimeThresholdMills)));
        this.registerConfigurationListener("dispatchThrottlingRatePerTopicInMsg", dispatchRatePerTopicInMsg -> this.updateTopicMessageDispatchRate());
        this.registerConfigurationListener("dispatchThrottlingRatePerTopicInByte", dispatchRatePerTopicInByte -> this.updateTopicMessageDispatchRate());
        this.registerConfigurationListener("autoSkipNonRecoverableData", skipNonRecoverableLedger -> this.updateManagedLedgerConfig());
        this.registerConfigurationListener("dispatchThrottlingRatePerSubscriptionInMsg", dispatchRatePerTopicInMsg -> this.updateSubscriptionMessageDispatchRate());
        this.registerConfigurationListener("dispatchThrottlingRatePerSubscriptionInByte", dispatchRatePerTopicInByte -> this.updateSubscriptionMessageDispatchRate());
        this.registerConfigurationListener("dispatchThrottlingRatePerReplicatorInMsg", dispatchRatePerTopicInMsg -> this.updateReplicatorMessageDispatchRate());
        this.registerConfigurationListener("dispatchThrottlingRatePerReplicatorInByte", dispatchRatePerTopicInByte -> this.updateReplicatorMessageDispatchRate());
        this.registerConfigurationListener("brokerPublisherThrottlingTickTimeMillis", publisherThrottlingTickTimeMillis -> this.setupBrokerPublishRateLimiterMonitor());
        this.registerConfigurationListener("maxPublishRatePerTopicInMessages", maxPublishRatePerTopicInMessages -> this.updateMaxPublishRatePerTopicInMessages());
        this.registerConfigurationListener("maxPublishRatePerTopicInBytes", maxPublishRatePerTopicInMessages -> this.updateMaxPublishRatePerTopicInMessages());
        this.registerConfigurationListener("brokerPublisherThrottlingMaxMessageRate", brokerPublisherThrottlingMaxMessageRate -> this.updateBrokerPublisherThrottlingMaxRate());
        this.registerConfigurationListener("brokerPublisherThrottlingMaxByteRate", brokerPublisherThrottlingMaxByteRate -> this.updateBrokerPublisherThrottlingMaxRate());
        this.registerConfigurationListener("dispatchThrottlingRateInMsg", dispatchThrottlingRateInMsg -> this.updateBrokerDispatchThrottlingMaxRate());
        this.registerConfigurationListener("dispatchThrottlingRateInByte", dispatchThrottlingRateInByte -> this.updateBrokerDispatchThrottlingMaxRate());
        if (!this.preciseTopicPublishRateLimitingEnable) {
            this.registerConfigurationListener("topicPublisherThrottlingTickTimeMillis", publisherThrottlingTickTimeMillis -> this.setupTopicPublishRateLimiterMonitor());
        }
        this.registerConfigurationListener("subscriptionTypesEnabled", this::updateBrokerSubscriptionTypesEnabled);
    }

    private void updateBrokerDispatchThrottlingMaxRate() {
        if (this.brokerDispatchRateLimiter == null) {
            this.brokerDispatchRateLimiter = new DispatchRateLimiter(this);
        } else {
            this.brokerDispatchRateLimiter.updateDispatchRate();
        }
    }

    private void updateMaxPublishRatePerTopicInMessages() {
        this.pulsar().getExecutor().submit(() -> this.forEachTopic(topic -> {
            if (topic instanceof AbstractTopic) {
                ((AbstractTopic)topic).updateBrokerPublishRate();
                ((AbstractTopic)topic).updatePublishDispatcher();
            }
        }));
    }

    private void updateBrokerPublisherThrottlingMaxRate() {
        int currentMaxMessageRate = this.pulsar.getConfiguration().getBrokerPublisherThrottlingMaxMessageRate();
        long currentMaxByteRate = this.pulsar.getConfiguration().getBrokerPublisherThrottlingMaxByteRate();
        int brokerTickMs = this.pulsar.getConfiguration().getBrokerPublisherThrottlingTickTimeMillis();
        if (brokerTickMs <= 0 || currentMaxByteRate <= 0L && currentMaxMessageRate <= 0) {
            if (this.brokerPublishRateLimiter != PublishRateLimiter.DISABLED_RATE_LIMITER) {
                this.refreshBrokerPublishRate();
                this.brokerPublishRateLimiter = PublishRateLimiter.DISABLED_RATE_LIMITER;
            }
            return;
        }
        PublishRate publishRate = new PublishRate(currentMaxMessageRate, currentMaxByteRate);
        log.info("Update broker publish rate limiting {}", (Object)publishRate);
        this.setupBrokerPublishRateLimiterMonitor();
        if (this.brokerPublishRateLimiter == null || this.brokerPublishRateLimiter == PublishRateLimiter.DISABLED_RATE_LIMITER) {
            this.brokerPublishRateLimiter = new PublishRateLimiterImpl(publishRate);
        } else {
            this.brokerPublishRateLimiter.update(publishRate);
        }
    }

    private void updateTopicMessageDispatchRate() {
        this.pulsar().getExecutor().execute(() -> this.forEachTopic(topic -> {
            if (topic instanceof AbstractTopic) {
                ((AbstractTopic)topic).updateBrokerDispatchRate();
            }
            if (topic.getDispatchRateLimiter().isPresent()) {
                topic.getDispatchRateLimiter().get().updateDispatchRate();
            }
        }));
    }

    private void updateBrokerSubscriptionTypesEnabled(Object subscriptionTypesEnabled) {
        this.pulsar().getExecutor().execute(() -> this.forEachTopic(topic -> {
            if (topic instanceof AbstractTopic) {
                ((AbstractTopic)topic).updateBrokerSubscriptionTypesEnabled();
            }
        }));
    }

    private void updateSubscriptionMessageDispatchRate() {
        this.pulsar().getExecutor().submit(() -> this.forEachTopic(topic -> {
            if (topic instanceof AbstractTopic) {
                ((AbstractTopic)topic).updateBrokerSubscriptionDispatchRate();
            }
            topic.getSubscriptions().forEach((subName, persistentSubscription) -> {
                Dispatcher dispatcher = persistentSubscription.getDispatcher();
                if (dispatcher != null) {
                    dispatcher.getRateLimiter().ifPresent(DispatchRateLimiter::updateDispatchRate);
                }
            });
        }));
    }

    private void updateReplicatorMessageDispatchRate() {
        this.pulsar().getExecutor().submit(() -> this.forEachTopic(topic -> {
            if (topic instanceof AbstractTopic) {
                ((AbstractTopic)topic).updateBrokerReplicatorDispatchRate();
            }
            topic.getReplicators().forEach((name, persistentReplicator) -> persistentReplicator.getRateLimiter().ifPresent(DispatchRateLimiter::updateDispatchRate));
        }));
    }

    private void updateManagedLedgerConfig() {
        this.pulsar().getExecutor().execute(() -> this.forEachTopic(topic -> {
            try {
                if (topic instanceof PersistentTopic) {
                    PersistentTopic persistentTopic = (PersistentTopic)topic;
                    persistentTopic.getManagedLedger().getConfig().setAutoSkipNonRecoverableData(this.pulsar.getConfiguration().isAutoSkipNonRecoverableData());
                }
            }
            catch (Exception e) {
                log.warn("[{}] failed to update managed-ledger config", (Object)topic.getName(), (Object)e);
            }
        }));
    }

    public <T> void registerConfigurationListener(String configKey, Consumer<T> listener) {
        this.validateConfigKey(configKey);
        this.configRegisteredListeners.put((Object)configKey, listener);
    }

    private void addDynamicConfigValidator(String key, Predicate<String> validator) {
        this.validateConfigKey(key);
        if (dynamicConfigurationMap.containsKey((Object)key)) {
            ((ConfigField)BrokerService.dynamicConfigurationMap.get((Object)key)).validator = validator;
        }
    }

    private void validateConfigKey(String key) {
        try {
            ServiceConfiguration.class.getDeclaredField(key);
        }
        catch (Exception e) {
            log.error("ServiceConfiguration key {} not found {}", (Object)key, (Object)e.getMessage());
            throw new IllegalArgumentException("Invalid service config " + key, e);
        }
    }

    private void updateDynamicServiceConfiguration() {
        Optional configCache = Optional.empty();
        try {
            configCache = this.pulsar().getPulsarResources().getDynamicConfigResources().getDynamicConfiguration();
            if (!configCache.isPresent()) {
                this.pulsar().getPulsarResources().getDynamicConfigResources().setDynamicConfigurationWithCreate(n -> Maps.newHashMap());
            }
        }
        catch (Exception e) {
            log.warn("Failed to read dynamic broker configuration", (Throwable)e);
        }
        configCache.ifPresent(stringStringMap -> stringStringMap.forEach((key, value) -> {
            if (dynamicConfigurationMap.containsKey(key) && ((ConfigField)BrokerService.dynamicConfigurationMap.get((Object)key)).validator != null && !((ConfigField)BrokerService.dynamicConfigurationMap.get((Object)key)).validator.test((String)value)) {
                log.error("Failed to validate dynamic config {} with value {}", key, value);
                throw new IllegalArgumentException(String.format("Failed to validate dynamic-config %s/%s", key, value));
            }
            try {
                Field field = ServiceConfiguration.class.getDeclaredField((String)key);
                if (field != null && field.isAnnotationPresent(FieldContext.class)) {
                    field.setAccessible(true);
                    field.set(this.pulsar().getConfiguration(), FieldParser.value((String)value, (Field)field));
                    log.info("Successfully updated {}/{}", key, value);
                }
            }
            catch (Exception e) {
                log.warn("Failed to update service configuration {}/{}, {}", new Object[]{key, value, e.getMessage()});
            }
        }));
    }

    public DelayedDeliveryTrackerFactory getDelayedDeliveryTrackerFactory() {
        return this.delayedDeliveryTrackerFactory;
    }

    public static List<String> getDynamicConfiguration() {
        return dynamicConfigurationMap.keys();
    }

    public Map<String, String> getRuntimeConfiguration() {
        HashMap configMap = Maps.newHashMap();
        ConcurrentOpenHashMap<String, Object> runtimeConfigurationMap = this.getRuntimeConfigurationMap();
        runtimeConfigurationMap.forEach((key, value) -> configMap.put(key, String.valueOf(value)));
        return configMap;
    }

    public static boolean isDynamicConfiguration(String key) {
        return dynamicConfigurationMap.containsKey((Object)key);
    }

    public static boolean validateDynamicConfiguration(String key, String value) {
        if (dynamicConfigurationMap.containsKey((Object)key) && ((ConfigField)BrokerService.dynamicConfigurationMap.get((Object)key)).validator != null) {
            return ((ConfigField)BrokerService.dynamicConfigurationMap.get((Object)key)).validator.test(value);
        }
        return true;
    }

    private static ConcurrentOpenHashMap<String, ConfigField> prepareDynamicConfigurationMap() {
        ConcurrentOpenHashMap dynamicConfigurationMap = ConcurrentOpenHashMap.newBuilder().build();
        for (Field field : ServiceConfiguration.class.getDeclaredFields()) {
            if (field == null || !field.isAnnotationPresent(FieldContext.class)) continue;
            field.setAccessible(true);
            if (!field.getAnnotation(FieldContext.class).dynamic()) continue;
            dynamicConfigurationMap.put((Object)field.getName(), (Object)new ConfigField(field));
        }
        return dynamicConfigurationMap;
    }

    private ConcurrentOpenHashMap<String, Object> getRuntimeConfigurationMap() {
        ConcurrentOpenHashMap runtimeConfigurationMap = ConcurrentOpenHashMap.newBuilder().build();
        for (Field field : ServiceConfiguration.class.getDeclaredFields()) {
            if (field == null || !field.isAnnotationPresent(FieldContext.class)) continue;
            field.setAccessible(true);
            try {
                Object configValue = field.get(this.pulsar.getConfiguration());
                runtimeConfigurationMap.put((Object)field.getName(), configValue == null ? "" : configValue);
            }
            catch (Exception e) {
                log.error("Failed to get value of field {}, {}", (Object)field.getName(), (Object)e.getMessage());
            }
        }
        return runtimeConfigurationMap;
    }

    private void createPendingLoadTopic() {
        TopicLoadingContext pendingTopic = this.pendingTopicLoadingQueue.poll();
        if (pendingTopic == null) {
            return;
        }
        String topic = pendingTopic.getTopic();
        ((CompletableFuture)this.checkTopicNsOwnership(topic).thenRun(() -> {
            CompletableFuture<Optional<Topic>> pendingFuture = pendingTopic.getTopicFuture();
            Semaphore topicLoadSemaphore = this.topicLoadRequestSemaphore.get();
            boolean acquiredPermit = topicLoadSemaphore.tryAcquire();
            this.createPersistentTopic(topic, true, pendingFuture, pendingTopic.getProperties());
            pendingFuture.handle((persistentTopic, ex) -> {
                if (acquiredPermit) {
                    topicLoadSemaphore.release();
                }
                this.createPendingLoadTopic();
                return null;
            });
        })).exceptionally(e -> {
            log.error("Failed to create pending topic {}", (Object)topic, e);
            pendingTopic.getTopicFuture().completeExceptionally(e instanceof RuntimeException && e.getCause() != null ? e.getCause() : e);
            this.inactivityMonitor.schedule(this::createPendingLoadTopic, 100L, TimeUnit.MILLISECONDS);
            return null;
        });
    }

    public CompletableFuture<PartitionedTopicMetadata> fetchPartitionedTopicMetadataCheckAllowAutoCreationAsync(TopicName topicName) {
        if (this.pulsar.getNamespaceService() == null) {
            return FutureUtil.failedFuture((Throwable)new BrokerServiceException.NamingException("namespace service is not ready"));
        }
        return this.pulsar.getNamespaceService().checkTopicExists(topicName).thenCompose(topicExists -> this.fetchPartitionedTopicMetadataAsync(topicName).thenCompose(metadata -> {
            CompletableFuture future = new CompletableFuture();
            this.pulsar.getExecutor().execute(() -> {
                if (metadata.partitions == 0 && !topicExists.booleanValue() && !topicName.isPartitioned() && this.pulsar.getBrokerService().isAllowAutoTopicCreation(topicName) && this.pulsar.getBrokerService().isDefaultTopicTypePartitioned(topicName)) {
                    ((CompletableFuture)this.pulsar.getBrokerService().createDefaultPartitionedTopicAsync(topicName).thenAccept(md -> future.complete(md))).exceptionally(ex -> {
                        future.completeExceptionally((Throwable)ex);
                        return null;
                    });
                } else {
                    future.complete(metadata);
                }
            });
            return future;
        }));
    }

    private CompletableFuture<PartitionedTopicMetadata> createDefaultPartitionedTopicAsync(TopicName topicName) {
        int defaultNumPartitions = this.pulsar.getBrokerService().getDefaultNumPartitions(topicName);
        int maxPartitions = this.pulsar().getConfig().getMaxNumPartitionsPerPartitionedTopic();
        Preconditions.checkArgument((defaultNumPartitions > 0 ? 1 : 0) != 0, (Object)"Default number of partitions should be more than 0");
        Preconditions.checkArgument((maxPartitions <= 0 || defaultNumPartitions <= maxPartitions ? 1 : 0) != 0, (Object)("Number of partitions should be less than or equal to " + maxPartitions));
        PartitionedTopicMetadata configMetadata = new PartitionedTopicMetadata(defaultNumPartitions);
        return this.checkMaxTopicsPerNamespace(topicName, defaultNumPartitions).thenCompose(__ -> {
            NamespaceResources.PartitionedTopicResources partitionResources = this.pulsar.getPulsarResources().getNamespaceResources().getPartitionedTopicResources();
            return partitionResources.createPartitionedTopicAsync(topicName, configMetadata).thenApply(v -> {
                log.info("partitioned metadata successfully created for {}", (Object)topicName);
                return configMetadata;
            });
        });
    }

    public CompletableFuture<PartitionedTopicMetadata> fetchPartitionedTopicMetadataAsync(TopicName topicName) {
        return this.pulsar.getPulsarResources().getNamespaceResources().getPartitionedTopicResources().getPartitionedTopicMetadataAsync(topicName).thenApply(metadata -> metadata.orElseGet(() -> new PartitionedTopicMetadata()));
    }

    public OrderedExecutor getTopicOrderedExecutor() {
        return this.topicOrderedExecutor;
    }

    public ConcurrentOpenHashMap<String, ConcurrentOpenHashMap<String, ConcurrentOpenHashMap<String, Topic>>> getMultiLayerTopicMap() {
        return this.multiLayerTopicsMap;
    }

    public void addUnAckedMessages(PersistentDispatcherMultipleConsumers dispatcher, int numberOfMessages) {
        if (this.maxUnackedMessages > 0) {
            totalUnackedMessages.add(numberOfMessages);
            if (blockedDispatcherOnHighUnackedMsgs.get() && !dispatcher.isBlockedDispatcherOnUnackedMsgs() && dispatcher.getTotalUnackedMessages() > this.maxUnackedMsgsPerDispatcher) {
                this.lock.readLock().lock();
                try {
                    log.info("[{}] dispatcher reached to max unack msg limit on blocked-broker {}", (Object)dispatcher.getName(), (Object)dispatcher.getTotalUnackedMessages());
                    dispatcher.blockDispatcherOnUnackedMsgs();
                    this.blockedDispatchers.add((Object)dispatcher);
                }
                finally {
                    this.lock.readLock().unlock();
                }
            }
        }
    }

    public void checkUnAckMessageDispatching() {
        if (this.maxUnackedMessages <= 0) {
            return;
        }
        long unAckedMessages = totalUnackedMessages.sum();
        if (unAckedMessages >= (long)this.maxUnackedMessages && blockedDispatcherOnHighUnackedMsgs.compareAndSet(false, true)) {
            log.info("Starting blocking dispatchers with unacked msgs {} due to reached max broker limit {}", (Object)this.maxUnackedMessages, (Object)this.maxUnackedMsgsPerDispatcher);
            this.executor().execute(() -> this.blockDispatchersWithLargeUnAckMessages());
        } else if (blockedDispatcherOnHighUnackedMsgs.get() && unAckedMessages < (long)(this.maxUnackedMessages / 2) && blockedDispatcherOnHighUnackedMsgs.compareAndSet(true, false)) {
            this.unblockDispatchersOnUnAckMessages(this.blockedDispatchers.values());
        }
    }

    public boolean isBrokerDispatchingBlocked() {
        return blockedDispatcherOnHighUnackedMsgs.get();
    }

    private void blockDispatchersWithLargeUnAckMessages() {
        this.lock.readLock().lock();
        try {
            this.forEachTopic(topic -> topic.getSubscriptions().forEach((subName, persistentSubscription) -> {
                PersistentDispatcherMultipleConsumers dispatcher;
                int dispatcherUnAckMsgs;
                if (persistentSubscription.getDispatcher() instanceof PersistentDispatcherMultipleConsumers && (dispatcherUnAckMsgs = (dispatcher = (PersistentDispatcherMultipleConsumers)persistentSubscription.getDispatcher()).getTotalUnackedMessages()) > this.maxUnackedMsgsPerDispatcher) {
                    log.info("[{}] Blocking dispatcher due to reached max broker limit {}", (Object)dispatcher.getName(), (Object)dispatcher.getTotalUnackedMessages());
                    dispatcher.blockDispatcherOnUnackedMsgs();
                    this.blockedDispatchers.add((Object)dispatcher);
                }
            }));
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void unblockDispatchersOnUnAckMessages(List<PersistentDispatcherMultipleConsumers> dispatcherList) {
        this.lock.writeLock().lock();
        try {
            dispatcherList.forEach(dispatcher -> {
                dispatcher.unBlockDispatcherOnUnackedMsgs();
                this.executor().execute(() -> dispatcher.readMoreEntries());
                log.info("[{}] Dispatcher is unblocked", (Object)dispatcher.getName());
                this.blockedDispatchers.remove(dispatcher);
            });
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public static Optional<Topic> extractTopic(CompletableFuture<Optional<Topic>> topicFuture) {
        if (topicFuture.isDone() && !topicFuture.isCompletedExceptionally()) {
            return topicFuture.join();
        }
        return Optional.empty();
    }

    public Optional<Integer> getListenPort() {
        if (this.listenChannel != null) {
            return Optional.of(((InetSocketAddress)this.listenChannel.localAddress()).getPort());
        }
        return Optional.empty();
    }

    public Optional<Integer> getListenPortTls() {
        if (this.listenChannelTls != null) {
            return Optional.of(((InetSocketAddress)this.listenChannelTls.localAddress()).getPort());
        }
        return Optional.empty();
    }

    private void foreachCnx(Consumer<TransportCnx> consumer) {
        HashSet cnxSet = new HashSet();
        this.topics.forEach((n, t) -> {
            Optional<Topic> topic = BrokerService.extractTopic(t);
            topic.ifPresent(value -> value.getProducers().values().forEach(producer -> cnxSet.add(producer.getCnx())));
        });
        cnxSet.forEach(consumer);
    }

    public boolean isAllowAutoTopicCreation(String topic) {
        TopicName topicName = TopicName.get((String)topic);
        return this.isAllowAutoTopicCreation(topicName);
    }

    public boolean isAllowAutoTopicCreation(TopicName topicName) {
        if (this.pulsar.getConfiguration().isSystemTopicEnabled() && this.isSystemTopic(topicName)) {
            return true;
        }
        AutoTopicCreationOverride autoTopicCreationOverride = this.getAutoTopicCreationOverride(topicName);
        if (autoTopicCreationOverride != null) {
            return autoTopicCreationOverride.isAllowAutoTopicCreation();
        }
        return this.pulsar.getConfiguration().isAllowAutoTopicCreation();
    }

    public boolean isDefaultTopicTypePartitioned(TopicName topicName) {
        AutoTopicCreationOverride autoTopicCreationOverride = this.getAutoTopicCreationOverride(topicName);
        if (autoTopicCreationOverride != null) {
            return TopicType.PARTITIONED.toString().equals(autoTopicCreationOverride.getTopicType());
        }
        return this.pulsar.getConfiguration().isDefaultTopicTypePartitioned();
    }

    public int getDefaultNumPartitions(TopicName topicName) {
        AutoTopicCreationOverride autoTopicCreationOverride = this.getAutoTopicCreationOverride(topicName);
        if (autoTopicCreationOverride != null) {
            return autoTopicCreationOverride.getDefaultNumPartitions();
        }
        return this.pulsar.getConfiguration().getDefaultNumPartitions();
    }

    private AutoTopicCreationOverride getAutoTopicCreationOverride(TopicName topicName) {
        Optional policies = this.pulsar.getPulsarResources().getNamespaceResources().getPoliciesIfCached(topicName.getNamespaceObject());
        if (policies.isPresent() && ((Policies)policies.get()).autoTopicCreationOverride != null) {
            return ((Policies)policies.get()).autoTopicCreationOverride;
        }
        log.debug("No autoTopicCreateOverride policy found for {}", (Object)topicName);
        return null;
    }

    public boolean isAllowAutoSubscriptionCreation(String topic) {
        TopicName topicName = TopicName.get((String)topic);
        return this.isAllowAutoSubscriptionCreation(topicName);
    }

    public boolean isAllowAutoSubscriptionCreation(TopicName topicName) {
        AutoSubscriptionCreationOverride autoSubscriptionCreationOverride = this.getAutoSubscriptionCreationOverride(topicName);
        if (autoSubscriptionCreationOverride != null) {
            return autoSubscriptionCreationOverride.isAllowAutoSubscriptionCreation();
        }
        return this.pulsar.getConfiguration().isAllowAutoSubscriptionCreation();
    }

    private AutoSubscriptionCreationOverride getAutoSubscriptionCreationOverride(TopicName topicName) {
        Optional policies = this.pulsar.getPulsarResources().getNamespaceResources().getPoliciesIfCached(topicName.getNamespaceObject());
        if (policies.isPresent() && ((Policies)policies.get()).autoSubscriptionCreationOverride != null) {
            return ((Policies)policies.get()).autoSubscriptionCreationOverride;
        }
        log.debug("No autoSubscriptionCreateOverride policy found for {}", (Object)topicName);
        return null;
    }

    public boolean isSystemTopic(String topic) {
        return this.isSystemTopic(TopicName.get((String)topic));
    }

    public boolean isSystemTopic(TopicName topicName) {
        if (topicName.getNamespaceObject().equals((Object)NamespaceName.SYSTEM_NAMESPACE) || topicName.getNamespaceObject().equals((Object)this.pulsar.getHeartbeatNamespaceV1()) || topicName.getNamespaceObject().equals((Object)this.pulsar.getHeartbeatNamespaceV2())) {
            return true;
        }
        TopicName nonePartitionedTopicName = TopicName.get((String)topicName.getPartitionedTopicName());
        if (EventsTopicNames.checkTopicIsEventsNames((TopicName)nonePartitionedTopicName)) {
            return true;
        }
        String localName = nonePartitionedTopicName.getLocalName();
        return StringUtils.endsWith((CharSequence)localName, (CharSequence)"__transaction_pending_ack");
    }

    public Optional<TopicPolicies> getTopicPolicies(TopicName topicName) {
        if (!this.pulsar().getConfig().isTopicLevelPoliciesEnabled()) {
            return Optional.empty();
        }
        try {
            return Optional.ofNullable(this.pulsar.getTopicPoliciesService().getTopicPolicies(topicName));
        }
        catch (BrokerServiceException.TopicPoliciesCacheNotInitException e) {
            log.debug("Topic {} policies have not been initialized yet.", (Object)topicName.getPartitionedTopicName());
            return Optional.empty();
        }
    }

    public CompletableFuture<Void> deleteTopicPolicies(TopicName topicName) {
        if (!this.pulsar().getConfig().isTopicLevelPoliciesEnabled()) {
            return CompletableFuture.completedFuture(null);
        }
        TopicName cloneTopicName = TopicName.get((String)topicName.getPartitionedTopicName());
        return this.pulsar.getTopicPoliciesService().deleteTopicPoliciesAsync(cloneTopicName);
    }

    private CompletableFuture<Void> checkMaxTopicsPerNamespace(TopicName topicName, int numPartitions) {
        return this.pulsar.getPulsarResources().getNamespaceResources().getPoliciesAsync(topicName.getNamespaceObject()).thenCompose(optPolicies -> {
            int maxTopicsPerNamespace = optPolicies.map(p -> p.max_topics_per_namespace).orElse(this.pulsar.getConfig().getMaxTopicsPerNamespace());
            if (maxTopicsPerNamespace > 0 && !this.isSystemTopic(topicName)) {
                return this.pulsar().getPulsarResources().getTopicResources().getExistingPartitions(topicName).thenCompose(topics -> {
                    long topicsCount = topics.stream().filter(t -> !this.isSystemTopic(TopicName.get((String)t))).count();
                    if (topicsCount + (long)numPartitions > (long)maxTopicsPerNamespace) {
                        log.error("Failed to create persistent topic {}, exceed maximum number of topics in namespace", (Object)topicName);
                        return FutureUtil.failedFuture((Throwable)new RestException(Response.Status.PRECONDITION_FAILED, "Exceed maximum number of topics in namespace."));
                    }
                    return CompletableFuture.completedFuture(null);
                });
            }
            return CompletableFuture.completedFuture(null);
        });
    }

    public void setInterceptor(BrokerInterceptor interceptor) {
        this.interceptor = interceptor;
    }

    public Set<BrokerEntryMetadataInterceptor> getBrokerEntryMetadataInterceptors() {
        return this.brokerEntryMetadataInterceptors;
    }

    public boolean isBrokerEntryMetadataEnabled() {
        return !this.brokerEntryMetadataInterceptors.isEmpty();
    }

    public boolean isBrokerPayloadProcessorEnabled() {
        return !this.brokerEntryPayloadProcessors.isEmpty();
    }

    public void pausedConnections(int numberOfConnections) {
        this.pausedConnections.add(numberOfConnections);
    }

    public void resumedConnections(int numberOfConnections) {
        this.pausedConnections.add(-numberOfConnections);
    }

    public long getPausedConnections() {
        return this.pausedConnections.longValue();
    }

    @VisibleForTesting
    public void setPulsarChannelInitializerFactory(PulsarChannelInitializer.Factory factory) {
        this.pulsarChannelInitFactory = factory;
    }

    public PulsarService getPulsar() {
        return this.pulsar;
    }

    public ManagedLedgerFactory getManagedLedgerFactory() {
        return this.managedLedgerFactory;
    }

    public ConcurrentOpenHashMap<String, PulsarAdmin> getClusterAdmins() {
        return this.clusterAdmins;
    }

    public ConcurrentOpenHashMap<String, ConcurrentOpenHashMap<String, ConcurrentOpenHashMap<String, Topic>>> getMultiLayerTopicsMap() {
        return this.multiLayerTopicsMap;
    }

    public EventLoopGroup getAcceptorGroup() {
        return this.acceptorGroup;
    }

    public EventLoopGroup getWorkerGroup() {
        return this.workerGroup;
    }

    public ConcurrentOpenHashMap<TopicName, PersistentOfflineTopicStats> getOfflineTopicStatCache() {
        return this.offlineTopicStatCache;
    }

    public ConcurrentOpenHashMap<String, Consumer<?>> getConfigRegisteredListeners() {
        return this.configRegisteredListeners;
    }

    public ConcurrentLinkedQueue<TopicLoadingContext> getPendingTopicLoadingQueue() {
        return this.pendingTopicLoadingQueue;
    }

    public ScheduledExecutorService getStatsUpdater() {
        return this.statsUpdater;
    }

    public AtomicReference<Semaphore> getTopicLoadRequestSemaphore() {
        return this.topicLoadRequestSemaphore;
    }

    public ObserverGauge getPendingLookupRequests() {
        return this.pendingLookupRequests;
    }

    public ObserverGauge getPendingTopicLoadRequests() {
        return this.pendingTopicLoadRequests;
    }

    public ScheduledExecutorService getInactivityMonitor() {
        return this.inactivityMonitor;
    }

    public ScheduledExecutorService getMessageExpiryMonitor() {
        return this.messageExpiryMonitor;
    }

    public ScheduledExecutorService getCompactionMonitor() {
        return this.compactionMonitor;
    }

    public ScheduledExecutorService getConsumedLedgersMonitor() {
        return this.consumedLedgersMonitor;
    }

    public PublishRateLimiterMonitor getTopicPublishRateLimiterMonitor() {
        return this.topicPublishRateLimiterMonitor;
    }

    public PublishRateLimiterMonitor getBrokerPublishRateLimiterMonitor() {
        return this.brokerPublishRateLimiterMonitor;
    }

    public ScheduledExecutorService getDeduplicationSnapshotMonitor() {
        return this.deduplicationSnapshotMonitor;
    }

    public PublishRateLimiter getBrokerPublishRateLimiter() {
        return this.brokerPublishRateLimiter;
    }

    public DispatchRateLimiter getBrokerDispatchRateLimiter() {
        return this.brokerDispatchRateLimiter;
    }

    public DistributedIdGenerator getProducerNameGenerator() {
        return this.producerNameGenerator;
    }

    public PulsarStats getPulsarStats() {
        return this.pulsarStats;
    }

    public int getMaxUnackedMessages() {
        return this.maxUnackedMessages;
    }

    public int getMaxUnackedMsgsPerDispatcher() {
        return this.maxUnackedMsgsPerDispatcher;
    }

    public ConcurrentOpenHashSet<PersistentDispatcherMultipleConsumers> getBlockedDispatchers() {
        return this.blockedDispatchers;
    }

    public ReadWriteLock getLock() {
        return this.lock;
    }

    public ServerBootstrap getDefaultServerBootstrap() {
        return this.defaultServerBootstrap;
    }

    public List<EventLoopGroup> getProtocolHandlersWorkerGroups() {
        return this.protocolHandlersWorkerGroups;
    }

    public PulsarChannelInitializer.Factory getPulsarChannelInitFactory() {
        return this.pulsarChannelInitFactory;
    }

    public List<Channel> getListenChannels() {
        return this.listenChannels;
    }

    public Channel getListenChannel() {
        return this.listenChannel;
    }

    public Channel getListenChannelTls() {
        return this.listenChannelTls;
    }

    public boolean isPreciseTopicPublishRateLimitingEnable() {
        return this.preciseTopicPublishRateLimitingEnable;
    }

    public BrokerInterceptor getInterceptor() {
        return this.interceptor;
    }

    public ImmutableMap<String, EntryFilterWithClassLoader> getEntryFilters() {
        return this.entryFilters;
    }

    public Set<ManagedLedgerPayloadProcessor> getBrokerEntryPayloadProcessors() {
        return this.brokerEntryPayloadProcessors;
    }

    protected void setNumberOfNamespaceBundles(int numberOfNamespaceBundles) {
        this.numberOfNamespaceBundles = numberOfNamespaceBundles;
    }

    protected void setAuthorizationService(AuthorizationService authorizationService) {
        this.authorizationService = authorizationService;
    }

    protected void setDeduplicationSnapshotMonitor(ScheduledExecutorService deduplicationSnapshotMonitor) {
        this.deduplicationSnapshotMonitor = deduplicationSnapshotMonitor;
    }

    protected void setBrokerPublishRateLimiter(PublishRateLimiter brokerPublishRateLimiter) {
        this.brokerPublishRateLimiter = brokerPublishRateLimiter;
    }

    protected void setBrokerDispatchRateLimiter(DispatchRateLimiter brokerDispatchRateLimiter) {
        this.brokerDispatchRateLimiter = brokerDispatchRateLimiter;
    }

    protected void setProducerNameGenerator(DistributedIdGenerator producerNameGenerator) {
        this.producerNameGenerator = producerNameGenerator;
    }

    protected void setPulsarChannelInitFactory(PulsarChannelInitializer.Factory pulsarChannelInitFactory) {
        this.pulsarChannelInitFactory = pulsarChannelInitFactory;
    }

    protected void setListenChannel(Channel listenChannel) {
        this.listenChannel = listenChannel;
    }

    protected void setListenChannelTls(Channel listenChannelTls) {
        this.listenChannelTls = listenChannelTls;
    }

    protected void setPreciseTopicPublishRateLimitingEnable(boolean preciseTopicPublishRateLimitingEnable) {
        this.preciseTopicPublishRateLimitingEnable = preciseTopicPublishRateLimitingEnable;
    }

    protected void setEntryFilters(ImmutableMap<String, EntryFilterWithClassLoader> entryFilters) {
        this.entryFilters = entryFilters;
    }

    protected void setBrokerEntryMetadataInterceptors(Set<BrokerEntryMetadataInterceptor> brokerEntryMetadataInterceptors) {
        this.brokerEntryMetadataInterceptors = brokerEntryMetadataInterceptors;
    }

    protected void setBrokerEntryPayloadProcessors(Set<ManagedLedgerPayloadProcessor> brokerEntryPayloadProcessors) {
        this.brokerEntryPayloadProcessors = brokerEntryPayloadProcessors;
    }

    public ConcurrentOpenHashMap<String, ConcurrentOpenHashSet<Integer>> getOwningTopics() {
        return this.owningTopics;
    }

    public ScheduledExecutorService getBacklogQuotaChecker() {
        return this.backlogQuotaChecker;
    }

    public BundlesQuotas getBundlesQuotas() {
        return this.bundlesQuotas;
    }

    private static /* synthetic */ void lambda$unloadServiceUnit$80(java.util.concurrent.ScheduledFuture taskTimeout, Integer r, Throwable ex) {
        taskTimeout.cancel(true);
    }

    private static class TopicLoadingContext {
        private final String topic;
        private final CompletableFuture<Optional<Topic>> topicFuture;
        private final Map<String, String> properties;

        public TopicLoadingContext(String topic, CompletableFuture<Optional<Topic>> topicFuture, Map<String, String> properties) {
            this.topic = topic;
            this.topicFuture = topicFuture;
            this.properties = properties;
        }

        public String getTopic() {
            return this.topic;
        }

        public CompletableFuture<Optional<Topic>> getTopicFuture() {
            return this.topicFuture;
        }

        public Map<String, String> getProperties() {
            return this.properties;
        }
    }

    private static class ConfigField {
        final Field field;
        Predicate<String> validator;

        public ConfigField(Field field) {
            this.field = field;
        }
    }

    protected static class PublishRateLimiterMonitor {
        private final String name;
        private ScheduledExecutorService scheduler = null;
        private long tickTimeMs = 0L;
        private Runnable refreshTask;

        public PublishRateLimiterMonitor(String name) {
            this.name = name;
        }

        synchronized void startOrUpdate(long tickTimeMs, Runnable checkTask, Runnable refreshTask) {
            if (this.scheduler != null) {
                if (this.tickTimeMs == tickTimeMs) {
                    return;
                }
                this.stop();
            }
            this.scheduler = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new DefaultThreadFactory(this.name));
            this.scheduler.scheduleAtFixedRate((Runnable)SafeRun.safeRun((Runnable)checkTask), tickTimeMs, tickTimeMs, TimeUnit.MILLISECONDS);
            this.scheduler.scheduleAtFixedRate((Runnable)SafeRun.safeRun((Runnable)refreshTask), 1L, 1L, TimeUnit.SECONDS);
            this.tickTimeMs = tickTimeMs;
            this.refreshTask = refreshTask;
        }

        synchronized void stop() {
            if (this.scheduler != null) {
                this.scheduler.shutdownNow();
                this.refreshTask.run();
                this.scheduler = null;
                this.tickTimeMs = 0L;
            }
        }

        @VisibleForTesting
        protected synchronized long getTickTimeMs() {
            return this.tickTimeMs;
        }
    }
}

