/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.namespace;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.common.naming.NamespaceBundle;
import org.apache.pulsar.common.util.FutureUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OwnedBundle {
    private static final Logger LOG = LoggerFactory.getLogger(OwnedBundle.class);
    private final NamespaceBundle bundle;
    private final ReentrantReadWriteLock nsLock = new ReentrantReadWriteLock();
    private static final int FALSE = 0;
    private static final int TRUE = 1;
    private static final AtomicIntegerFieldUpdater<OwnedBundle> IS_ACTIVE_UPDATER = AtomicIntegerFieldUpdater.newUpdater(OwnedBundle.class, "isActive");
    private volatile int isActive = 1;

    public OwnedBundle(NamespaceBundle suName) {
        this.bundle = suName;
        IS_ACTIVE_UPDATER.set(this, 1);
    }

    public OwnedBundle(NamespaceBundle suName, boolean active) {
        this.bundle = suName;
        IS_ACTIVE_UPDATER.set(this, active ? 1 : 0);
    }

    public NamespaceBundle getNamespaceBundle() {
        return this.bundle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CompletableFuture<Void> handleUnloadRequest(PulsarService pulsar, long timeout, TimeUnit timeoutUnit) {
        long unloadBundleStartTime = System.nanoTime();
        try {
            while (!this.nsLock.writeLock().tryLock(1L, TimeUnit.SECONDS)) {
                LOG.warn("Contention on OwnedBundle rw lock. Retrying to acquire lock write lock");
            }
            try {
                if (!IS_ACTIVE_UPDATER.compareAndSet(this, 1, 0)) {
                    CompletableFuture completableFuture = FutureUtil.failedFuture((Throwable)new IllegalStateException("Namespace is not active. ns:" + this.bundle + "; state:" + IS_ACTIVE_UPDATER.get(this)));
                    return completableFuture;
                }
            }
            finally {
                this.nsLock.writeLock().unlock();
            }
        }
        catch (InterruptedException e) {
            return FutureUtil.failedFuture((Throwable)e);
        }
        AtomicInteger unloadedTopics = new AtomicInteger();
        LOG.info("Disabling ownership: {}", (Object)this.bundle);
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)pulsar.getNamespaceService().getOwnershipCache().updateBundleState(this.bundle, false).thenCompose(v -> pulsar.getBrokerService().unloadServiceUnit(this.bundle, true, timeout, timeoutUnit))).handle((numUnloadedTopics, ex) -> {
            if (ex != null) {
                LOG.error("Failed to close topics under namespace {}", (Object)this.bundle.toString(), ex);
            } else {
                unloadedTopics.set((int)numUnloadedTopics);
            }
            return null;
        })).thenCompose(v -> pulsar.getNamespaceService().getOwnershipCache().removeOwnership(this.bundle))).whenComplete((ignored, ex) -> {
            double unloadBundleTime = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - unloadBundleStartTime);
            LOG.info("Unloading {} namespace-bundle with {} topics completed in {} ms", new Object[]{this.bundle, unloadedTopics, unloadBundleTime, ex});
        });
    }

    public boolean isActive() {
        return IS_ACTIVE_UPDATER.get(this) == 1;
    }

    public void setActive(boolean active) {
        IS_ACTIVE_UPDATER.set(this, active ? 1 : 0);
    }
}

