/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.broker.service.BrokerServiceException;
import org.apache.pulsar.broker.service.TopicPolicyListener;
import org.apache.pulsar.common.naming.NamespaceBundle;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.policies.data.TopicPolicies;
import org.apache.pulsar.common.util.FutureUtil;

public interface TopicPoliciesService {
    public static final TopicPoliciesService DISABLED = new TopicPoliciesServiceDisabled();

    public CompletableFuture<Void> updateTopicPoliciesAsync(TopicName var1, TopicPolicies var2);

    public TopicPolicies getTopicPolicies(TopicName var1) throws BrokerServiceException.TopicPoliciesCacheNotInitException;

    public CompletableFuture<TopicPolicies> getTopicPoliciesBypassCacheAsync(TopicName var1);

    public CompletableFuture<Void> addOwnedNamespaceBundleAsync(NamespaceBundle var1);

    public CompletableFuture<Void> removeOwnedNamespaceBundleAsync(NamespaceBundle var1);

    public void start();

    public boolean cacheIsInitialized(TopicName var1);

    public void registerListener(TopicName var1, TopicPolicyListener<TopicPolicies> var2);

    public void unregisterListener(TopicName var1, TopicPolicyListener<TopicPolicies> var2);

    public static class TopicPoliciesServiceDisabled
    implements TopicPoliciesService {
        @Override
        public CompletableFuture<Void> updateTopicPoliciesAsync(TopicName topicName, TopicPolicies policies) {
            return FutureUtil.failedFuture((Throwable)new UnsupportedOperationException("Topic policies service is disabled."));
        }

        @Override
        public TopicPolicies getTopicPolicies(TopicName topicName) throws BrokerServiceException.TopicPoliciesCacheNotInitException {
            return null;
        }

        @Override
        public CompletableFuture<TopicPolicies> getTopicPoliciesBypassCacheAsync(TopicName topicName) {
            return CompletableFuture.completedFuture(null);
        }

        @Override
        public CompletableFuture<Void> addOwnedNamespaceBundleAsync(NamespaceBundle namespaceBundle) {
            return CompletableFuture.completedFuture(null);
        }

        @Override
        public CompletableFuture<Void> removeOwnedNamespaceBundleAsync(NamespaceBundle namespaceBundle) {
            return CompletableFuture.completedFuture(null);
        }

        @Override
        public void start() {
        }

        @Override
        public boolean cacheIsInitialized(TopicName topicName) {
            return false;
        }

        @Override
        public void registerListener(TopicName topicName, TopicPolicyListener<TopicPolicies> listener) {
        }

        @Override
        public void unregisterListener(TopicName topicName, TopicPolicyListener<TopicPolicies> listener) {
        }
    }
}

