/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service.persistent;

import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.bookkeeper.mledger.impl.PositionImpl;
import org.apache.pulsar.common.api.proto.PulsarMarkers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicatedSubscriptionSnapshotCache {
    private static final Logger log = LoggerFactory.getLogger(ReplicatedSubscriptionSnapshotCache.class);
    private final String subscription;
    private final NavigableMap<PositionImpl, PulsarMarkers.ReplicatedSubscriptionsSnapshot> snapshots;
    private final int maxSnapshotToCache;

    public ReplicatedSubscriptionSnapshotCache(String subscription, int maxSnapshotToCache) {
        this.subscription = subscription;
        this.snapshots = new TreeMap<PositionImpl, PulsarMarkers.ReplicatedSubscriptionsSnapshot>();
        this.maxSnapshotToCache = maxSnapshotToCache;
    }

    public synchronized void addNewSnapshot(PulsarMarkers.ReplicatedSubscriptionsSnapshot snapshot) {
        PulsarMarkers.MessageIdData msgId = snapshot.getLocalMessageId();
        PositionImpl position = new PositionImpl(msgId.getLedgerId(), msgId.getEntryId());
        if (log.isDebugEnabled()) {
            log.debug("[{}] Added new replicated-subscription snapshot at {} -- {}", new Object[]{this.subscription, position, snapshot.getSnapshotId()});
        }
        this.snapshots.put(position, snapshot);
        while (this.snapshots.size() > this.maxSnapshotToCache) {
            this.snapshots.pollFirstEntry();
        }
    }

    public synchronized PulsarMarkers.ReplicatedSubscriptionsSnapshot advancedMarkDeletePosition(PositionImpl pos) {
        PositionImpl first;
        PulsarMarkers.ReplicatedSubscriptionsSnapshot snapshot = null;
        while (!this.snapshots.isEmpty() && (first = (PositionImpl)this.snapshots.firstKey()).compareTo(pos) <= 0) {
            snapshot = this.snapshots.pollFirstEntry().getValue();
        }
        if (log.isDebugEnabled()) {
            if (snapshot != null) {
                log.debug("[{}] Advanced mark-delete position to {} -- found snapshot {} at {}:{}", new Object[]{this.subscription, pos, snapshot.getSnapshotId(), snapshot.getLocalMessageId().getLedgerId(), snapshot.getLocalMessageId().getEntryId()});
            } else {
                log.debug("[{}] Advanced mark-delete position to {} -- snapshot not found", (Object)this.subscription, (Object)pos);
            }
        }
        return snapshot;
    }
}

