/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.stats.prometheus.metrics;

import com.google.common.annotations.VisibleForTesting;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.prometheus.client.Collector;
import java.io.IOException;
import java.io.Writer;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.stats.CachingStatsProvider;
import org.apache.bookkeeper.stats.Counter;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.stats.StatsProvider;
import org.apache.bookkeeper.stats.prometheus.LongAdderCounter;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.apache.pulsar.broker.stats.prometheus.metrics.DataSketchesOpStatsLogger;
import org.apache.pulsar.broker.stats.prometheus.metrics.PrometheusStatsLogger;
import org.apache.pulsar.broker.stats.prometheus.metrics.PrometheusTextFormatUtil;
import org.apache.pulsar.broker.stats.prometheus.metrics.SimpleGauge;

public class PrometheusMetricsProvider
implements StatsProvider {
    private ScheduledExecutorService executor;
    public static final String PROMETHEUS_STATS_LATENCY_ROLLOVER_SECONDS = "prometheusStatsLatencyRolloverSeconds";
    public static final int DEFAULT_PROMETHEUS_STATS_LATENCY_ROLLOVER_SECONDS = 60;
    public static final String CLUSTER_NAME = "cluster";
    public static final String DEFAULT_CLUSTER_NAME = "pulsar";
    private String cluster;
    private final CachingStatsProvider cachingStatsProvider;
    final ConcurrentMap<String, LongAdderCounter> counters = new ConcurrentSkipListMap<String, LongAdderCounter>();
    final ConcurrentMap<String, SimpleGauge<? extends Number>> gauges = new ConcurrentSkipListMap<String, SimpleGauge<? extends Number>>();
    final ConcurrentMap<String, DataSketchesOpStatsLogger> opStats = new ConcurrentSkipListMap<String, DataSketchesOpStatsLogger>();

    public PrometheusMetricsProvider() {
        this.cachingStatsProvider = new CachingStatsProvider(new StatsProvider(){

            public void start(Configuration conf) {
            }

            public void stop() {
            }

            public StatsLogger getStatsLogger(String scope) {
                return new PrometheusStatsLogger(PrometheusMetricsProvider.this, scope);
            }

            public String getStatsName(String ... statsComponents) {
                if (statsComponents.length == 0) {
                    return "";
                }
                String completeName = statsComponents[0].isEmpty() ? StringUtils.join((Object[])statsComponents, (char)'_', (int)1, (int)statsComponents.length) : StringUtils.join((Object[])statsComponents, (char)'_');
                return Collector.sanitizeMetricName((String)completeName);
            }
        });
    }

    public void start(Configuration conf) {
        this.executor = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new DefaultThreadFactory("metrics"));
        int latencyRolloverSeconds = conf.getInt(PROMETHEUS_STATS_LATENCY_ROLLOVER_SECONDS, 60);
        this.cluster = conf.getString(CLUSTER_NAME, DEFAULT_CLUSTER_NAME);
        this.executor.scheduleAtFixedRate(() -> this.rotateLatencyCollection(), 1L, latencyRolloverSeconds, TimeUnit.SECONDS);
    }

    public void stop() {
        this.executor.shutdownNow();
    }

    public StatsLogger getStatsLogger(String scope) {
        return this.cachingStatsProvider.getStatsLogger(scope);
    }

    public void writeAllMetrics(Writer writer) throws IOException {
        this.gauges.forEach((name, gauge) -> PrometheusTextFormatUtil.writeGauge(writer, name, this.cluster, gauge));
        this.counters.forEach((name, counter) -> PrometheusTextFormatUtil.writeCounter(writer, name, this.cluster, (Counter)counter));
        this.opStats.forEach((name, opStatLogger) -> PrometheusTextFormatUtil.writeOpStat(writer, name, this.cluster, opStatLogger));
    }

    public String getStatsName(String ... statsComponents) {
        return this.cachingStatsProvider.getStatsName(statsComponents);
    }

    @VisibleForTesting
    void rotateLatencyCollection() {
        this.opStats.forEach((name, metric) -> metric.rotateLatencyCollection());
    }
}

