/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.admin;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.GenericType;
import org.apache.commons.lang.mutable.MutableBoolean;
import org.apache.pulsar.broker.auth.MockedPulsarServiceBaseTest;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.admin.internal.JacksonConfigurator;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.common.policies.data.AuthAction;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.pulsar.common.policies.data.TenantInfo;
import org.apache.pulsar.common.tls.NoopHostnameVerifier;
import org.apache.pulsar.common.util.SecurityUtility;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"broker"})
public class AdminApiTlsAuthTest
extends MockedPulsarServiceBaseTest {
    private static final Logger log = LoggerFactory.getLogger(AdminApiTlsAuthTest.class);

    private static String getTLSFile(String name) {
        return String.format("./src/test/resources/authentication/tls-http/%s.pem", name);
    }

    @Override
    @BeforeMethod
    public void setup() throws Exception {
        this.conf.setLoadBalancerEnabled(true);
        this.conf.setBrokerServicePortTls(Optional.of(0));
        this.conf.setWebServicePortTls(Optional.of(0));
        this.conf.setTlsCertificateFilePath(AdminApiTlsAuthTest.getTLSFile("broker.cert"));
        this.conf.setTlsKeyFilePath(AdminApiTlsAuthTest.getTLSFile("broker.key-pk8"));
        this.conf.setTlsTrustCertsFilePath(AdminApiTlsAuthTest.getTLSFile("ca.cert"));
        this.conf.setAuthenticationEnabled(true);
        this.conf.setAuthenticationProviders((Set)ImmutableSet.of((Object)"org.apache.pulsar.broker.authentication.AuthenticationProviderTls"));
        this.conf.setSuperUserRoles((Set)ImmutableSet.of((Object)"admin", (Object)"superproxy"));
        this.conf.setProxyRoles((Set)ImmutableSet.of((Object)"proxy", (Object)"superproxy"));
        this.conf.setAuthorizationEnabled(true);
        this.conf.setBrokerClientAuthenticationPlugin("org.apache.pulsar.client.impl.auth.AuthenticationTls");
        this.conf.setBrokerClientAuthenticationParameters(String.format("tlsCertFile:%s,tlsKeyFile:%s", AdminApiTlsAuthTest.getTLSFile("admin.cert"), AdminApiTlsAuthTest.getTLSFile("admin.key-pk8")));
        this.conf.setBrokerClientTrustCertsFilePath(AdminApiTlsAuthTest.getTLSFile("ca.cert"));
        this.conf.setBrokerClientTlsEnabled(true);
        this.conf.setNumExecutorThreadPoolSize(5);
        super.internalSetup();
        PulsarAdmin admin = this.buildAdminClient("admin");
        admin.clusters().createCluster("test", new ClusterData(this.brokerUrl.toString()));
        admin.close();
    }

    @Override
    @AfterMethod(alwaysRun=true)
    public void cleanup() throws Exception {
        super.internalCleanup();
    }

    WebTarget buildWebClient(String user) throws Exception {
        ClientConfig httpConfig = new ClientConfig();
        httpConfig.property("jersey.config.client.followRedirects", (Object)true);
        httpConfig.property("jersey.config.client.async.threadPoolSize", (Object)8);
        httpConfig.register(MultiPartFeature.class);
        ClientBuilder clientBuilder = (ClientBuilder)((ClientBuilder)ClientBuilder.newBuilder().withConfig((Configuration)httpConfig).register(JacksonConfigurator.class)).register(JacksonFeature.class);
        Certificate[] trustCertificates = SecurityUtility.loadCertificatesFromPemFile((String)AdminApiTlsAuthTest.getTLSFile("ca.cert"));
        SSLContext sslCtx = SecurityUtility.createSslContext((boolean)false, (Certificate[])trustCertificates, (Certificate[])SecurityUtility.loadCertificatesFromPemFile((String)AdminApiTlsAuthTest.getTLSFile(user + ".cert")), (PrivateKey)SecurityUtility.loadPrivateKeyFromPemFile((String)AdminApiTlsAuthTest.getTLSFile(user + ".key-pk8")));
        clientBuilder.sslContext(sslCtx).hostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        Client client = clientBuilder.build();
        return client.target(this.brokerUrlTls.toString());
    }

    PulsarAdmin buildAdminClient(String user) throws Exception {
        return PulsarAdmin.builder().allowTlsInsecureConnection(false).enableTlsHostnameVerification(false).serviceHttpUrl(this.brokerUrlTls.toString()).authentication("org.apache.pulsar.client.impl.auth.AuthenticationTls", String.format("tlsCertFile:%s,tlsKeyFile:%s", AdminApiTlsAuthTest.getTLSFile(user + ".cert"), AdminApiTlsAuthTest.getTLSFile(user + ".key-pk8"))).tlsTrustCertsFilePath(AdminApiTlsAuthTest.getTLSFile("ca.cert")).build();
    }

    PulsarClient buildClient(String user) throws Exception {
        return PulsarClient.builder().serviceUrl(this.pulsar.getBrokerServiceUrlTls()).enableTlsHostnameVerification(false).authentication("org.apache.pulsar.client.impl.auth.AuthenticationTls", String.format("tlsCertFile:%s,tlsKeyFile:%s", AdminApiTlsAuthTest.getTLSFile(user + ".cert"), AdminApiTlsAuthTest.getTLSFile(user + ".key-pk8"))).tlsTrustCertsFilePath(AdminApiTlsAuthTest.getTLSFile("ca.cert")).build();
    }

    @Test
    public void testSuperUserCanListTenants() throws Exception {
        try (PulsarAdmin admin = this.buildAdminClient("admin");){
            admin.tenants().createTenant("tenant1", new TenantInfo((Set)ImmutableSet.of((Object)"foobar"), (Set)ImmutableSet.of((Object)"test")));
            Assert.assertEquals((Collection)ImmutableSet.of((Object)"tenant1"), (Collection)admin.tenants().getTenants());
        }
    }

    @Test
    public void testProxyRoleCantListTenants() throws Exception {
        try (PulsarAdmin admin = this.buildAdminClient("admin");){
            admin.tenants().createTenant("tenant1", new TenantInfo((Set)ImmutableSet.of((Object)"foobar"), (Set)ImmutableSet.of((Object)"test")));
        }
        try {
            admin = this.buildAdminClient("proxy");
            var2_3 = null;
            try {
                admin.tenants().getTenants();
                Assert.fail((String)"Shouldn't be able to list tenants");
            }
            catch (Throwable throwable) {
                var2_3 = throwable;
                throw throwable;
            }
            finally {
                if (admin != null) {
                    if (var2_3 != null) {
                        try {
                            admin.close();
                        }
                        catch (Throwable throwable) {
                            var2_3.addSuppressed(throwable);
                        }
                    } else {
                        admin.close();
                    }
                }
            }
        }
        catch (PulsarAdminException.NotAuthorizedException notAuthorizedException) {
            // empty catch block
        }
    }

    @Test
    public void testProxyRoleCantListNamespacesEvenWithAccess() throws Exception {
        try (PulsarAdmin admin = this.buildAdminClient("admin");){
            admin.tenants().createTenant("tenant1", new TenantInfo((Set)ImmutableSet.of((Object)"proxy"), (Set)ImmutableSet.of((Object)"test")));
            admin.namespaces().createNamespace("tenant1/ns1");
        }
        try {
            admin = this.buildAdminClient("proxy");
            var2_3 = null;
            try {
                admin.namespaces().getNamespaces("tenant1");
                Assert.fail((String)"Shouldn't be able to list namespaces");
            }
            catch (Throwable throwable) {
                var2_3 = throwable;
                throw throwable;
            }
            finally {
                if (admin != null) {
                    if (var2_3 != null) {
                        try {
                            admin.close();
                        }
                        catch (Throwable throwable) {
                            var2_3.addSuppressed(throwable);
                        }
                    } else {
                        admin.close();
                    }
                }
            }
        }
        catch (PulsarAdminException.NotAuthorizedException notAuthorizedException) {
            // empty catch block
        }
    }

    @Test
    public void testAuthorizedUserAsOriginalPrincipal() throws Exception {
        try (PulsarAdmin admin = this.buildAdminClient("admin");){
            admin.tenants().createTenant("tenant1", new TenantInfo((Set)ImmutableSet.of((Object)"proxy", (Object)"user1"), (Set)ImmutableSet.of((Object)"test")));
            admin.namespaces().createNamespace("tenant1/ns1");
        }
        WebTarget root = this.buildWebClient("proxy");
        Assert.assertEquals((Collection)ImmutableSet.of((Object)"tenant1/ns1"), (Collection)((Collection)root.path("/admin/v2/namespaces").path("tenant1").request(new String[]{"application/json"}).header("X-Original-Principal", (Object)"user1").get((GenericType)new GenericType<List<String>>(){})));
    }

    @Test
    public void testUnauthorizedUserAsOriginalPrincipal() throws Exception {
        try (PulsarAdmin admin = this.buildAdminClient("admin");){
            admin.tenants().createTenant("tenant1", new TenantInfo((Set)ImmutableSet.of((Object)"proxy", (Object)"user1"), (Set)ImmutableSet.of((Object)"test")));
            admin.namespaces().createNamespace("tenant1/ns1");
        }
        WebTarget root = this.buildWebClient("proxy");
        try {
            root.path("/admin/v2/namespaces").path("tenant1").request(new String[]{"application/json"}).header("X-Original-Principal", (Object)"user2").get((GenericType)new GenericType<List<String>>(){});
            Assert.fail((String)"user2 should not be authorized");
        }
        catch (NotAuthorizedException notAuthorizedException) {
            // empty catch block
        }
    }

    @Test
    public void testAuthorizedUserAsOriginalPrincipalButProxyNotAuthorized() throws Exception {
        try (PulsarAdmin admin = this.buildAdminClient("admin");){
            admin.tenants().createTenant("tenant1", new TenantInfo((Set)ImmutableSet.of((Object)"user1"), (Set)ImmutableSet.of((Object)"test")));
            admin.namespaces().createNamespace("tenant1/ns1");
        }
        WebTarget root = this.buildWebClient("proxy");
        try {
            root.path("/admin/v2/namespaces").path("tenant1").request(new String[]{"application/json"}).header("X-Original-Principal", (Object)"user1").get((GenericType)new GenericType<List<String>>(){});
            Assert.fail((String)"Shouldn't be able to list namespaces");
        }
        catch (NotAuthorizedException notAuthorizedException) {
            // empty catch block
        }
    }

    @Test
    public void testAuthorizedUserAsOriginalPrincipalProxyIsSuperUser() throws Exception {
        try (PulsarAdmin admin = this.buildAdminClient("admin");){
            admin.tenants().createTenant("tenant1", new TenantInfo((Set)ImmutableSet.of((Object)"user1"), (Set)ImmutableSet.of((Object)"test")));
            admin.namespaces().createNamespace("tenant1/ns1");
        }
        WebTarget root = this.buildWebClient("superproxy");
        Assert.assertEquals((Collection)ImmutableSet.of((Object)"tenant1/ns1"), (Collection)((Collection)root.path("/admin/v2/namespaces").path("tenant1").request(new String[]{"application/json"}).header("X-Original-Principal", (Object)"user1").get((GenericType)new GenericType<List<String>>(){})));
    }

    @Test
    public void testUnauthorizedUserAsOriginalPrincipalProxyIsSuperUser() throws Exception {
        try (PulsarAdmin admin = this.buildAdminClient("admin");){
            admin.tenants().createTenant("tenant1", new TenantInfo((Set)ImmutableSet.of((Object)"user1"), (Set)ImmutableSet.of((Object)"test")));
            admin.namespaces().createNamespace("tenant1/ns1");
        }
        WebTarget root = this.buildWebClient("superproxy");
        try {
            root.path("/admin/v2/namespaces").path("tenant1").request(new String[]{"application/json"}).header("X-Original-Principal", (Object)"user2").get((GenericType)new GenericType<List<String>>(){});
            Assert.fail((String)"user2 should not be authorized");
        }
        catch (NotAuthorizedException notAuthorizedException) {
            // empty catch block
        }
    }

    @Test
    public void testProxyUserViaProxy() throws Exception {
        try (PulsarAdmin admin = this.buildAdminClient("admin");){
            admin.tenants().createTenant("tenant1", new TenantInfo((Set)ImmutableSet.of((Object)"proxy"), (Set)ImmutableSet.of((Object)"test")));
            admin.namespaces().createNamespace("tenant1/ns1");
        }
        WebTarget root = this.buildWebClient("superproxy");
        try {
            root.path("/admin/v2/namespaces").path("tenant1").request(new String[]{"application/json"}).header("X-Original-Principal", (Object)"proxy").get((GenericType)new GenericType<List<String>>(){});
            Assert.fail((String)"proxy should not be authorized");
        }
        catch (NotAuthorizedException notAuthorizedException) {
            // empty catch block
        }
    }

    @Test
    public void testSuperProxyUserAndAdminCanListTenants() throws Exception {
        try (PulsarAdmin admin = this.buildAdminClient("admin");){
            admin.tenants().createTenant("tenant1", new TenantInfo((Set)ImmutableSet.of((Object)"user1"), (Set)ImmutableSet.of((Object)"test")));
        }
        WebTarget root = this.buildWebClient("superproxy");
        Assert.assertEquals((Collection)ImmutableSet.of((Object)"tenant1"), (Collection)((Collection)root.path("/admin/v2/tenants").request(new String[]{"application/json"}).header("X-Original-Principal", (Object)"admin").get((GenericType)new GenericType<List<String>>(){})));
    }

    @Test
    public void testSuperProxyUserAndNonAdminCannotListTenants() throws Exception {
        try (PulsarAdmin admin = this.buildAdminClient("admin");){
            admin.tenants().createTenant("tenant1", new TenantInfo((Set)ImmutableSet.of((Object)"proxy"), (Set)ImmutableSet.of((Object)"test")));
        }
        WebTarget root = this.buildWebClient("superproxy");
        try {
            root.path("/admin/v2/tenants").request(new String[]{"application/json"}).header("X-Original-Principal", (Object)"user1").get((GenericType)new GenericType<List<String>>(){});
            Assert.fail((String)"user1 should not be authorized");
        }
        catch (NotAuthorizedException notAuthorizedException) {
            // empty catch block
        }
    }

    @Test
    public void testProxyCannotSetOriginalPrincipalAsEmpty() throws Exception {
        try (PulsarAdmin admin = this.buildAdminClient("admin");){
            admin.tenants().createTenant("tenant1", new TenantInfo((Set)ImmutableSet.of((Object)"user1"), (Set)ImmutableSet.of((Object)"test")));
            admin.namespaces().createNamespace("tenant1/ns1");
        }
        WebTarget root = this.buildWebClient("proxy");
        try {
            root.path("/admin/v2/namespaces").path("tenant1").request(new String[]{"application/json"}).header("X-Original-Principal", (Object)"").get((GenericType)new GenericType<List<String>>(){});
            Assert.fail((String)"Proxy shouldn't be able to set original principal.");
        }
        catch (NotAuthorizedException notAuthorizedException) {
            // empty catch block
        }
    }

    @Test
    public void testDeleteNamespace() throws Exception {
        try (PulsarAdmin admin = this.buildAdminClient("admin");){
            log.info("Creating tenant");
            admin.tenants().createTenant("tenant1", new TenantInfo((Set)ImmutableSet.of((Object)"admin"), (Set)ImmutableSet.of((Object)"test")));
            log.info("Creating namespace, and granting perms to user1");
            admin.namespaces().createNamespace("tenant1/ns1", (Set)ImmutableSet.of((Object)"test"));
            admin.namespaces().grantPermissionOnNamespace("tenant1/ns1", "user1", (Set)ImmutableSet.of((Object)AuthAction.produce));
            log.info("user1 produces some messages");
            try (PulsarClient client = this.buildClient("user1");
                 Producer producer = client.newProducer(Schema.STRING).topic("tenant1/ns1/foobar").create();){
                producer.send((Object)"foobar");
            }
            log.info("Deleting the topic");
            admin.topics().delete("tenant1/ns1/foobar", true);
            log.info("Deleting namespace");
            admin.namespaces().deleteNamespace("tenant1/ns1");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCertRefreshForPulsarAdmin() throws Exception {
        String adminUser = "admin";
        String user2 = "user1";
        File keyFile = new File(AdminApiTlsAuthTest.getTLSFile("temp.key-pk8"));
        Path keyFilePath = Paths.get(keyFile.getAbsolutePath(), new String[0]);
        int autoCertRefreshTimeSec = 1;
        try {
            Files.copy(Paths.get(AdminApiTlsAuthTest.getTLSFile(user2 + ".key-pk8"), new String[0]), keyFilePath, StandardCopyOption.REPLACE_EXISTING);
            PulsarAdmin admin = PulsarAdmin.builder().allowTlsInsecureConnection(false).enableTlsHostnameVerification(false).serviceHttpUrl(this.brokerUrlTls.toString()).autoCertRefreshTime(1, TimeUnit.SECONDS).authentication("org.apache.pulsar.client.impl.auth.AuthenticationTls", String.format("tlsCertFile:%s,tlsKeyFile:%s", AdminApiTlsAuthTest.getTLSFile(adminUser + ".cert"), keyFile)).tlsTrustCertsFilePath(AdminApiTlsAuthTest.getTLSFile("ca.cert")).build();
            try {
                admin.tenants().createTenant("tenantX", new TenantInfo((Set)ImmutableSet.of((Object)"foobar"), (Set)ImmutableSet.of((Object)"test")));
                Assert.fail((String)"should have failed due to invalid key file");
            }
            catch (Exception exception) {
                // empty catch block
            }
            Files.delete(keyFile.toPath());
            Thread.sleep(2 * autoCertRefreshTimeSec * 1000);
            Files.copy(Paths.get(AdminApiTlsAuthTest.getTLSFile(adminUser + ".key-pk8"), new String[0]), keyFilePath, new CopyOption[0]);
            MutableBoolean success = new MutableBoolean(false);
            AdminApiTlsAuthTest.retryStrategically(test -> {
                try {
                    admin.tenants().createTenant("tenantX", new TenantInfo((Set)ImmutableSet.of((Object)"foobar"), (Set)ImmutableSet.of((Object)"test")));
                    success.setValue(true);
                    return true;
                }
                catch (Exception e) {
                    return false;
                }
            }, 5, 1000L);
            Assert.assertTrue((boolean)success.booleanValue());
            Assert.assertEquals((Collection)ImmutableSet.of((Object)"tenantX"), (Collection)admin.tenants().getTenants());
            admin.close();
        }
        finally {
            Files.delete(keyFile.toPath());
        }
    }
}

