/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.admin;

import com.google.common.collect.ImmutableSet;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.auth.MockedPulsarServiceBaseTest;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.common.policies.data.BundlesData;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.pulsar.common.policies.data.Policies;
import org.apache.pulsar.common.policies.data.TenantInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"broker"})
public class BrokerAdminClientTlsAuthTest
extends MockedPulsarServiceBaseTest {
    private static final Logger log = LoggerFactory.getLogger(BrokerAdminClientTlsAuthTest.class);
    protected String methodName;

    @BeforeMethod
    public void beforeMethod(Method m) throws Exception {
        this.methodName = m.getName();
    }

    private static String getTLSFile(String name) {
        return String.format("./src/test/resources/authentication/tls-http/%s.pem", name);
    }

    @Override
    @BeforeMethod
    public void setup() throws Exception {
        this.conf.setBrokerServicePortTls(Optional.of(0));
        this.conf.setWebServicePortTls(Optional.of(0));
        this.buildConf(this.conf);
        super.internalSetup();
    }

    private void buildConf(ServiceConfiguration conf) {
        conf.setLoadBalancerEnabled(true);
        conf.setTlsCertificateFilePath(BrokerAdminClientTlsAuthTest.getTLSFile("broker.cert"));
        conf.setTlsKeyFilePath(BrokerAdminClientTlsAuthTest.getTLSFile("broker.key-pk8"));
        conf.setTlsTrustCertsFilePath(BrokerAdminClientTlsAuthTest.getTLSFile("ca.cert"));
        conf.setAuthenticationEnabled(true);
        conf.setSuperUserRoles((Set)ImmutableSet.of((Object)"superproxy", (Object)"broker.pulsar.apache.org"));
        conf.setAuthenticationProviders((Set)ImmutableSet.of((Object)"org.apache.pulsar.broker.authentication.AuthenticationProviderTls"));
        conf.setAuthorizationEnabled(true);
        conf.setBrokerClientTlsEnabled(true);
        String str = String.format("tlsCertFile:%s,tlsKeyFile:%s", BrokerAdminClientTlsAuthTest.getTLSFile("broker.cert"), BrokerAdminClientTlsAuthTest.getTLSFile("broker.key-pk8"));
        conf.setBrokerClientAuthenticationParameters(str);
        conf.setBrokerClientAuthenticationPlugin("org.apache.pulsar.client.impl.auth.AuthenticationTls");
        conf.setBrokerClientTrustCertsFilePath(BrokerAdminClientTlsAuthTest.getTLSFile("ca.cert"));
        conf.setTlsAllowInsecureConnection(true);
        conf.setNumExecutorThreadPoolSize(5);
    }

    @Override
    @AfterMethod(alwaysRun=true)
    public void cleanup() throws Exception {
        super.internalCleanup();
    }

    PulsarAdmin buildAdminClient(String user) throws Exception {
        return PulsarAdmin.builder().allowTlsInsecureConnection(false).enableTlsHostnameVerification(false).serviceHttpUrl(this.brokerUrlTls.toString()).authentication("org.apache.pulsar.client.impl.auth.AuthenticationTls", String.format("tlsCertFile:%s,tlsKeyFile:%s", BrokerAdminClientTlsAuthTest.getTLSFile(user + ".cert"), BrokerAdminClientTlsAuthTest.getTLSFile(user + ".key-pk8"))).tlsTrustCertsFilePath(BrokerAdminClientTlsAuthTest.getTLSFile("ca.cert")).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPersistentList() throws Exception {
        log.info("-- Starting {} test --", (Object)this.methodName);
        ServiceConfiguration conf = new ServiceConfiguration();
        conf.setBrokerShutdownTimeoutMs(0L);
        conf.setBrokerServicePort(Optional.of(0));
        conf.setBrokerServicePortTls(Optional.of(0));
        conf.setWebServicePort(Optional.of(0));
        conf.setWebServicePortTls(Optional.of(0));
        conf.setAdvertisedAddress("localhost");
        conf.setClusterName(this.conf.getClusterName());
        conf.setZookeeperServers("localhost:2181");
        conf.setConfigurationStoreServers("localhost:3181");
        this.buildConf(conf);
        PulsarService pulsar2 = this.startBroker(conf);
        try {
            try (PulsarAdmin admin = this.buildAdminClient("superproxy");){
                admin.clusters().createCluster("test", new ClusterData(this.brokerUrl.toString()));
                admin.tenants().createTenant("tenant", new TenantInfo((Set)ImmutableSet.of((Object)"admin"), (Set)ImmutableSet.of((Object)"test")));
            }
            admin = this.buildAdminClient("admin");
            var4_4 = null;
            try {
                Policies policies = new Policies();
                policies.bundles = new BundlesData(4);
                policies.replication_clusters = ImmutableSet.of((Object)"test");
                admin.namespaces().createNamespace("tenant/ns", policies);
                try {
                    admin.topics().getList("tenant/ns");
                }
                catch (PulsarAdminException ex) {
                    ex.printStackTrace();
                    Assert.fail((String)"Should not have thrown an exception");
                }
                String topicName = String.format("persistent://%s/t1", "tenant/ns");
                admin.lookups().lookupTopic(topicName);
            }
            catch (Throwable throwable) {
                var4_4 = throwable;
                throw throwable;
            }
            finally {
                if (admin != null) {
                    if (var4_4 != null) {
                        try {
                            admin.close();
                        }
                        catch (Throwable throwable) {
                            var4_4.addSuppressed(throwable);
                        }
                    } else {
                        admin.close();
                    }
                }
            }
        }
        finally {
            if (Collections.singletonList(pulsar2).get(0) != null) {
                pulsar2.close();
            }
        }
    }
}

