/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.admin;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletContext;
import org.apache.pulsar.broker.admin.MockServletContext;
import org.apache.pulsar.broker.admin.v2.ResourceGroups;
import org.apache.pulsar.broker.auth.MockedPulsarServiceBaseTest;
import org.apache.pulsar.broker.web.RestException;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.pulsar.common.policies.data.ResourceGroup;
import org.apache.pulsar.common.policies.data.TenantInfo;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class ResourceGroupsTest
extends MockedPulsarServiceBaseTest {
    private ResourceGroups resourcegroups;
    private List<String> expectedRgNames = Lists.newArrayList();
    private final String testCluster = "test";
    private final String testTenant = "test-tenant";
    private final String testNameSpace = "test-tenant/test-namespace";

    @Override
    @BeforeClass
    protected void setup() throws Exception {
        super.internalSetup();
        this.resourcegroups = (ResourceGroups)Mockito.spy((Object)new ResourceGroups());
        this.resourcegroups.setServletContext((ServletContext)new MockServletContext());
        this.resourcegroups.setPulsar(this.pulsar);
        ((ResourceGroups)Mockito.doReturn((Object)this.mockZooKeeper).when((Object)this.resourcegroups)).localZk();
        ((ResourceGroups)Mockito.doReturn((Object)false).when((Object)this.resourcegroups)).isRequestHttps();
        ((ResourceGroups)Mockito.doReturn((Object)"test").when((Object)this.resourcegroups)).clientAppId();
        ((ResourceGroups)Mockito.doReturn(null).when((Object)this.resourcegroups)).originalPrincipal();
        ((ResourceGroups)Mockito.doReturn(null).when((Object)this.resourcegroups)).clientAuthData();
        this.prepareData();
    }

    @Override
    @AfterClass(alwaysRun=true)
    protected void cleanup() throws Exception {
        super.internalCleanup();
    }

    @Test
    public void testCrudResourceGroups() throws Exception {
        try {
            this.resourcegroups.createOrUpdateResourceGroup("test-resourcegroup-invalid", null);
            Assert.fail((String)"should have failed");
        }
        catch (RestException restException) {
            // empty catch block
        }
        ResourceGroup testResourceGroupOne = new ResourceGroup();
        this.resourcegroups.createOrUpdateResourceGroup("test-resourcegroup-one", testResourceGroupOne);
        this.expectedRgNames.add("test-resourcegroup-one");
        ResourceGroup testResourceGroupTwo = new ResourceGroup();
        testResourceGroupTwo.setDispatchRateInBytes(10000L);
        testResourceGroupTwo.setDispatchRateInMsgs(100);
        testResourceGroupTwo.setPublishRateInMsgs(100);
        testResourceGroupTwo.setPublishRateInBytes(10000L);
        this.resourcegroups.createOrUpdateResourceGroup("test-resourcegroup-two", testResourceGroupTwo);
        this.expectedRgNames.add("test-resourcegroup-two");
        try {
            this.resourcegroups.createOrUpdateResourceGroup("test-resourcegroup-one", null);
            Assert.fail((String)"should have failed");
        }
        catch (RestException restException) {
            // empty catch block
        }
        ResourceGroup testResourceGroupOneUpdate = new ResourceGroup();
        testResourceGroupOneUpdate.setDispatchRateInMsgs(50);
        testResourceGroupOneUpdate.setDispatchRateInBytes(5000L);
        testResourceGroupOneUpdate.setPublishRateInMsgs(10);
        testResourceGroupOneUpdate.setPublishRateInBytes(1000L);
        this.resourcegroups.createOrUpdateResourceGroup("test-resourcegroup-one", testResourceGroupOneUpdate);
        try {
            this.resourcegroups.getResourceGroup("test-resourcegroup-invalid");
            Assert.fail((String)"should have failed");
        }
        catch (RestException restException) {
            // empty catch block
        }
        List gotRgNames = this.resourcegroups.getResourceGroups();
        Assert.assertEquals((int)gotRgNames.size(), (int)this.expectedRgNames.size());
        Collections.sort(gotRgNames);
        Collections.sort(this.expectedRgNames);
        Assert.assertEquals((Collection)gotRgNames, this.expectedRgNames);
        try {
            this.resourcegroups.deleteResourceGroup("test-resourcegroup-invalid");
            Assert.fail((String)"should have failed");
        }
        catch (RestException restException) {
            // empty catch block
        }
        Iterator<String> rg_Iterator = this.expectedRgNames.iterator();
        while (rg_Iterator.hasNext()) {
            this.resourcegroups.deleteResourceGroup(rg_Iterator.next());
        }
    }

    @Test
    public void testNamespaceResourceGroup() throws Exception {
        ResourceGroup testResourceGroupTwo = new ResourceGroup();
        testResourceGroupTwo.setDispatchRateInBytes(10000L);
        testResourceGroupTwo.setDispatchRateInMsgs(100);
        testResourceGroupTwo.setPublishRateInMsgs(100);
        testResourceGroupTwo.setPublishRateInBytes(10000L);
        this.resourcegroups.createOrUpdateResourceGroup("test-resourcegroup-three", testResourceGroupTwo);
        this.admin.namespaces().createNamespace("test-tenant/test-namespace");
        try {
            this.admin.namespaces().setNamespaceResourceGroup("test-tenant/test-namespace", "test-resourcegroup-invalid");
            Assert.fail((String)"should have failed");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.admin.namespaces().setNamespaceResourceGroup("test-tenant/test-namespace", "test-resourcegroup-three");
        try {
            this.resourcegroups.deleteResourceGroup("test-resourcegroup-three");
        }
        catch (RestException restException) {
            // empty catch block
        }
        this.admin.namespaces().removeNamespaceResourceGroup("test-tenant/test-namespace");
        this.resourcegroups.deleteResourceGroup("test-resourcegroup-three");
    }

    private void prepareData() throws PulsarAdminException {
        this.admin.clusters().createCluster("test", new ClusterData(this.pulsar.getBrokerServiceUrl()));
        this.admin.tenants().createTenant("test-tenant", new TenantInfo((Set)Sets.newHashSet((Object[])new String[]{"role1", "role2"}), (Set)Sets.newHashSet((Object[])new String[]{"test"})));
    }
}

