/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.admin.v3;

import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.mledger.impl.PositionImpl;
import org.apache.pulsar.broker.auth.MockedPulsarServiceBaseTest;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.transaction.Transaction;
import org.apache.pulsar.client.api.transaction.TxnID;
import org.apache.pulsar.client.impl.BatchMessageIdImpl;
import org.apache.pulsar.client.impl.MessageIdImpl;
import org.apache.pulsar.client.impl.transaction.TransactionImpl;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.pulsar.common.policies.data.TenantInfo;
import org.apache.pulsar.common.policies.data.TransactionCoordinatorStatus;
import org.apache.pulsar.common.policies.data.TransactionInBufferStats;
import org.apache.pulsar.common.policies.data.TransactionInPendingAckStats;
import org.apache.pulsar.common.policies.data.TransactionMetadata;
import org.apache.pulsar.packages.management.core.MockedPackagesStorageProvider;
import org.awaitility.Awaitility;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AdminApiTransactionTest
extends MockedPulsarServiceBaseTest {
    @Override
    @BeforeMethod
    protected void setup() throws Exception {
        this.conf.setEnablePackagesManagement(true);
        this.conf.setPackagesManagementStorageProvider(MockedPackagesStorageProvider.class.getName());
        this.conf.setTransactionCoordinatorEnabled(true);
        this.conf.setSystemTopicEnabled(true);
        super.internalSetup();
        this.admin.clusters().createCluster("test", new ClusterData(this.pulsar.getWebServiceAddress()));
        TenantInfo tenantInfo = new TenantInfo((Set)Sets.newHashSet((Object[])new String[]{"role1", "role2"}), (Set)Sets.newHashSet((Object[])new String[]{"test"}));
        this.admin.tenants().createTenant("pulsar", tenantInfo);
        this.admin.namespaces().createNamespace("pulsar/system", (Set)Sets.newHashSet((Object[])new String[]{"test"}));
        this.admin.tenants().createTenant("public", tenantInfo);
        this.admin.namespaces().createNamespace("public/default", (Set)Sets.newHashSet((Object[])new String[]{"test"}));
    }

    @Override
    @AfterMethod(alwaysRun=true)
    protected void cleanup() throws Exception {
        super.internalCleanup();
    }

    @Test(timeOut=20000L)
    public void testGetTransactionCoordinatorStatus() throws Exception {
        this.initTransaction(2);
        this.getTransaction().commit().get();
        this.getTransaction().abort().get();
        TransactionCoordinatorStatus transactionCoordinatorStatus = (TransactionCoordinatorStatus)this.admin.transactions().getCoordinatorStatusById(1).get();
        AdminApiTransactionTest.verifyCoordinatorStatus(transactionCoordinatorStatus.state, transactionCoordinatorStatus.leastSigBits, transactionCoordinatorStatus.lowWaterMark);
        transactionCoordinatorStatus = (TransactionCoordinatorStatus)this.admin.transactions().getCoordinatorStatusById(0).get();
        AdminApiTransactionTest.verifyCoordinatorStatus(transactionCoordinatorStatus.state, transactionCoordinatorStatus.leastSigBits, transactionCoordinatorStatus.lowWaterMark);
        Map status = (Map)this.admin.transactions().getCoordinatorStatus().get();
        Assert.assertEquals((int)status.size(), (int)2);
        transactionCoordinatorStatus = (TransactionCoordinatorStatus)status.get(0);
        AdminApiTransactionTest.verifyCoordinatorStatus(transactionCoordinatorStatus.state, transactionCoordinatorStatus.leastSigBits, transactionCoordinatorStatus.lowWaterMark);
        transactionCoordinatorStatus = (TransactionCoordinatorStatus)status.get(1);
        AdminApiTransactionTest.verifyCoordinatorStatus(transactionCoordinatorStatus.state, transactionCoordinatorStatus.leastSigBits, transactionCoordinatorStatus.lowWaterMark);
    }

    @Test(timeOut=20000L)
    public void testGetTransactionInBufferStats() throws Exception {
        this.initTransaction(2);
        TransactionImpl transaction = (TransactionImpl)this.getTransaction();
        String topic = "persistent://public/default/testGetTransactionInBufferStats";
        this.admin.topics().createNonPartitionedTopic("persistent://public/default/testGetTransactionInBufferStats");
        Producer producer = this.pulsarClient.newProducer(Schema.BYTES).topic("persistent://public/default/testGetTransactionInBufferStats").sendTimeout(0, TimeUnit.SECONDS).create();
        MessageId messageId = producer.newMessage((Transaction)transaction).value((Object)"Hello pulsar!".getBytes()).send();
        TransactionInBufferStats transactionInBufferStats = (TransactionInBufferStats)this.admin.transactions().getTransactionInBufferStats(new TxnID(transaction.getTxnIdMostBits(), transaction.getTxnIdLeastBits()), "persistent://public/default/testGetTransactionInBufferStats").get();
        PositionImpl position = PositionImpl.get((long)((MessageIdImpl)messageId).getLedgerId(), (long)((MessageIdImpl)messageId).getEntryId());
        Assert.assertEquals((String)transactionInBufferStats.startPosition, (String)position.toString());
        Assert.assertFalse((boolean)transactionInBufferStats.aborted);
        transaction.abort().get();
        transactionInBufferStats = (TransactionInBufferStats)this.admin.transactions().getTransactionInBufferStats(new TxnID(transaction.getTxnIdMostBits(), transaction.getTxnIdLeastBits()), "persistent://public/default/testGetTransactionInBufferStats").get();
        Assert.assertNull((Object)transactionInBufferStats.startPosition);
        Assert.assertTrue((boolean)transactionInBufferStats.aborted);
    }

    @Test(timeOut=20000L)
    public void testGetTransactionPendingAckStats() throws Exception {
        this.initTransaction(2);
        String topic = "persistent://public/default/testGetTransactionInBufferStats";
        String subName = "test";
        this.admin.topics().createNonPartitionedTopic("persistent://public/default/testGetTransactionInBufferStats");
        Producer producer = this.pulsarClient.newProducer(Schema.BYTES).topic("persistent://public/default/testGetTransactionInBufferStats").create();
        Consumer consumer = this.pulsarClient.newConsumer(Schema.BYTES).topic(new String[]{"persistent://public/default/testGetTransactionInBufferStats"}).subscriptionName("test").subscribe();
        producer.sendAsync((Object)"Hello pulsar!".getBytes());
        producer.sendAsync((Object)"Hello pulsar!".getBytes());
        producer.sendAsync((Object)"Hello pulsar!".getBytes());
        producer.sendAsync((Object)"Hello pulsar!".getBytes());
        TransactionImpl transaction = (TransactionImpl)this.getTransaction();
        TransactionInPendingAckStats transactionInPendingAckStats = (TransactionInPendingAckStats)this.admin.transactions().getTransactionInPendingAckStats(new TxnID(transaction.getTxnIdMostBits(), transaction.getTxnIdLeastBits()), "persistent://public/default/testGetTransactionInBufferStats", "test").get();
        Assert.assertNull((Object)transactionInPendingAckStats.cumulativeAckPosition);
        consumer.receive();
        consumer.receive();
        Message message = consumer.receive();
        BatchMessageIdImpl batchMessageId = (BatchMessageIdImpl)message.getMessageId();
        consumer.acknowledgeCumulativeAsync((MessageId)batchMessageId, (Transaction)transaction).get();
        transactionInPendingAckStats = (TransactionInPendingAckStats)this.admin.transactions().getTransactionInPendingAckStats(new TxnID(transaction.getTxnIdMostBits(), transaction.getTxnIdLeastBits()), "persistent://public/default/testGetTransactionInBufferStats", "test").get();
        Assert.assertEquals((String)transactionInPendingAckStats.cumulativeAckPosition, (String)(String.valueOf(batchMessageId.getLedgerId()) + ':' + batchMessageId.getEntryId() + ':' + batchMessageId.getBatchIndex()));
    }

    @Test(timeOut=20000L)
    public void testGetTransactionMetadata() throws Exception {
        this.initTransaction(2);
        long currentTime = System.currentTimeMillis();
        TransactionImpl transaction = (TransactionImpl)this.getTransaction();
        String topic1 = "persistent://public/default/testGetTransactionMetadata-1";
        String subName1 = "test1";
        String topic2 = "persistent://public/default/testGetTransactionMetadata-2";
        String subName2 = "test2";
        String subName3 = "test3";
        this.admin.topics().createNonPartitionedTopic("persistent://public/default/testGetTransactionMetadata-1");
        this.admin.topics().createNonPartitionedTopic("persistent://public/default/testGetTransactionMetadata-2");
        Producer producer1 = this.pulsarClient.newProducer(Schema.BYTES).sendTimeout(0, TimeUnit.SECONDS).topic("persistent://public/default/testGetTransactionMetadata-1").create();
        Producer producer2 = this.pulsarClient.newProducer(Schema.BYTES).sendTimeout(0, TimeUnit.SECONDS).topic("persistent://public/default/testGetTransactionMetadata-2").create();
        Consumer consumer1 = this.pulsarClient.newConsumer(Schema.BYTES).topic(new String[]{"persistent://public/default/testGetTransactionMetadata-1"}).subscriptionName("test1").subscribe();
        Consumer consumer2 = this.pulsarClient.newConsumer(Schema.BYTES).topic(new String[]{"persistent://public/default/testGetTransactionMetadata-2"}).subscriptionName("test2").subscribe();
        Consumer consumer3 = this.pulsarClient.newConsumer(Schema.BYTES).topic(new String[]{"persistent://public/default/testGetTransactionMetadata-2"}).subscriptionName("test3").subscribe();
        MessageId messageId1 = producer1.send((Object)"Hello pulsar!".getBytes());
        MessageId messageId2 = producer2.send((Object)"Hello pulsar!".getBytes());
        MessageId messageId3 = producer1.newMessage((Transaction)transaction).value((Object)"Hello pulsar!".getBytes()).send();
        MessageId messageId4 = producer2.newMessage((Transaction)transaction).value((Object)"Hello pulsar!".getBytes()).send();
        consumer1.acknowledgeCumulativeAsync(messageId1, (Transaction)transaction).get();
        consumer2.acknowledgeCumulativeAsync(messageId2, (Transaction)transaction).get();
        consumer3.acknowledgeCumulativeAsync(messageId2, (Transaction)transaction).get();
        TxnID txnID = new TxnID(transaction.getTxnIdMostBits(), transaction.getTxnIdLeastBits());
        TransactionMetadata transactionMetadata = (TransactionMetadata)this.admin.transactions().getTransactionMetadata(new TxnID(transaction.getTxnIdMostBits(), transaction.getTxnIdLeastBits())).get();
        Assert.assertEquals((String)transactionMetadata.txnId, (String)txnID.toString());
        Assert.assertTrue((transactionMetadata.openTimestamp > currentTime ? 1 : 0) != 0);
        Assert.assertEquals((long)transactionMetadata.timeoutAt, (long)5000L);
        Assert.assertEquals((String)transactionMetadata.status, (String)"OPEN");
        Map producedPartitions = transactionMetadata.producedPartitions;
        Map ackedPartitions = transactionMetadata.ackedPartitions;
        PositionImpl position1 = AdminApiTransactionTest.getPositionByMessageId(messageId1);
        PositionImpl position2 = AdminApiTransactionTest.getPositionByMessageId(messageId2);
        PositionImpl position3 = AdminApiTransactionTest.getPositionByMessageId(messageId3);
        PositionImpl position4 = AdminApiTransactionTest.getPositionByMessageId(messageId4);
        Assert.assertFalse((boolean)((TransactionInBufferStats)producedPartitions.get((Object)"persistent://public/default/testGetTransactionMetadata-1")).aborted);
        Assert.assertFalse((boolean)((TransactionInBufferStats)producedPartitions.get((Object)"persistent://public/default/testGetTransactionMetadata-2")).aborted);
        Assert.assertEquals((String)((TransactionInBufferStats)producedPartitions.get((Object)"persistent://public/default/testGetTransactionMetadata-1")).startPosition, (String)position3.toString());
        Assert.assertEquals((String)((TransactionInBufferStats)producedPartitions.get((Object)"persistent://public/default/testGetTransactionMetadata-2")).startPosition, (String)position4.toString());
        Assert.assertEquals((int)((Map)ackedPartitions.get("persistent://public/default/testGetTransactionMetadata-1")).size(), (int)1);
        Assert.assertEquals((int)((Map)ackedPartitions.get("persistent://public/default/testGetTransactionMetadata-2")).size(), (int)2);
        Assert.assertEquals((String)((TransactionInPendingAckStats)((Map)ackedPartitions.get((Object)"persistent://public/default/testGetTransactionMetadata-1")).get((Object)"test1")).cumulativeAckPosition, (String)position1.toString());
        Assert.assertEquals((String)((TransactionInPendingAckStats)((Map)ackedPartitions.get((Object)"persistent://public/default/testGetTransactionMetadata-2")).get((Object)"test2")).cumulativeAckPosition, (String)position2.toString());
        Assert.assertEquals((String)((TransactionInPendingAckStats)((Map)ackedPartitions.get((Object)"persistent://public/default/testGetTransactionMetadata-2")).get((Object)"test3")).cumulativeAckPosition, (String)position2.toString());
    }

    private static PositionImpl getPositionByMessageId(MessageId messageId) {
        return PositionImpl.get((long)((MessageIdImpl)messageId).getLedgerId(), (long)((MessageIdImpl)messageId).getEntryId());
    }

    private static void verifyCoordinatorStatus(String state, long sequenceId, long lowWaterMark) {
        Assert.assertEquals((String)state, (String)"Ready");
        Assert.assertEquals((long)sequenceId, (long)0L);
        Assert.assertEquals((long)lowWaterMark, (long)0L);
    }

    private void initTransaction(int coordinatorSize) throws Exception {
        this.admin.topics().createPartitionedTopic(TopicName.TRANSACTION_COORDINATOR_ASSIGN.toString(), coordinatorSize);
        this.admin.lookups().lookupTopic(TopicName.TRANSACTION_COORDINATOR_ASSIGN.toString());
        Awaitility.await().until(() -> this.pulsar.getTransactionMetadataStoreService().getStores().size() == coordinatorSize);
        this.pulsarClient = PulsarClient.builder().serviceUrl(this.lookupUrl.toString()).enableTransaction(true).build();
    }

    private Transaction getTransaction() throws Exception {
        return (Transaction)this.pulsarClient.newTransaction().withTransactionTimeout(5L, TimeUnit.SECONDS).build().get();
    }
}

