/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.auth;

import com.google.common.collect.Sets;
import java.util.EnumSet;
import java.util.Set;
import org.apache.pulsar.broker.auth.MockAuthentication;
import org.apache.pulsar.broker.auth.MockedPulsarServiceBaseTest;
import org.apache.pulsar.broker.authorization.AuthorizationService;
import org.apache.pulsar.client.admin.PulsarAdminBuilder;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.policies.data.AuthAction;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.pulsar.common.policies.data.SubscriptionAuthMode;
import org.apache.pulsar.common.policies.data.TenantInfo;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"flaky"})
public class AuthorizationTest
extends MockedPulsarServiceBaseTest {
    @Override
    @BeforeClass
    public void setup() throws Exception {
        this.conf.setClusterName("c1");
        this.conf.setAuthenticationEnabled(true);
        this.conf.setAuthenticationProviders((Set)Sets.newHashSet((Object[])new String[]{"org.apache.pulsar.broker.auth.MockAuthenticationProvider"}));
        this.conf.setAuthorizationEnabled(true);
        this.conf.setAuthorizationAllowWildcardsMatching(true);
        this.conf.setSuperUserRoles((Set)Sets.newHashSet((Object[])new String[]{"pulsar.super_user", "pass.pass"}));
        this.internalSetup();
    }

    @Override
    protected void customizeNewPulsarAdminBuilder(PulsarAdminBuilder pulsarAdminBuilder) {
        pulsarAdminBuilder.authentication((Authentication)new MockAuthentication("pass.pass"));
    }

    @Override
    @AfterClass(alwaysRun=true)
    public void cleanup() throws Exception {
        this.internalCleanup();
    }

    @Test
    public void simple() throws Exception {
        AuthorizationService auth = this.pulsar.getBrokerService().getAuthorizationService();
        Assert.assertFalse((boolean)auth.canLookup(TopicName.get((String)"persistent://p1/c1/ns1/ds1"), "my-role", null));
        this.admin.clusters().createCluster("c1", new ClusterData());
        this.admin.tenants().createTenant("p1", new TenantInfo((Set)Sets.newHashSet((Object[])new String[]{"role1"}), (Set)Sets.newHashSet((Object[])new String[]{"c1"})));
        AuthorizationTest.waitForChange();
        this.admin.namespaces().createNamespace("p1/c1/ns1");
        AuthorizationTest.waitForChange();
        Assert.assertFalse((boolean)auth.canLookup(TopicName.get((String)"persistent://p1/c1/ns1/ds1"), "my-role", null));
        this.admin.namespaces().grantPermissionOnNamespace("p1/c1/ns1", "my-role", EnumSet.of(AuthAction.produce));
        AuthorizationTest.waitForChange();
        Assert.assertTrue((boolean)auth.canLookup(TopicName.get((String)"persistent://p1/c1/ns1/ds1"), "my-role", null));
        Assert.assertTrue((boolean)auth.canProduce(TopicName.get((String)"persistent://p1/c1/ns1/ds1"), "my-role", null));
        this.admin.topics().grantPermission("persistent://p1/c1/ns1/ds2", "other-role", EnumSet.of(AuthAction.consume));
        AuthorizationTest.waitForChange();
        Assert.assertTrue((boolean)auth.canLookup(TopicName.get((String)"persistent://p1/c1/ns1/ds2"), "other-role", null));
        Assert.assertTrue((boolean)auth.canProduce(TopicName.get((String)"persistent://p1/c1/ns1/ds1"), "my-role", null));
        Assert.assertFalse((boolean)auth.canProduce(TopicName.get((String)"persistent://p1/c1/ns1/ds2"), "other-role", null));
        Assert.assertTrue((boolean)auth.canConsume(TopicName.get((String)"persistent://p1/c1/ns1/ds2"), "other-role", null, null));
        Assert.assertFalse((boolean)auth.canConsume(TopicName.get((String)"persistent://p1/c1/ns1/ds2"), "no-access-role", null, null));
        Assert.assertFalse((boolean)auth.canLookup(TopicName.get((String)"persistent://p1/c1/ns1/ds1"), "no-access-role", null));
        this.admin.namespaces().grantPermissionOnNamespace("p1/c1/ns1", "my-role", EnumSet.allOf(AuthAction.class));
        AuthorizationTest.waitForChange();
        Assert.assertTrue((boolean)auth.canProduce(TopicName.get((String)"persistent://p1/c1/ns1/ds1"), "my-role", null));
        Assert.assertTrue((boolean)auth.canConsume(TopicName.get((String)"persistent://p1/c1/ns1/ds1"), "my-role", null, null));
        Assert.assertFalse((boolean)auth.canLookup(TopicName.get((String)"persistent://p1/c1/ns1/ds1"), "my.role.1", null));
        Assert.assertFalse((boolean)auth.canLookup(TopicName.get((String)"persistent://p1/c1/ns1/ds1"), "my.role.2", null));
        Assert.assertFalse((boolean)auth.canProduce(TopicName.get((String)"persistent://p1/c1/ns1/ds1"), "my.role.1", null));
        Assert.assertFalse((boolean)auth.canConsume(TopicName.get((String)"persistent://p1/c1/ns1/ds1"), "my.role.1", null, null));
        Assert.assertFalse((boolean)auth.canLookup(TopicName.get((String)"persistent://p1/c1/ns1/ds1"), "other.role.1", null));
        Assert.assertFalse((boolean)auth.canLookup(TopicName.get((String)"persistent://p1/c1/ns1/ds1"), "other.role.2", null));
        this.admin.namespaces().grantPermissionOnNamespace("p1/c1/ns1", "my.role.*", EnumSet.of(AuthAction.produce));
        AuthorizationTest.waitForChange();
        Assert.assertTrue((boolean)auth.canLookup(TopicName.get((String)"persistent://p1/c1/ns1/ds1"), "my.role.1", null));
        Assert.assertTrue((boolean)auth.canLookup(TopicName.get((String)"persistent://p1/c1/ns1/ds1"), "my.role.2", null));
        Assert.assertTrue((boolean)auth.canProduce(TopicName.get((String)"persistent://p1/c1/ns1/ds1"), "my.role.1", null));
        Assert.assertFalse((boolean)auth.canConsume(TopicName.get((String)"persistent://p1/c1/ns1/ds1"), "my.role.1", null, null));
        Assert.assertFalse((boolean)auth.canLookup(TopicName.get((String)"persistent://p1/c1/ns1/ds1"), "other.role.1", null));
        Assert.assertFalse((boolean)auth.canLookup(TopicName.get((String)"persistent://p1/c1/ns1/ds1"), "other.role.2", null));
        Assert.assertFalse((boolean)auth.canLookup(TopicName.get((String)"persistent://p1/c1/ns1/ds1"), "1.role.my", null));
        Assert.assertFalse((boolean)auth.canLookup(TopicName.get((String)"persistent://p1/c1/ns1/ds1"), "2.role.my", null));
        Assert.assertFalse((boolean)auth.canProduce(TopicName.get((String)"persistent://p1/c1/ns1/ds1"), "1.role.my", null));
        Assert.assertFalse((boolean)auth.canConsume(TopicName.get((String)"persistent://p1/c1/ns1/ds1"), "1.role.my", null, null));
        Assert.assertFalse((boolean)auth.canLookup(TopicName.get((String)"persistent://p1/c1/ns1/ds1"), "2.role.other", null));
        Assert.assertFalse((boolean)auth.canLookup(TopicName.get((String)"persistent://p1/c1/ns1/ds1"), "2.role.other", null));
        this.admin.namespaces().grantPermissionOnNamespace("p1/c1/ns1", "*.role.my", EnumSet.of(AuthAction.consume));
        AuthorizationTest.waitForChange();
        Assert.assertTrue((boolean)auth.canLookup(TopicName.get((String)"persistent://p1/c1/ns1/ds1"), "1.role.my", null));
        Assert.assertTrue((boolean)auth.canLookup(TopicName.get((String)"persistent://p1/c1/ns1/ds1"), "2.role.my", null));
        Assert.assertFalse((boolean)auth.canProduce(TopicName.get((String)"persistent://p1/c1/ns1/ds1"), "1.role.my", null));
        Assert.assertTrue((boolean)auth.canConsume(TopicName.get((String)"persistent://p1/c1/ns1/ds1"), "1.role.my", null, null));
        Assert.assertFalse((boolean)auth.canLookup(TopicName.get((String)"persistent://p1/c1/ns1/ds1"), "2.role.other", null));
        Assert.assertFalse((boolean)auth.canLookup(TopicName.get((String)"persistent://p1/c1/ns1/ds1"), "2.role.other", null));
        this.admin.namespaces().revokePermissionsOnNamespace("p1/c1/ns1", "my.role.*");
        this.admin.namespaces().revokePermissionsOnNamespace("p1/c1/ns1", "*.role.my");
        AuthorizationTest.waitForChange();
        Assert.assertFalse((boolean)auth.canLookup(TopicName.get((String)"persistent://p1/c1/ns1/ds1"), "my.role.1", null));
        Assert.assertFalse((boolean)auth.canLookup(TopicName.get((String)"persistent://p1/c1/ns1/ds1"), "my.role.2", null));
        Assert.assertFalse((boolean)auth.canProduce(TopicName.get((String)"persistent://p1/c1/ns1/ds1"), "my.role.1", null));
        Assert.assertFalse((boolean)auth.canConsume(TopicName.get((String)"persistent://p1/c1/ns1/ds1"), "my.role.1", null, null));
        Assert.assertFalse((boolean)auth.canLookup(TopicName.get((String)"persistent://p1/c1/ns1/ds1"), "other.role.1", null));
        Assert.assertFalse((boolean)auth.canLookup(TopicName.get((String)"persistent://p1/c1/ns1/ds1"), "other.role.2", null));
        Assert.assertFalse((boolean)auth.canLookup(TopicName.get((String)"persistent://p1/c1/ns1/ds2"), "my.role.1", null));
        Assert.assertFalse((boolean)auth.canLookup(TopicName.get((String)"persistent://p1/c1/ns1/ds2"), "my.role.2", null));
        this.admin.topics().grantPermission("persistent://p1/c1/ns1/ds1", "my.*", EnumSet.of(AuthAction.produce));
        AuthorizationTest.waitForChange();
        Assert.assertTrue((boolean)auth.canLookup(TopicName.get((String)"persistent://p1/c1/ns1/ds1"), "my.role.1", null));
        Assert.assertTrue((boolean)auth.canLookup(TopicName.get((String)"persistent://p1/c1/ns1/ds1"), "my.role.2", null));
        Assert.assertTrue((boolean)auth.canProduce(TopicName.get((String)"persistent://p1/c1/ns1/ds1"), "my.role.1", null));
        Assert.assertFalse((boolean)auth.canConsume(TopicName.get((String)"persistent://p1/c1/ns1/ds1"), "my.role.1", null, null));
        Assert.assertFalse((boolean)auth.canLookup(TopicName.get((String)"persistent://p1/c1/ns1/ds1"), "other.role.1", null));
        Assert.assertFalse((boolean)auth.canLookup(TopicName.get((String)"persistent://p1/c1/ns1/ds1"), "other.role.2", null));
        Assert.assertFalse((boolean)auth.canLookup(TopicName.get((String)"persistent://p1/c1/ns1/ds2"), "my.role.1", null));
        Assert.assertFalse((boolean)auth.canLookup(TopicName.get((String)"persistent://p1/c1/ns1/ds2"), "my.role.2", null));
        Assert.assertFalse((boolean)auth.canLookup(TopicName.get((String)"persistent://p1/c1/ns1/ds1"), "1.role.my", null));
        Assert.assertFalse((boolean)auth.canLookup(TopicName.get((String)"persistent://p1/c1/ns1/ds1"), "2.role.my", null));
        Assert.assertFalse((boolean)auth.canProduce(TopicName.get((String)"persistent://p1/c1/ns1/ds1"), "1.role.my", null));
        Assert.assertFalse((boolean)auth.canConsume(TopicName.get((String)"persistent://p1/c1/ns1/ds1"), "1.role.my", null, null));
        Assert.assertFalse((boolean)auth.canLookup(TopicName.get((String)"persistent://p1/c1/ns1/ds1"), "2.role.other", null));
        Assert.assertFalse((boolean)auth.canLookup(TopicName.get((String)"persistent://p1/c1/ns1/ds1"), "2.role.other", null));
        Assert.assertFalse((boolean)auth.canLookup(TopicName.get((String)"persistent://p1/c1/ns1/ds2"), "1.role.my", null));
        Assert.assertFalse((boolean)auth.canLookup(TopicName.get((String)"persistent://p1/c1/ns1/ds2"), "2.role.my", null));
        this.admin.topics().grantPermission("persistent://p1/c1/ns1/ds1", "*.my", EnumSet.of(AuthAction.consume));
        AuthorizationTest.waitForChange();
        Assert.assertTrue((boolean)auth.canLookup(TopicName.get((String)"persistent://p1/c1/ns1/ds1"), "1.role.my", null));
        Assert.assertTrue((boolean)auth.canLookup(TopicName.get((String)"persistent://p1/c1/ns1/ds1"), "2.role.my", null));
        Assert.assertFalse((boolean)auth.canProduce(TopicName.get((String)"persistent://p1/c1/ns1/ds1"), "1.role.my", null));
        Assert.assertTrue((boolean)auth.canConsume(TopicName.get((String)"persistent://p1/c1/ns1/ds1"), "1.role.my", null, null));
        Assert.assertFalse((boolean)auth.canLookup(TopicName.get((String)"persistent://p1/c1/ns1/ds1"), "2.role.other", null));
        Assert.assertFalse((boolean)auth.canLookup(TopicName.get((String)"persistent://p1/c1/ns1/ds1"), "2.role.other", null));
        Assert.assertFalse((boolean)auth.canLookup(TopicName.get((String)"persistent://p1/c1/ns1/ds2"), "1.role.my", null));
        Assert.assertFalse((boolean)auth.canLookup(TopicName.get((String)"persistent://p1/c1/ns1/ds2"), "2.role.my", null));
        this.admin.topics().revokePermissions("persistent://p1/c1/ns1/ds1", "my.*");
        this.admin.topics().revokePermissions("persistent://p1/c1/ns1/ds1", "*.my");
        this.admin.namespaces().grantPermissionOnNamespace("p1/c1/ns1", "*", EnumSet.of(AuthAction.consume));
        this.admin.namespaces().setSubscriptionAuthMode("p1/c1/ns1", SubscriptionAuthMode.Prefix);
        AuthorizationTest.waitForChange();
        Assert.assertTrue((boolean)auth.canLookup(TopicName.get((String)"persistent://p1/c1/ns1/ds1"), "role1", null));
        Assert.assertTrue((boolean)auth.canLookup(TopicName.get((String)"persistent://p1/c1/ns1/ds1"), "role2", null));
        try {
            Assert.assertFalse((boolean)auth.canConsume(TopicName.get((String)"persistent://p1/c1/ns1/ds1"), "role1", null, "sub1"));
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Assert.assertFalse((boolean)auth.canConsume(TopicName.get((String)"persistent://p1/c1/ns1/ds1"), "role2", null, "sub2"));
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertTrue((boolean)auth.canConsume(TopicName.get((String)"persistent://p1/c1/ns1/ds1"), "role1", null, "role1-sub1"));
        Assert.assertTrue((boolean)auth.canConsume(TopicName.get((String)"persistent://p1/c1/ns1/ds1"), "role2", null, "role2-sub2"));
        Assert.assertTrue((boolean)auth.canConsume(TopicName.get((String)"persistent://p1/c1/ns1/ds1"), "pulsar.super_user", null, "role3-sub1"));
        this.admin.namespaces().deleteNamespace("p1/c1/ns1");
        this.admin.tenants().deleteTenant("p1");
        this.admin.clusters().deleteCluster("c1");
    }

    private static void waitForChange() {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

