/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.intercept;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.bookkeeper.mledger.Entry;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.intercept.BrokerInterceptor;
import org.apache.pulsar.broker.service.ServerCnx;
import org.apache.pulsar.broker.service.Subscription;
import org.apache.pulsar.common.api.proto.BaseCommand;
import org.apache.pulsar.common.api.proto.MessageMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CounterBrokerInterceptor
implements BrokerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(CounterBrokerInterceptor.class);
    int beforeSendCount = 0;
    int count = 0;

    public void beforeSendMessage(Subscription subscription, Entry entry, long[] ackSet, MessageMetadata msgMetadata) {
        log.info("Send message to topic {}, subscription {}", (Object)subscription.getTopic(), (Object)subscription.getName());
        ++this.beforeSendCount;
    }

    public void onPulsarCommand(BaseCommand command, ServerCnx cnx) {
        log.info("[{}] On [{}] Pulsar command", (Object)this.count, (Object)command.getType().name());
        ++this.count;
    }

    public void onConnectionClosed(ServerCnx cnx) {
    }

    public void onWebserviceRequest(ServletRequest request) {
        ++this.count;
        log.info("[{}] On [{}] Webservice request", (Object)this.count, (Object)((HttpServletRequest)request).getRequestURL().toString());
    }

    public void onWebserviceResponse(ServletRequest request, ServletResponse response) {
        ++this.count;
        log.info("[{}] On [{}] Webservice response", (Object)this.count, (Object)((HttpServletRequest)request).getRequestURL().toString());
    }

    public void onFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.count = 100;
        chain.doFilter(request, response);
    }

    public void initialize(PulsarService pulsarService) throws Exception {
    }

    public void close() {
    }

    public int getCount() {
        return this.count;
    }

    public int getBeforeSendCount() {
        return this.beforeSendCount;
    }
}

