/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.loadbalance;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.apache.pulsar.broker.PulsarServerException;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.loadbalance.LeaderBroker;
import org.apache.pulsar.broker.loadbalance.LeaderElectionService;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.pulsar.common.policies.data.TenantInfo;
import org.apache.pulsar.functions.worker.WorkerService;
import org.apache.pulsar.zookeeper.LocalBookkeeperEnsemble;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"broker"})
public class LeaderElectionServiceTest {
    private static final Logger log = LoggerFactory.getLogger(LeaderElectionServiceTest.class);
    private LocalBookkeeperEnsemble bkEnsemble;

    @BeforeMethod(alwaysRun=true)
    public void setup() throws Exception {
        this.bkEnsemble = new LocalBookkeeperEnsemble(3, 0, () -> 0);
        this.bkEnsemble.start();
        log.info("---- bk started ----");
    }

    @AfterMethod(alwaysRun=true)
    void shutdown() throws Exception {
        this.bkEnsemble.stop();
        log.info("---- bk stopped ----");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void anErrorShouldBeThrowBeforeLeaderElected() throws PulsarServerException, PulsarClientException, PulsarAdminException {
        String clusterName = "elect-test";
        ServiceConfiguration config = new ServiceConfiguration();
        config.setBrokerShutdownTimeoutMs(0L);
        config.setBrokerServicePort(Optional.of(0));
        config.setWebServicePort(Optional.of(0));
        config.setClusterName("elect-test");
        config.setAdvertisedAddress("localhost");
        config.setZookeeperServers("127.0.0.1:" + this.bkEnsemble.getZookeeperPort());
        PulsarService pulsar = (PulsarService)Mockito.spy((Object)((Object)new MockPulsarService(config)));
        try {
            pulsar.start();
            AtomicReference<LeaderElectionService> leaderElectionServiceReference = new AtomicReference<LeaderElectionService>();
            ((PulsarService)Mockito.doAnswer(invocation -> (LeaderElectionService)leaderElectionServiceReference.get()).when((Object)pulsar)).getLeaderElectionService();
            String tenant = "elect";
            String namespace = "ns";
            PulsarAdmin adminClient = PulsarAdmin.builder().serviceHttpUrl(pulsar.getWebServiceAddress()).build();
            try {
                adminClient.clusters().createCluster("elect-test", new ClusterData(pulsar.getWebServiceAddress()));
                adminClient.tenants().createTenant("elect", new TenantInfo((Set)Sets.newHashSet((Object[])new String[]{"appid1", "appid2"}), (Set)Sets.newHashSet((Object[])new String[]{"elect-test"})));
                adminClient.namespaces().createNamespace("elect/ns", 16);
                PulsarClient client = PulsarClient.builder().serviceUrl(pulsar.getBrokerServiceUrl()).startingBackoffInterval(1L, TimeUnit.MILLISECONDS).maxBackoffInterval(100L, TimeUnit.MILLISECONDS).operationTimeout(1000, TimeUnit.MILLISECONDS).build();
                try {
                    this.checkLookupException("elect", "ns", client);
                    LeaderElectionService leaderElectionService = (LeaderElectionService)Mockito.mock(LeaderElectionService.class);
                    AtomicReference<LeaderBroker> leaderBrokerReference = new AtomicReference<LeaderBroker>();
                    Mockito.when((Object)leaderElectionService.isLeader()).thenAnswer(invocation -> leaderBrokerReference.get() != null);
                    Mockito.when((Object)leaderElectionService.getCurrentLeader()).thenAnswer(invocation -> Optional.ofNullable(leaderBrokerReference.get()));
                    leaderElectionServiceReference.set(leaderElectionService);
                    this.checkLookupException("elect", "ns", client);
                    leaderBrokerReference.set(new LeaderBroker(pulsar.getWebServiceAddress()));
                    Producer producer = client.newProducer().topic("persistent://elect/ns/1p").create();
                    producer.getTopic();
                }
                finally {
                    if (Collections.singletonList(client).get(0) != null) {
                        client.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(adminClient).get(0) != null) {
                    adminClient.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(pulsar).get(0) != null) {
                pulsar.close();
            }
        }
    }

    private void checkLookupException(String tenant, String namespace, PulsarClient client) {
        try {
            client.newProducer().topic("persistent://" + tenant + "/" + namespace + "/1p").create();
        }
        catch (PulsarClientException t) {
            Assert.assertTrue((boolean)(t instanceof PulsarClientException.LookupException));
            Assert.assertEquals((String)t.getMessage(), (String)"java.lang.IllegalStateException: The leader election has not yet been completed!");
        }
    }

    private static class MockPulsarService
    extends PulsarService {
        public MockPulsarService(ServiceConfiguration config) {
            super(config);
        }

        public MockPulsarService(ServiceConfiguration config, Optional<WorkerService> functionWorkerService, Consumer<Integer> processTerminator) {
            super(config, functionWorkerService, processTerminator);
        }

        protected void startLeaderElectionService() {
        }
    }
}

