/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.namespace;

import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.broker.service.BrokerTestBase;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.ProducerBuilder;
import org.apache.pulsar.common.policies.data.BookieAffinityGroupData;
import org.apache.pulsar.common.policies.data.Policies;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"broker"})
public class NamespaceCreateBundlesTest
extends BrokerTestBase {
    @Override
    @BeforeMethod
    protected void setup() throws Exception {
        this.conf.setDefaultNumberOfNamespaceBundles(16);
        super.baseSetup();
    }

    @Override
    @AfterMethod(alwaysRun=true)
    protected void cleanup() throws Exception {
        super.internalCleanup();
    }

    @Test
    public void testCreateNamespaceWithDefaultBundles() throws Exception {
        String namespaceName = "prop/" + UUID.randomUUID().toString();
        this.admin.namespaces().createNamespace(namespaceName);
        Policies policies = this.admin.namespaces().getPolicies(namespaceName);
        Assert.assertEquals((int)policies.bundles.numBundles, (int)16);
        Assert.assertEquals((int)policies.bundles.boundaries.size(), (int)17);
    }

    @Test
    public void testSplitBundleUpdatesLocalPoliciesWithoutOverwriting() throws Exception {
        String namespaceName = "prop/" + UUID.randomUUID().toString();
        String topicName = "persistent://" + namespaceName + "/my-topic5";
        this.admin.namespaces().createNamespace(namespaceName);
        ProducerBuilder producerBuilder = this.pulsarClient.newProducer().topic(topicName).sendTimeout(1, TimeUnit.SECONDS);
        Producer producer = producerBuilder.create();
        String bundle = this.admin.lookups().getBundleRange(topicName);
        BookieAffinityGroupData bookieAffinityGroup = new BookieAffinityGroupData();
        bookieAffinityGroup.bookkeeperAffinityGroupPrimary = "test";
        this.admin.namespaces().setBookieAffinityGroup(namespaceName, bookieAffinityGroup);
        this.admin.namespaces().splitNamespaceBundle(namespaceName, bundle, false, null);
        Assert.assertNotNull((Object)this.admin.namespaces().getBookieAffinityGroup(namespaceName));
        producer.close();
    }
}

