/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.namespace;

import com.github.benmanes.caffeine.cache.AsyncLoadingCache;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.mledger.ManagedLedger;
import org.apache.bookkeeper.util.ZkUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.loadbalance.LoadManager;
import org.apache.pulsar.broker.loadbalance.ModularLoadManager;
import org.apache.pulsar.broker.loadbalance.impl.ModularLoadManagerImpl;
import org.apache.pulsar.broker.loadbalance.impl.ModularLoadManagerWrapper;
import org.apache.pulsar.broker.lookup.LookupResult;
import org.apache.pulsar.broker.namespace.NamespaceEphemeralData;
import org.apache.pulsar.broker.namespace.NamespaceService;
import org.apache.pulsar.broker.namespace.OwnershipCache;
import org.apache.pulsar.broker.namespace.ServiceUnitUtils;
import org.apache.pulsar.broker.service.BrokerTestBase;
import org.apache.pulsar.broker.service.Topic;
import org.apache.pulsar.broker.service.persistent.PersistentTopic;
import org.apache.pulsar.broker.web.PulsarWebResource;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.common.naming.NamespaceBundle;
import org.apache.pulsar.common.naming.NamespaceBundleFactory;
import org.apache.pulsar.common.naming.NamespaceBundleSplitAlgorithm;
import org.apache.pulsar.common.naming.NamespaceBundles;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.policies.data.Policies;
import org.apache.pulsar.common.util.ObjectMapperFactory;
import org.apache.pulsar.common.util.collections.ConcurrentOpenHashMap;
import org.apache.pulsar.policies.data.loadbalancer.AdvertisedListener;
import org.apache.pulsar.policies.data.loadbalancer.LoadReport;
import org.apache.pulsar.policies.data.loadbalancer.LocalBrokerData;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"broker"})
public class NamespaceServiceTest
extends BrokerTestBase {
    private static final Logger log = LoggerFactory.getLogger(NamespaceServiceTest.class);

    @Override
    @BeforeMethod
    protected void setup() throws Exception {
        super.baseSetup();
    }

    @Override
    @AfterMethod(alwaysRun=true)
    protected void cleanup() throws Exception {
        super.internalCleanup();
    }

    @Test
    public void testSplitAndOwnBundles() throws Exception {
        OwnershipCache MockOwnershipCache = (OwnershipCache)Mockito.spy((Object)this.pulsar.getNamespaceService().getOwnershipCache());
        ((OwnershipCache)Mockito.doReturn(CompletableFuture.completedFuture(null)).when((Object)MockOwnershipCache)).disableOwnership((NamespaceBundle)ArgumentMatchers.any(NamespaceBundle.class));
        Field ownership = NamespaceService.class.getDeclaredField("ownershipCache");
        ownership.setAccessible(true);
        ownership.set(this.pulsar.getNamespaceService(), MockOwnershipCache);
        NamespaceService namespaceService = this.pulsar.getNamespaceService();
        NamespaceName nsname = NamespaceName.get((String)"pulsar/global/ns1");
        TopicName topicName = TopicName.get((String)"persistent://pulsar/global/ns1/topic-1");
        NamespaceBundles bundles = namespaceService.getNamespaceBundleFactory().getBundles(nsname);
        NamespaceBundle originalBundle = bundles.findBundle(topicName);
        CompletableFuture result = namespaceService.splitAndOwnBundle(originalBundle, false, NamespaceBundleSplitAlgorithm.RANGE_EQUALLY_DIVIDE_ALGO);
        try {
            result.get();
        }
        catch (Exception e) {
            Assert.fail((String)"split bundle failed", (Throwable)e);
        }
        NamespaceBundleFactory bundleFactory = this.pulsar.getNamespaceService().getNamespaceBundleFactory();
        NamespaceBundles updatedNsBundles = bundleFactory.getBundles(nsname);
        Assert.assertNotNull((Object)updatedNsBundles);
        List bundleList = updatedNsBundles.getBundles();
        Assert.assertNotNull((Object)bundles);
        NamespaceBundleFactory utilityFactory = NamespaceBundleFactory.createFactory((PulsarService)this.pulsar, (HashFunction)Hashing.crc32());
        Pair<NamespaceBundles, List<NamespaceBundle>> splitBundles = this.splitBundles(utilityFactory, nsname, bundles, originalBundle);
        Assert.assertNotNull(splitBundles);
        HashSet splitBundleSet = new HashSet((Collection)splitBundles.getRight());
        splitBundleSet.removeAll(bundleList);
        Assert.assertTrue((boolean)splitBundleSet.isEmpty());
        String path = PulsarWebResource.joinPath((String[])new String[]{"/admin/local-policies", nsname.toString()});
        byte[] content = this.pulsar.getLocalZkCache().getZooKeeper().getData(path, null, new Stat());
        Policies policies = (Policies)ObjectMapperFactory.getThreadLocal().readValue(content, Policies.class);
        NamespaceBundles localZkBundles = bundleFactory.getBundles(nsname, policies.bundles);
        Assert.assertEquals((Object)localZkBundles, (Object)updatedNsBundles);
        log.info("Policies: {}", (Object)policies);
        bundleList.forEach(b -> {
            try {
                byte[] data = this.pulsar.getLocalZkCache().getZooKeeper().getData(ServiceUnitUtils.path((NamespaceBundle)b), null, new Stat());
                NamespaceEphemeralData node = (NamespaceEphemeralData)ObjectMapperFactory.getThreadLocal().readValue(data, NamespaceEphemeralData.class);
                Assert.assertEquals((String)node.getNativeUrl(), (String)this.pulsar.getSafeBrokerServiceUrl());
            }
            catch (Exception e) {
                Assert.fail((String)"failed to setup ownership", (Throwable)e);
            }
        });
    }

    @Test
    public void testSplitMapWithRefreshedStatMap() throws Exception {
        OwnershipCache MockOwnershipCache = (OwnershipCache)Mockito.spy((Object)this.pulsar.getNamespaceService().getOwnershipCache());
        ManagedLedger ledger = (ManagedLedger)Mockito.mock(ManagedLedger.class);
        Mockito.when((Object)ledger.getCursors()).thenReturn((Object)Lists.newArrayList());
        ((OwnershipCache)Mockito.doReturn(CompletableFuture.completedFuture(null)).when((Object)MockOwnershipCache)).disableOwnership((NamespaceBundle)ArgumentMatchers.any(NamespaceBundle.class));
        Field ownership = NamespaceService.class.getDeclaredField("ownershipCache");
        ownership.setAccessible(true);
        ownership.set(this.pulsar.getNamespaceService(), MockOwnershipCache);
        NamespaceService namespaceService = this.pulsar.getNamespaceService();
        NamespaceName nsname = NamespaceName.get((String)"pulsar/global/ns1");
        TopicName topicName = TopicName.get((String)"persistent://pulsar/global/ns1/topic-1");
        NamespaceBundles bundles = namespaceService.getNamespaceBundleFactory().getBundles(nsname);
        NamespaceBundle originalBundle = bundles.findBundle(topicName);
        PersistentTopic topic = new PersistentTopic(topicName.toString(), ledger, this.pulsar.getBrokerService());
        Method method = this.pulsar.getBrokerService().getClass().getDeclaredMethod("addTopicToStatsMaps", TopicName.class, Topic.class);
        method.setAccessible(true);
        method.invoke((Object)this.pulsar.getBrokerService(), topicName, topic);
        String nspace = originalBundle.getNamespaceObject().toString();
        List list = this.pulsar.getBrokerService().getAllTopicsFromNamespaceBundle(nspace, originalBundle.toString());
        Assert.assertNotNull((Object)list);
        CompletableFuture result = namespaceService.splitAndOwnBundle(originalBundle, false, NamespaceBundleSplitAlgorithm.RANGE_EQUALLY_DIVIDE_ALGO);
        try {
            result.get();
        }
        catch (Exception e) {
            Assert.fail((String)"split bundle failed", (Throwable)e);
        }
        list = this.pulsar.getBrokerService().getAllTopicsFromNamespaceBundle(nspace, originalBundle.toString());
        Assert.assertTrue((boolean)list.isEmpty());
        NamespaceBundle splitBundle = this.pulsar.getNamespaceService().getBundle(topicName);
        Assert.assertFalse((boolean)CollectionUtils.isEmpty((Collection)this.pulsar.getBrokerService().getAllTopicsFromNamespaceBundle(nspace, splitBundle.toString())));
    }

    @Test
    public void testIsServiceUnitDisabled() throws Exception {
        OwnershipCache MockOwnershipCache = (OwnershipCache)Mockito.spy((Object)this.pulsar.getNamespaceService().getOwnershipCache());
        ManagedLedger ledger = (ManagedLedger)Mockito.mock(ManagedLedger.class);
        Mockito.when((Object)ledger.getCursors()).thenReturn((Object)Lists.newArrayList());
        ((OwnershipCache)Mockito.doReturn(CompletableFuture.completedFuture(null)).when((Object)MockOwnershipCache)).disableOwnership((NamespaceBundle)ArgumentMatchers.any(NamespaceBundle.class));
        Field ownership = NamespaceService.class.getDeclaredField("ownershipCache");
        ownership.setAccessible(true);
        ownership.set(this.pulsar.getNamespaceService(), MockOwnershipCache);
        NamespaceService namespaceService = this.pulsar.getNamespaceService();
        NamespaceName nsname = NamespaceName.get((String)"pulsar/global/ns1");
        TopicName topicName = TopicName.get((String)"persistent://pulsar/global/ns1/topic-1");
        NamespaceBundles bundles = namespaceService.getNamespaceBundleFactory().getBundles(nsname);
        NamespaceBundle originalBundle = bundles.findBundle(topicName);
        Assert.assertFalse((boolean)namespaceService.isNamespaceBundleDisabled(originalBundle));
    }

    @Test
    public void testRemoveOwnershipNamespaceBundle() throws Exception {
        OwnershipCache ownershipCache = (OwnershipCache)Mockito.spy((Object)this.pulsar.getNamespaceService().getOwnershipCache());
        ManagedLedger ledger = (ManagedLedger)Mockito.mock(ManagedLedger.class);
        Mockito.when((Object)ledger.getCursors()).thenReturn((Object)Lists.newArrayList());
        ((OwnershipCache)Mockito.doReturn(CompletableFuture.completedFuture(null)).when((Object)ownershipCache)).disableOwnership((NamespaceBundle)ArgumentMatchers.any(NamespaceBundle.class));
        Field ownership = NamespaceService.class.getDeclaredField("ownershipCache");
        ownership.setAccessible(true);
        ownership.set(this.pulsar.getNamespaceService(), ownershipCache);
        NamespaceService namespaceService = this.pulsar.getNamespaceService();
        NamespaceName nsname = NamespaceName.get((String)"prop/use/ns1");
        NamespaceBundles bundles = namespaceService.getNamespaceBundleFactory().getBundles(nsname);
        NamespaceBundle bundle = (NamespaceBundle)bundles.getBundles().get(0);
        ownershipCache.tryAcquiringOwnership(bundle).get();
        Assert.assertNotNull((Object)ownershipCache.getOwnedBundle(bundle));
        ownershipCache.removeOwnership(bundles).get();
        Assert.assertNull((Object)ownershipCache.getOwnedBundle(bundle));
    }

    @Test
    public void testUnloadNamespaceBundleFailure() throws Exception {
        String topicName = "persistent://my-property/use/my-ns/my-topic1";
        this.pulsarClient.newConsumer().topic(new String[]{"persistent://my-property/use/my-ns/my-topic1"}).subscriptionName("my-subscriber-name").subscribe();
        ConcurrentOpenHashMap topics = this.pulsar.getBrokerService().getTopics();
        Topic spyTopic = (Topic)Mockito.spy(((Optional)((CompletableFuture)topics.get((Object)"persistent://my-property/use/my-ns/my-topic1")).get()).get());
        topics.clear();
        CompletableFuture<Optional<Topic>> topicFuture = CompletableFuture.completedFuture(Optional.of(spyTopic));
        topics.put((Object)"persistent://my-property/use/my-ns/my-topic1", topicFuture);
        ((Topic)Mockito.doAnswer((Answer)new Answer<CompletableFuture<Void>>(){

            public CompletableFuture<Void> answer(InvocationOnMock invocation) {
                CompletableFuture<Void> result = new CompletableFuture<Void>();
                result.completeExceptionally(new RuntimeException("first time failed"));
                return result;
            }
        }).when((Object)spyTopic)).close(false);
        NamespaceBundle bundle = this.pulsar.getNamespaceService().getBundle(TopicName.get((String)"persistent://my-property/use/my-ns/my-topic1"));
        this.pulsar.getNamespaceService().unloadNamespaceBundle(bundle).join();
        try {
            this.pulsar.getLocalZkCache().getZooKeeper().getData(ServiceUnitUtils.path((NamespaceBundle)bundle), null, null);
            Assert.fail((String)"it should fail as node is not present");
        }
        catch (KeeperException.NoNodeException noNodeException) {
            // empty catch block
        }
    }

    @Test(timeOut=6000L)
    public void testUnloadNamespaceBundleWithStuckTopic() throws Exception {
        String topicName = "persistent://my-property/use/my-ns/my-topic1";
        Consumer consumer = this.pulsarClient.newConsumer().topic(new String[]{"persistent://my-property/use/my-ns/my-topic1"}).subscriptionName("my-subscriber-name").subscribe();
        ConcurrentOpenHashMap topics = this.pulsar.getBrokerService().getTopics();
        Topic spyTopic = (Topic)Mockito.spy(((Optional)((CompletableFuture)topics.get((Object)"persistent://my-property/use/my-ns/my-topic1")).get()).get());
        topics.clear();
        CompletableFuture<Optional<Topic>> topicFuture = CompletableFuture.completedFuture(Optional.of(spyTopic));
        topics.put((Object)"persistent://my-property/use/my-ns/my-topic1", topicFuture);
        ((Topic)Mockito.doAnswer((Answer)new Answer<CompletableFuture<Void>>(){

            public CompletableFuture<Void> answer(InvocationOnMock invocation) throws Throwable {
                return new CompletableFuture<Void>();
            }
        }).when((Object)spyTopic)).close(false);
        NamespaceBundle bundle = this.pulsar.getNamespaceService().getBundle(TopicName.get((String)"persistent://my-property/use/my-ns/my-topic1"));
        this.pulsar.getNamespaceService().unloadNamespaceBundle(bundle, 1L, TimeUnit.SECONDS).join();
        try {
            this.pulsar.getLocalZkCache().getZooKeeper().getData(ServiceUnitUtils.path((NamespaceBundle)bundle), null, null);
            Assert.fail((String)"it should fail as node is not present");
        }
        catch (KeeperException.NoNodeException noNodeException) {
            // empty catch block
        }
        consumer.close();
    }

    @Test
    public void testLoadReportDeserialize() throws Exception {
        String candidateBroker1 = "http://localhost:8000";
        String candidateBroker2 = "http://localhost:3000";
        LoadReport lr = new LoadReport(null, null, "http://localhost:8000", null);
        LocalBrokerData ld = new LocalBrokerData(null, null, "http://localhost:3000", null);
        URI uri1 = new URI("http://localhost:8000");
        URI uri2 = new URI("http://localhost:3000");
        String path1 = String.format("%s/%s:%s", "/loadbalance/brokers", uri1.getHost(), uri1.getPort());
        String path2 = String.format("%s/%s:%s", "/loadbalance/brokers", uri2.getHost(), uri2.getPort());
        ZkUtils.createFullPathOptimistic((ZooKeeper)this.pulsar.getZkClient(), (String)path1, (byte[])ObjectMapperFactory.getThreadLocal().writeValueAsBytes((Object)lr), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.EPHEMERAL);
        ZkUtils.createFullPathOptimistic((ZooKeeper)this.pulsar.getZkClient(), (String)path2, (byte[])ObjectMapperFactory.getThreadLocal().writeValueAsBytes((Object)ld), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.EPHEMERAL);
        LookupResult result1 = (LookupResult)this.pulsar.getNamespaceService().createLookupResult("http://localhost:8000", false, null).get();
        LoadManager oldLoadManager = (LoadManager)this.pulsar.getLoadManager().getAndSet(new ModularLoadManagerWrapper((ModularLoadManager)new ModularLoadManagerImpl()));
        oldLoadManager.stop();
        LookupResult result2 = (LookupResult)this.pulsar.getNamespaceService().createLookupResult("http://localhost:3000", false, null).get();
        Assert.assertEquals((String)result1.getLookupData().getBrokerUrl(), (String)"http://localhost:8000");
        Assert.assertEquals((String)result2.getLookupData().getBrokerUrl(), (String)"http://localhost:3000");
        System.out.println(result2);
    }

    @Test
    public void testCreateLookupResult() throws Exception {
        String candidateBroker = "pulsar://localhost:6650";
        String listenerUrl = "pulsar://localhost:7000";
        String listenerUrlTls = "pulsar://localhost:8000";
        String listener = "listenerName";
        HashMap advertisedListeners = Maps.newHashMap();
        advertisedListeners.put("listenerName", AdvertisedListener.builder().brokerServiceUrl(new URI("pulsar://localhost:7000")).brokerServiceUrlTls(new URI("pulsar://localhost:8000")).build());
        LocalBrokerData ld = new LocalBrokerData(null, null, "pulsar://localhost:6650", null, (Map)advertisedListeners);
        URI uri = new URI("pulsar://localhost:6650");
        String path = String.format("%s/%s:%s", "/loadbalance/brokers", uri.getHost(), uri.getPort());
        ZkUtils.createFullPathOptimistic((ZooKeeper)this.pulsar.getZkClient(), (String)path, (byte[])ObjectMapperFactory.getThreadLocal().writeValueAsBytes((Object)ld), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.EPHEMERAL);
        LookupResult noListener = (LookupResult)this.pulsar.getNamespaceService().createLookupResult("pulsar://localhost:6650", false, null).get();
        LookupResult withListener = (LookupResult)this.pulsar.getNamespaceService().createLookupResult("pulsar://localhost:6650", false, "listenerName").get();
        Assert.assertEquals((String)noListener.getLookupData().getBrokerUrl(), (String)"pulsar://localhost:6650");
        Assert.assertEquals((String)withListener.getLookupData().getBrokerUrl(), (String)"pulsar://localhost:7000");
        Assert.assertEquals((String)withListener.getLookupData().getBrokerUrlTls(), (String)"pulsar://localhost:8000");
        System.out.println(withListener);
    }

    @Test
    public void testCreateNamespaceWithDefaultNumberOfBundles() throws Exception {
        OwnershipCache MockOwnershipCache = (OwnershipCache)Mockito.spy((Object)this.pulsar.getNamespaceService().getOwnershipCache());
        ((OwnershipCache)Mockito.doReturn(CompletableFuture.completedFuture(null)).when((Object)MockOwnershipCache)).disableOwnership((NamespaceBundle)ArgumentMatchers.any(NamespaceBundle.class));
        Field ownership = NamespaceService.class.getDeclaredField("ownershipCache");
        ownership.setAccessible(true);
        ownership.set(this.pulsar.getNamespaceService(), MockOwnershipCache);
        NamespaceService namespaceService = this.pulsar.getNamespaceService();
        NamespaceName nsname = NamespaceName.get((String)"pulsar/global/ns1");
        TopicName topicName = TopicName.get((String)"persistent://pulsar/global/ns1/topic-1");
        NamespaceBundles bundles = namespaceService.getNamespaceBundleFactory().getBundles(nsname);
        NamespaceBundle originalBundle = bundles.findBundle(topicName);
        CompletableFuture result = namespaceService.splitAndOwnBundle(originalBundle, false, NamespaceBundleSplitAlgorithm.RANGE_EQUALLY_DIVIDE_ALGO);
        try {
            result.get();
        }
        catch (Exception e) {
            Assert.fail((String)"split bundle failed", (Throwable)e);
        }
        NamespaceBundleFactory bundleFactory = this.pulsar.getNamespaceService().getNamespaceBundleFactory();
        NamespaceBundles updatedNsBundles = bundleFactory.getBundles(nsname);
        Assert.assertNotNull((Object)updatedNsBundles);
        List bundleList = updatedNsBundles.getBundles();
        Assert.assertNotNull((Object)bundles);
        NamespaceBundleFactory utilityFactory = NamespaceBundleFactory.createFactory((PulsarService)this.pulsar, (HashFunction)Hashing.crc32());
        Pair<NamespaceBundles, List<NamespaceBundle>> splitBundles = this.splitBundles(utilityFactory, nsname, bundles, originalBundle);
        Assert.assertNotNull(splitBundles);
        HashSet splitBundleSet = new HashSet((Collection)splitBundles.getRight());
        splitBundleSet.removeAll(bundleList);
        Assert.assertTrue((boolean)splitBundleSet.isEmpty());
        String path = PulsarWebResource.joinPath((String[])new String[]{"/admin/local-policies", nsname.toString()});
        byte[] content = this.pulsar.getLocalZkCache().getZooKeeper().getData(path, null, new Stat());
        Policies policies = (Policies)ObjectMapperFactory.getThreadLocal().readValue(content, Policies.class);
        NamespaceBundles localZkBundles = bundleFactory.getBundles(nsname, policies.bundles);
        Assert.assertEquals((Object)localZkBundles, (Object)updatedNsBundles);
        log.info("Policies: {}", (Object)policies);
        bundleList.forEach(b -> {
            try {
                byte[] data = this.pulsar.getLocalZkCache().getZooKeeper().getData(ServiceUnitUtils.path((NamespaceBundle)b), null, new Stat());
                NamespaceEphemeralData node = (NamespaceEphemeralData)ObjectMapperFactory.getThreadLocal().readValue(data, NamespaceEphemeralData.class);
                Assert.assertEquals((String)node.getNativeUrl(), (String)this.pulsar.getSafeBrokerServiceUrl());
            }
            catch (Exception e) {
                Assert.fail((String)"failed to setup ownership", (Throwable)e);
            }
        });
    }

    @Test
    public void testRemoveOwnershipAndSplitBundle() throws Exception {
        OwnershipCache ownershipCache = (OwnershipCache)Mockito.spy((Object)this.pulsar.getNamespaceService().getOwnershipCache());
        ((OwnershipCache)Mockito.doReturn(CompletableFuture.completedFuture(null)).when((Object)ownershipCache)).disableOwnership((NamespaceBundle)ArgumentMatchers.any(NamespaceBundle.class));
        Field ownership = NamespaceService.class.getDeclaredField("ownershipCache");
        ownership.setAccessible(true);
        ownership.set(this.pulsar.getNamespaceService(), ownershipCache);
        NamespaceService namespaceService = this.pulsar.getNamespaceService();
        NamespaceName nsname = NamespaceName.get((String)"pulsar/global/ns1");
        TopicName topicName = TopicName.get((String)"persistent://pulsar/global/ns1/topic-1");
        NamespaceBundles bundles = namespaceService.getNamespaceBundleFactory().getBundles(nsname);
        NamespaceBundle originalBundle = bundles.findBundle(topicName);
        CompletableFuture result1 = namespaceService.splitAndOwnBundle(originalBundle, false, NamespaceBundleSplitAlgorithm.RANGE_EQUALLY_DIVIDE_ALGO);
        try {
            result1.get();
        }
        catch (Exception e) {
            Assert.fail((String)"split bundle failed", (Throwable)e);
        }
        NamespaceBundles updatedNsBundles = namespaceService.getNamespaceBundleFactory().getBundles(nsname);
        Assert.assertNotNull((Object)updatedNsBundles);
        NamespaceBundle splittedBundle = updatedNsBundles.findBundle(topicName);
        updatedNsBundles.getBundles().stream().filter(bundle -> !bundle.equals((Object)splittedBundle)).forEach(bundle -> {
            try {
                ownershipCache.removeOwnership(bundle).get();
            }
            catch (Exception e) {
                Assert.fail((String)"failed to remove ownership", (Throwable)e);
            }
        });
        CompletableFuture result2 = namespaceService.splitAndOwnBundle(splittedBundle, true, NamespaceBundleSplitAlgorithm.RANGE_EQUALLY_DIVIDE_ALGO);
        try {
            result2.get();
        }
        catch (Exception e) {
            Assert.fail((String)"split bundle failed", (Throwable)e);
        }
    }

    private Pair<NamespaceBundles, List<NamespaceBundle>> splitBundles(NamespaceBundleFactory utilityFactory, NamespaceName nsname, NamespaceBundles bundles, NamespaceBundle targetBundle) throws Exception {
        Field bCacheField = NamespaceBundleFactory.class.getDeclaredField("bundlesCache");
        bCacheField.setAccessible(true);
        ((AsyncLoadingCache)bCacheField.get(utilityFactory)).put((Object)nsname, CompletableFuture.completedFuture(bundles));
        return (Pair)utilityFactory.splitBundles(targetBundle, 2, null).join();
    }
}

