/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.protocol;

import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.protocol.ProtocolHandler;
import org.apache.pulsar.broker.protocol.ProtocolHandlerWithClassLoader;
import org.apache.pulsar.broker.service.BrokerService;
import org.apache.pulsar.common.nar.NarClassLoader;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"broker"})
public class ProtocolHandlerWithClassLoaderTest {
    @Test
    public void testWrapper() throws Exception {
        ProtocolHandler h = (ProtocolHandler)Mockito.mock(ProtocolHandler.class);
        NarClassLoader loader = (NarClassLoader)Mockito.mock(NarClassLoader.class);
        ProtocolHandlerWithClassLoader wrapper = new ProtocolHandlerWithClassLoader(h, loader);
        String protocol = "kafka";
        Mockito.when((Object)h.protocolName()).thenReturn((Object)protocol);
        Assert.assertEquals((String)protocol, (String)wrapper.protocolName());
        ((ProtocolHandler)Mockito.verify((Object)h, (VerificationMode)Mockito.times((int)1))).protocolName();
        Mockito.when((Object)h.accept((String)ArgumentMatchers.eq((Object)protocol))).thenReturn((Object)true);
        Assert.assertTrue((boolean)wrapper.accept(protocol));
        ((ProtocolHandler)Mockito.verify((Object)h, (VerificationMode)Mockito.times((int)1))).accept((String)ArgumentMatchers.same((Object)protocol));
        ServiceConfiguration conf = new ServiceConfiguration();
        wrapper.initialize(conf);
        ((ProtocolHandler)Mockito.verify((Object)h, (VerificationMode)Mockito.times((int)1))).initialize((ServiceConfiguration)ArgumentMatchers.same((Object)conf));
        BrokerService service = (BrokerService)Mockito.mock(BrokerService.class);
        wrapper.start(service);
        ((ProtocolHandler)Mockito.verify((Object)h, (VerificationMode)Mockito.times((int)1))).start(service);
        String protocolData = "test-protocol-data";
        Mockito.when((Object)h.getProtocolDataToAdvertise()).thenReturn((Object)protocolData);
        Assert.assertEquals((String)protocolData, (String)wrapper.getProtocolDataToAdvertise());
        ((ProtocolHandler)Mockito.verify((Object)h, (VerificationMode)Mockito.times((int)1))).getProtocolDataToAdvertise();
    }
}

