/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.resourcegroup;

import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.broker.auth.MockedPulsarServiceBaseTest;
import org.apache.pulsar.broker.resourcegroup.ResourceGroup;
import org.apache.pulsar.broker.resourcegroup.ResourceGroupConfigInfo;
import org.apache.pulsar.broker.resourcegroup.ResourceGroupService;
import org.apache.pulsar.broker.resourcegroup.ResourceQuotaCalculator;
import org.apache.pulsar.broker.resourcegroup.ResourceUsageTransportManager;
import org.apache.pulsar.broker.service.resource.usage.NetworkUsage;
import org.apache.pulsar.broker.service.resource.usage.ResourceUsage;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class ResourceGroupServiceTest
extends MockedPulsarServiceBaseTest {
    private ResourceGroupService rgs;
    int numAnonymousQuotaCalculations = 0;
    private static final Logger log = LoggerFactory.getLogger(ResourceGroupServiceTest.class);
    private static final int PUBLISH_INTERVAL_SECS = 500;

    @Override
    @BeforeClass
    protected void setup() throws Exception {
        super.internalSetup();
        this.prepareData();
        ResourceQuotaCalculator dummyQuotaCalc = new ResourceQuotaCalculator(){
            private long numLocalReportsEvaluated;

            public boolean needToReportLocalUsage(long currentBytesUsed, long lastReportedBytes, long currentMessagesUsed, long lastReportedMessages, long lastReportTimeMSecsSinceEpoch) {
                int maxSuppressRounds = 5;
                return ++this.numLocalReportsEvaluated % 5L == 4L;
            }

            public long computeLocalQuota(long confUsage, long myUsage, long[] allUsages) {
                return ++ResourceGroupServiceTest.this.numAnonymousQuotaCalculations;
            }
        };
        ResourceUsageTransportManager transportMgr = new ResourceUsageTransportManager(this.pulsar);
        this.rgs = new ResourceGroupService(this.pulsar, TimeUnit.MILLISECONDS, transportMgr, dummyQuotaCalc);
    }

    @Override
    @AfterClass(alwaysRun=true)
    protected void cleanup() throws Exception {
        log.info("numAnonymousQuotaCalculations={}", (Object)this.numAnonymousQuotaCalculations);
        super.internalCleanup();
    }

    @Test
    public void measureOpsTime() throws PulsarAdminException {
        ResourceGroup.ResourceGroupMonitoringClass monClass;
        int numPerfTestIterations = 10000000;
        ResourceGroupConfigInfo rgConfig = new ResourceGroupConfigInfo();
        rgConfig.setName("measureRGIncStatTime");
        ResourceGroup.BytesAndMessagesCount stats = new ResourceGroup.BytesAndMessagesCount();
        this.rgs.resourceGroupCreate(rgConfig);
        ResourceGroup rg = this.rgs.resourceGroupGet(rgConfig.getName());
        long mSecsStart = System.currentTimeMillis();
        for (int ix = 0; ix < 10000000; ++ix) {
            for (int monClassIdx = 0; monClassIdx < ResourceGroup.ResourceGroupMonitoringClass.values().length; ++monClassIdx) {
                monClass = ResourceGroup.ResourceGroupMonitoringClass.values()[monClassIdx];
                rg.incrementLocalUsageStats(monClass, stats);
            }
        }
        long mSecsEnd = System.currentTimeMillis();
        long diffMsecs = mSecsEnd - mSecsStart;
        log.info("{} iterations of incrementLocalUsageStats on retRG in {} msecs ({} usecs for each)", new Object[]{10000000, diffMsecs, Float.valueOf(1000.0f * (float)diffMsecs / 1.0E7f)});
        String tenantName = "SomeTenant";
        String namespaceName = "SomeNameSpace";
        this.rgs.registerTenant(rgConfig.getName(), "SomeTenant");
        this.rgs.registerNameSpace(rgConfig.getName(), "SomeNameSpace");
        mSecsStart = System.currentTimeMillis();
        for (int ix = 0; ix < 10000000; ++ix) {
            for (int monClassIdx = 0; monClassIdx < ResourceGroup.ResourceGroupMonitoringClass.values().length; ++monClassIdx) {
                monClass = ResourceGroup.ResourceGroupMonitoringClass.values()[monClassIdx];
                this.rgs.incrementUsage("SomeTenant", "SomeNameSpace", monClass, stats);
            }
        }
        mSecsEnd = System.currentTimeMillis();
        diffMsecs = mSecsEnd - mSecsStart;
        log.info("{} iterations of incrementUsage on RGS in {} msecs ({} usecs for each)", new Object[]{10000000, diffMsecs, Float.valueOf(1000.0f * (float)diffMsecs / 1.0E7f)});
        this.rgs.unRegisterTenant(rgConfig.getName(), "SomeTenant");
        this.rgs.unRegisterNameSpace(rgConfig.getName(), "SomeNameSpace");
        mSecsStart = System.currentTimeMillis();
        for (int ix = 0; ix < 10000000; ++ix) {
            ResourceGroup retRG = this.rgs.resourceGroupGet(rg.resourceGroupName);
        }
        mSecsEnd = System.currentTimeMillis();
        diffMsecs = mSecsEnd - mSecsStart;
        log.info("{} iterations of GET on RGS in {} msecs ({} usecs for each)", new Object[]{10000000, diffMsecs, Float.valueOf(1000.0f * (float)diffMsecs / 1.0E7f)});
        this.rgs.resourceGroupDelete(rgConfig.getName());
    }

    @Test
    public void testResourceGroupOps() throws PulsarAdminException, InterruptedException {
        ResourceGroupConfigInfo rgConfig = new ResourceGroupConfigInfo();
        rgConfig.setName("testRG");
        rgConfig.setPublishBytesPerPeriod(15000L);
        rgConfig.setPublishMessagesPerPeriod(100L);
        rgConfig.setDispatchBytesPerPeriod(40000L);
        rgConfig.setDispatchMessagesPerPeriod(500L);
        this.rgs.resourceGroupCreate(rgConfig);
        Assert.assertThrows(PulsarAdminException.class, () -> this.rgs.resourceGroupCreate(rgConfig));
        ResourceGroupConfigInfo randomConfig = new ResourceGroupConfigInfo();
        randomConfig.setName("Something");
        Assert.assertThrows(PulsarAdminException.class, () -> this.rgs.resourceGroupUpdate(randomConfig));
        rgConfig.setPublishBytesPerPeriod(rgConfig.getPublishBytesPerPeriod() * 10L);
        rgConfig.setPublishMessagesPerPeriod(rgConfig.getPublishMessagesPerPeriod() * 10L);
        rgConfig.setDispatchBytesPerPeriod(rgConfig.getDispatchBytesPerPeriod() / 10L);
        rgConfig.setDispatchMessagesPerPeriod(randomConfig.getDispatchMessagesPerPeriod() / 10L);
        this.rgs.resourceGroupUpdate(rgConfig);
        Assert.assertEquals((long)this.rgs.getNumResourceGroups(), (long)1L);
        ResourceGroup retRG = null;
        retRG = this.rgs.resourceGroupGet(randomConfig.getName());
        Assert.assertEquals((Object)retRG, null);
        retRG = this.rgs.resourceGroupGet(rgConfig.getName());
        Assert.assertNotEquals((Object)retRG, null);
        ResourceGroup.PerMonitoringClassFields monClassFields = retRG.monitoringClassFields[ResourceGroup.ResourceGroupMonitoringClass.Publish.ordinal()];
        Assert.assertEquals((long)monClassFields.configValuesPerPeriod.bytes, (long)rgConfig.getPublishBytesPerPeriod());
        Assert.assertEquals((long)monClassFields.configValuesPerPeriod.messages, (long)rgConfig.getPublishMessagesPerPeriod());
        monClassFields = retRG.monitoringClassFields[ResourceGroup.ResourceGroupMonitoringClass.Dispatch.ordinal()];
        Assert.assertEquals((long)monClassFields.configValuesPerPeriod.bytes, (long)rgConfig.getDispatchBytesPerPeriod());
        Assert.assertEquals((long)monClassFields.configValuesPerPeriod.messages, (long)rgConfig.getDispatchMessagesPerPeriod());
        Assert.assertThrows(PulsarAdminException.class, () -> this.rgs.resourceGroupDelete(randomConfig.getName()));
        Assert.assertEquals((long)this.rgs.getNumResourceGroups(), (long)1L);
        String SOME_RANDOM_TOPIC = "persistent://FakeTenant/FakeNameSpace/FakeTopic";
        TopicName topic = TopicName.get((String)"persistent://FakeTenant/FakeNameSpace/FakeTopic");
        String tenantName = topic.getTenant();
        String namespaceName = topic.getNamespacePortion();
        this.rgs.registerTenant(rgConfig.getName(), tenantName);
        this.rgs.registerNameSpace(rgConfig.getName(), namespaceName);
        Assert.assertThrows(PulsarAdminException.class, () -> this.rgs.resourceGroupDelete(rgConfig.getName()));
        ResourceUsage usage = new ResourceUsage();
        for (int monClassIdx = 0; monClassIdx < ResourceGroup.ResourceGroupMonitoringClass.values().length; ++monClassIdx) {
            ResourceGroup.ResourceGroupMonitoringClass monClass = ResourceGroup.ResourceGroupMonitoringClass.values()[monClassIdx];
            NetworkUsage nwUsage = monClass == ResourceGroup.ResourceGroupMonitoringClass.Publish ? usage.setPublish() : usage.setDispatch();
            HashSet<Boolean> myBoolSet = new HashSet<Boolean>();
            myBoolSet.clear();
            for (int idx = 0; idx < 5; ++idx) {
                boolean needToReport = retRG.setUsageInMonitoredEntity(monClass, nwUsage);
                myBoolSet.add(needToReport);
            }
            Assert.assertTrue((boolean)myBoolSet.contains(true));
            Assert.assertTrue((boolean)myBoolSet.contains(false));
        }
        this.rgs.unRegisterTenant(rgConfig.getName(), tenantName);
        this.rgs.unRegisterNameSpace(rgConfig.getName(), namespaceName);
        this.rgs.resourceGroupDelete(rgConfig.getName());
        Assert.assertEquals((long)this.rgs.getNumResourceGroups(), (long)0L);
    }

    private void prepareData() throws PulsarAdminException {
        this.conf.setResourceUsageTransportPublishIntervalInSecs(500);
        this.admin.clusters().createCluster("test", new ClusterData(this.pulsar.getBrokerServiceUrl()));
    }
}

